/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entity;

import com.majruszlibrary.animations.Animations;
import com.majruszlibrary.animations.AnimationsDef;
import com.majruszlibrary.animations.IAnimableEntity;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.modhelper.Resource;
import com.majruszsdifficulty.MajruszsDifficulty;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class Tank
extends class_1588
implements IAnimableEntity {
    private static final Resource<AnimationsDef> ANIMATIONS = MajruszsDifficulty.HELPER.load("tank_animations", AnimationsDef.class);
    private final Animations animations = Animations.create();

    public static class_1299<Tank> createEntityType() {
        return class_1299.class_1300.method_5903(Tank::new, (class_1311)class_1311.field_6302).method_17687(0.99f, 2.7f).method_5905("tank");
    }

    public static class_5132 createAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 140.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23717, 30.0).method_26868(class_5134.field_23722, 3.5).method_26868(class_5134.field_23718, 0.75).method_26866();
    }

    public Tank(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
    }

    public int method_6110() {
        return Random.nextInt((int)10, (int)17);
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    public float method_49476() {
        return 1.6f;
    }

    public void method_5783(class_3414 sound, float volume, float pitch) {
        if (!this.method_5701()) {
            SoundEmitter.of((class_3414)sound).volume(SoundEmitter.randomized((float)(volume * 1.25f))).pitch(SoundEmitter.randomized((float)(pitch * 0.75f))).source(this.method_5634()).position(this.method_19538()).emit(this.method_37908());
        }
    }

    protected class_3414 method_5994() {
        return class_3417.field_15200;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 2.35f;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15069;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14877;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(class_3417.field_14548, 0.15f, 1.0f);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5972()) {
            this.method_5639(8);
        }
    }

    public AnimationsDef getAnimationsDef() {
        return (AnimationsDef)ANIMATIONS.get();
    }

    public Animations getAnimations() {
        return this.animations;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new TankMeleeAttackGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    private static class TankMeleeAttackGoal
    extends class_1366 {
        private final Tank tank;

        public TankMeleeAttackGoal(Tank tank) {
            super((class_1314)tank, 1.0, true);
            this.tank = tank;
        }

        public void method_6268() {
            super.method_6268();
            this.tank.method_19540(!this.tank.animations.isEmpty());
        }

        protected void method_6288(class_1309 target, double distanceSqr) {
            if (distanceSqr > this.method_6289(target) || !this.tank.animations.isEmpty()) {
                return;
            }
            this.method_28346();
            if (Random.check((float)0.25f)) {
                this.useHeavyAttack(target);
            } else {
                this.useNormalAttack(target);
            }
        }

        private void useHeavyAttack(class_1309 target) {
            this.tank.playAnimation("heavy_attack").addCallback(11, () -> {
                class_1937 patt5701$temp = target.method_37908();
                if (!(patt5701$temp instanceof class_3218)) {
                    return;
                }
                class_3218 level = (class_3218)patt5701$temp;
                class_243 position = this.getHeavyAttackPosition();
                this.spawnGroundParticles(level, position);
                this.hitAllNearbyEntities(level, position);
                this.playHitSound(1.5f);
            });
        }

        private void useNormalAttack(class_1309 target) {
            this.tank.playAnimation((String)Random.next((Object[])new String[]{"normal_attack_left", "normal_attack_right"})).addCallback(9, () -> {
                if (this.tryToHitEntity(target)) {
                    this.playHitSound(0.8f);
                }
            });
        }

        private void hitAllNearbyEntities(class_3218 level, class_243 position) {
            for (class_1309 entity : EntityHelper.getEntitiesNearby(class_1309.class, (class_3218)level, (class_243)position, (double)2.5)) {
                class_3222 player;
                if (entity.equals((Object)this.tank) || !this.tryToHitEntity(entity) || !(entity instanceof class_3222) || !(player = (class_3222)entity).method_6039()) continue;
                player.method_7284(true);
            }
        }

        private boolean tryToHitEntity(class_1309 entity) {
            if (this.tank.method_18391(entity, class_4051.field_18092)) {
                return this.tank.method_6121((class_1297)entity);
            }
            return false;
        }

        private class_243 getHeavyAttackPosition() {
            return AnyPos.from((class_243)this.tank.method_19538()).add(EntityHelper.getDirection2d((class_1297)this.tank).mul((Number)2.0)).vec3();
        }

        private void spawnGroundParticles(class_3218 level, class_243 position) {
            class_2680 blockState = LevelHelper.findBlockPosOnGround((class_1937)level, (class_243)position, (Number)5).map(blockPos -> level.method_8320(blockPos.method_10074())).orElse(class_2246.field_10566.method_9564());
            ParticleEmitter.of((class_2394)new class_2388(class_2398.field_11217, blockState)).position(AnyPos.from((class_243)position).add((Number)0.0, (Number)0.25, (Number)0.0).vec3()).offset(() -> new class_243(1.0, 0.25, 1.0)).count(120).speed(0.5f).emit((class_1937)level);
        }

        private void playHitSound(float factor) {
            this.field_6503.method_5783(class_3417.field_15069, 0.75f * factor, 0.8f / factor);
        }
    }
}

