/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntitySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.events.base.CustomCondition;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.mixin.IMixinCreeper;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class CreeperExplodeBehindWall {
    private static boolean IS_ENABLED = true;
    private static GameStage REQUIRED_GAME_STAGE = GameStageHelper.find("expert");
    private static float CHANCE = 1.0f;
    private static boolean IS_SCALED_BY_CRD = false;

    private static void modifyAI(OnEntitySpawned data) {
        class_1548 creeper = (class_1548)data.entity;
        EntityHelper.getGoalSelector((class_1308)creeper).method_6277(1, (class_1352)new ExplodeBehindWallGoal(creeper));
    }

    static {
        OnEntitySpawned.listen(CreeperExplodeBehindWall::modifyAI).addCondition(Condition.isLogicalServer()).addCondition(Condition.chanceCRD(() -> Float.valueOf(CHANCE), () -> IS_SCALED_BY_CRD)).addCondition(data -> IS_ENABLED).addCondition(CustomCondition.check(REQUIRED_GAME_STAGE)).addCondition(data -> data.entity instanceof class_1548);
        Serializables.getStatic(Config.Features.class).define("creeper_explode_behind_wall", CreeperExplodeBehindWall.class);
        Serializables.getStatic(CreeperExplodeBehindWall.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
            IS_ENABLED = v;
        }).define("required_game_stage", Reader.string(), () -> REQUIRED_GAME_STAGE.getId(), v -> {
            REQUIRED_GAME_STAGE = GameStageHelper.find(v);
        }).define("chance", Reader.number(), () -> Float.valueOf(CHANCE), v -> {
            CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("is_scaled_by_crd", Reader.bool(), () -> IS_SCALED_BY_CRD, v -> {
            IS_SCALED_BY_CRD = v;
        });
    }

    public static class ExplodeBehindWallGoal
    extends class_1352 {
        private static final double MAXIMUM_START_DISTANCE = 19.0;
        private static final double MAXIMUM_EXPLODE_DISTANCE = 49.0;
        private static final double OFFSET = 16.0;
        private final class_1548 creeper;
        private class_1309 attackTarget;

        public ExplodeBehindWallGoal(class_1548 creeper) {
            this.creeper = creeper;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1657 target = this.getNearestPlayer(this.creeper);
            return this.creeper.method_7007() > 0 || target != null && this.creeper.method_5858((class_1297)target) < 19.0 * this.getDistanceMultiplier();
        }

        public void method_6269() {
            this.creeper.method_5942().method_6340();
            this.attackTarget = this.getNearestPlayer(this.creeper);
        }

        public void method_6270() {
            this.attackTarget = null;
        }

        public void method_6268() {
            if (this.attackTarget == null || this.creeper.method_5858((class_1297)this.attackTarget) > 49.0 * this.getDistanceMultiplier()) {
                this.creeper.method_7005(-1);
            } else {
                this.creeper.method_7005(1);
            }
        }

        private double getDistanceMultiplier() {
            double sizeMultiplier = (float)((IMixinCreeper)this.creeper).getExplosionRadius() / 3.0f;
            double chargedMultiplier = this.creeper.method_6872() ? 2.0 : 1.0;
            return sizeMultiplier * chargedMultiplier;
        }

        @Nullable
        private class_1657 getNearestPlayer(class_1548 creeper) {
            class_1937 class_19372 = creeper.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                return null;
            }
            class_3218 level = (class_3218)class_19372;
            class_1657 nearestPlayer = null;
            for (class_1657 player : EntityHelper.getEntitiesNearby(class_1657.class, (class_3218)level, (class_243)creeper.method_19538(), (double)16.0)) {
                if (EntityHelper.isOnCreativeMode((class_1657)player) || EntityHelper.isOnSpectatorMode((class_1657)player) || nearestPlayer != null && !(creeper.method_5858((class_1297)player) < creeper.method_5858((class_1297)nearestPlayer))) continue;
                nearestPlayer = player;
            }
            return nearestPlayer;
        }
    }
}

