/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.command.Command;
import com.majruszlibrary.command.CommandData;
import com.majruszlibrary.command.IParameter;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntitySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.platform.Side;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmyHelper;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1405;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_4051;

public class MobGroups {
    private static Map<String, GroupDef> GROUPS = Map.of("skeletons", new GroupDef("normal", 0.1f, true, List.of(new LeaderDef(class_1299.field_6137, MajruszsDifficulty.HELPER.getLocation("mob_groups/skeleton_leader"))), (Range<Integer>)Range.of((Number)1, (Number)3), List.of(new SidekickDef(class_1299.field_6137, MajruszsDifficulty.HELPER.getLocation("mob_groups/skeleton_sidekick")))), "undead", new GroupDef("normal", 0.1f, true, List.of(new LeaderDef(class_1299.field_6137, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_3_skeleton")), new LeaderDef(class_1299.field_6098, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_3_skeleton")), new LeaderDef(class_1299.field_6051, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_3_mob")), new LeaderDef(class_1299.field_6071, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_3_mob"))), (Range<Integer>)Range.of((Number)2, (Number)4), List.of(new SidekickDef(class_1299.field_6137, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_2_mob")), new SidekickDef(class_1299.field_6098, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_2_mob")), new SidekickDef(class_1299.field_6051, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_2_mob")), new SidekickDef(class_1299.field_6071, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_2_mob")))), "zombie_miners", new GroupDef("expert", 0.25f, true, List.of(new LeaderDef(class_1299.field_6051, MajruszsDifficulty.HELPER.getLocation("mob_groups/zombie_leader"))), (Range<Integer>)Range.of((Number)1, (Number)3), List.of(new SidekickDef(class_1299.field_6051, MajruszsDifficulty.HELPER.getLocation("mob_groups/zombie_sidekick")))), "piglins", new GroupDef("expert", 0.25f, true, List.of(new LeaderDef(class_1299.field_22281, MajruszsDifficulty.HELPER.getLocation("mob_groups/piglin_leader"))), (Range<Integer>)Range.of((Number)1, (Number)3), List.of(new SidekickDef(class_1299.field_22281, MajruszsDifficulty.HELPER.getLocation("mob_groups/piglin_sidekick")))));
    private static final IParameter<String> NAME = Command.string().named("name").suggests(() -> GROUPS.keySet().stream().toList());

    private static void tryToSpawnGroup(OnEntitySpawned data) {
        class_1314 leader = (class_1314)data.entity;
        GameStage gameStage = GameStageHelper.determineGameStage(data);
        for (Map.Entry<String, GroupDef> entry : GROUPS.entrySet()) {
            LeaderDef leaderDef;
            String id = entry.getKey();
            if (id.equals("zombie_miners") && data.entity.method_19538().field_1351 > 50.0) continue;
            GroupDef groupDef = entry.getValue();
            if (groupDef.requiredGameStage.getOrdinal() > gameStage.getOrdinal() || (leaderDef = (LeaderDef)Random.next(groupDef.leaders.stream().filter(def -> def.type.equals((Object)leader.method_5864())).toList())) == null) continue;
            double chance = (double)groupDef.chance * (groupDef.isScaledByCRD ? LevelHelper.getClampedRegionalDifficultyAt((class_1937)data.getLevel(), (class_2338)leader.method_24515()) : 1.0);
            if (!Random.check((double)chance)) continue;
            MobGroups.spawn((class_1314)data.entity, groupDef);
            MobGroups.giveItems(leader, leaderDef.equipment);
            break;
        }
    }

    private static void spawn(class_1314 leader, GroupDef groupDef) {
        class_1937 level = leader.method_37908();
        int count = Random.nextInt(groupDef.count);
        for (int idx = 0; idx < count; ++idx) {
            SidekickDef sidekickDef = (SidekickDef)Random.next(groupDef.sidekicks);
            class_1297 entity = EntityHelper.createSpawner(() -> sidekickDef.type, (class_1937)level).position(MobGroups.getRandomizedPosition(level, leader.method_19538())).mobSpawnType(class_3730.field_16467).spawn();
            if (!(entity instanceof class_1314)) continue;
            class_1314 sidekick = (class_1314)entity;
            MobGroups.addSidekickGoals(sidekick, leader);
            MobGroups.giveItems(sidekick, sidekickDef.equipment);
        }
    }

    private static void giveItems(class_1314 mob, class_2960 id) {
        LootHelper.getLootTable((class_2960)id).method_51878(LootHelper.toGiftParams((class_1297)mob)).forEach(itemStack -> ItemHelper.equip((class_1308)mob, (class_1799)itemStack));
        Arrays.stream(class_1304.values()).forEach(slot -> mob.method_5946(slot, 0.05f));
    }

    private static void addSidekickGoals(class_1314 sidekick, class_1314 leader) {
        EntityHelper.getGoalSelector((class_1308)sidekick).method_6277(1, (class_1352)new FollowGroupLeaderGoal((class_1308)sidekick, (class_1308)leader, 1.0, 6.0f, 5.0f));
        EntityHelper.getTargetSelector((class_1308)sidekick).method_6277(1, (class_1352)new TargetAsLeaderGoal(sidekick, leader));
    }

    private static class_243 getRandomizedPosition(class_1937 level, class_243 position) {
        for (int idx = 0; idx < 3; ++idx) {
            class_243 newPosition = AnyPos.from((class_243)position).add((Number)Random.nextInt((int)-3, (int)4), (Number)0.0, (Number)Random.nextInt((int)-3, (int)4)).vec3();
            Optional spawnPoint = LevelHelper.findBlockPosOnGround((class_1937)level, (Number)newPosition.field_1352, (Range)Range.of((Number)(newPosition.field_1351 - 3.0), (Number)(newPosition.field_1351 + 3.0)), (Number)newPosition.field_1350);
            if (!spawnPoint.isPresent()) continue;
            return AnyPos.from((class_2338)((class_2338)spawnPoint.get())).add((Number)0.5, (Number)0.0, (Number)0.5).vec3();
        }
        return position;
    }

    private static int spawn(CommandData data) throws CommandSyntaxException {
        class_1297 class_12972 = data.getCaller();
        if (!(class_12972 instanceof class_1657)) {
            return -1;
        }
        class_1657 player = (class_1657)class_12972;
        String name = (String)data.get(NAME);
        GroupDef groupDef = GROUPS.get(name);
        if (groupDef == null) {
            return -1;
        }
        LeaderDef leaderDef = (LeaderDef)Random.next(groupDef.leaders);
        class_1297 entity = EntityHelper.createSpawner(() -> leaderDef.type, (class_1937)player.method_37908()).position(player.method_19538()).mobSpawnType(class_3730.field_16462).spawn();
        if (!(entity instanceof class_1314)) {
            return -1;
        }
        class_1314 leader = (class_1314)entity;
        MobGroups.spawn(leader, groupDef);
        MobGroups.giveItems(leader, leaderDef.equipment);
        return 0;
    }

    static {
        OnEntitySpawned.listen(MobGroups::tryToSpawnGroup).addCondition(Condition.isLogicalServer()).addCondition(data -> !data.isLoadedFromDisk).addCondition(data -> data.entity instanceof class_1314).addCondition(data -> !data.getLevel().equals(Side.getServer().method_30002()) || !UndeadArmyHelper.isPartOfUndeadArmy(data.entity));
        Command.create().literal(new String[]{"summongroup"}).hasPermission(4).parameter(NAME).execute(MobGroups::spawn).register();
        Serializables.getStatic(Config.Features.class).define("mob_groups", Reader.map((IReader)Reader.custom(GroupDef::new)), () -> GROUPS, v -> {
            GROUPS = v;
        });
        Serializables.get(GroupDef.class).define("required_game_stage", Reader.string(), s -> s.requiredGameStage.getId(), (s, v) -> {
            s.requiredGameStage = GameStageHelper.find(v);
        }).define("chance", Reader.number(), s -> Float.valueOf(s.chance), (s, v) -> {
            s.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("is_scaled_by_crd", Reader.bool(), s -> s.isScaledByCRD, (s, v) -> {
            s.isScaledByCRD = v;
        }).define("leader_types", Reader.list((IReader)Reader.custom(LeaderDef::new)), s -> s.leaders, (s, v) -> {
            s.leaders = v;
        }).define("sidekicks_count", Reader.range((IReader)Reader.integer()), s -> s.count, (s, v) -> {
            s.count = Range.of((Number)1, (Number)10).clamp(v);
        }).define("sidekick_types", Reader.list((IReader)Reader.custom(SidekickDef::new)), s -> s.sidekicks, (s, v) -> {
            s.sidekicks = v;
        });
        Serializables.get(LeaderDef.class).define("type", Reader.entityType(), s -> s.type, (s, v) -> {
            s.type = v;
        }).define("equipment", Reader.location(), s -> s.equipment, (s, v) -> {
            s.equipment = v;
        });
        Serializables.get(SidekickDef.class).define("type", Reader.entityType(), s -> s.type, (s, v) -> {
            s.type = v;
        }).define("equipment", Reader.location(), s -> s.equipment, (s, v) -> {
            s.equipment = v;
        });
    }

    public static class GroupDef {
        public GameStage requiredGameStage = GameStageHelper.find("normal");
        public float chance = 0.0f;
        public boolean isScaledByCRD = false;
        public List<LeaderDef> leaders = List.of();
        public Range<Integer> count = Range.of((Number)1, (Number)10);
        public List<SidekickDef> sidekicks = List.of();

        public GroupDef(String gameStageId, float chance, boolean isScaledByCRD, List<LeaderDef> leaders, Range<Integer> count, List<SidekickDef> sidekicks) {
            this.requiredGameStage = GameStageHelper.find(gameStageId);
            this.chance = chance;
            this.isScaledByCRD = isScaledByCRD;
            this.leaders = leaders;
            this.count = count;
            this.sidekicks = sidekicks;
        }

        public GroupDef() {
        }
    }

    public static class LeaderDef {
        public class_1299<?> type;
        public class_2960 equipment;

        public LeaderDef(class_1299<?> type, class_2960 equipment) {
            this.type = type;
            this.equipment = equipment;
        }

        public LeaderDef() {
        }
    }

    public static class SidekickDef {
        public class_1299<?> type;
        public class_2960 equipment;

        public SidekickDef(class_1299<?> type, class_2960 equipment) {
            this.type = type;
            this.equipment = equipment;
        }

        public SidekickDef() {
        }
    }

    public static class FollowGroupLeaderGoal
    extends class_1352 {
        private final class_1308 sidekick;
        private final class_1308 leader;
        private final double speedModifier;
        private final float maxDistanceFromLeader;
        private final float stopDistance;
        private final class_1408 navigation;
        private int ticksToRecalculatePath;

        public FollowGroupLeaderGoal(class_1308 sidekick, class_1308 leader, double speedModifier, float maxDistanceFromLeader, float stopDistance) {
            this.sidekick = sidekick;
            this.leader = leader;
            this.navigation = sidekick.method_5942();
            this.speedModifier = speedModifier;
            this.maxDistanceFromLeader = maxDistanceFromLeader;
            this.stopDistance = stopDistance;
            this.ticksToRecalculatePath = 0;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
        }

        public boolean method_6264() {
            return this.leader != null && this.leader.method_5805() && this.leader.method_5739((class_1297)this.sidekick) >= this.maxDistanceFromLeader && this.sidekick.method_5968() == null;
        }

        public void method_6268() {
            if (this.leader == null || --this.ticksToRecalculatePath > 0) {
                return;
            }
            this.sidekick.method_5988().method_6226((class_1297)this.leader, 10.0f, (float)this.sidekick.method_20240());
            this.ticksToRecalculatePath = 20;
            this.navigation.method_6335((class_1297)this.leader, this.speedModifier);
        }

        public boolean method_6266() {
            return this.leader != null && !this.navigation.method_6357() && this.sidekick.method_5739((class_1297)this.leader) > this.stopDistance;
        }

        public void method_6269() {
            this.ticksToRecalculatePath = 0;
        }
    }

    public static class TargetAsLeaderGoal
    extends class_1405 {
        private static final class_4051 CONDITIONS = class_4051.method_36625().method_36627().method_18424();
        private final class_1314 leader;

        public TargetAsLeaderGoal(class_1314 sidekick, class_1314 leader) {
            super((class_1308)sidekick, false);
            this.leader = leader;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            return this.leader != null && this.leader.method_5805() && this.method_6328(this.leader.method_5968(), CONDITIONS) && this.leader.method_5968() != this.field_6660.method_5968();
        }

        public void method_6269() {
            this.field_6660.method_5980(this.leader.method_5968());
            this.field_6664 = this.leader.method_5968();
            this.field_6657 = 300;
            super.method_6269();
        }
    }
}

