/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamestage;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszsdifficulty.gamestage.GameStage;
import java.util.List;
import net.minecraft.class_124;

public class GameStageConfig {
    public static boolean IS_PER_PLAYER_DIFFICULTY_ENABLED = false;
    public static List<GameStage> GAME_STAGES = GameStageConfig.updateOrdinals(List.of(GameStage.named("normal").format(class_124.field_1068).create(), GameStage.named("expert").format(class_124.field_1061, class_124.field_1067).triggersIn("{regex}.*").message("majruszsdifficulty.stages.expert.started", class_124.field_1061, class_124.field_1067).message("majruszsdifficulty.undead_army.on_expert", class_124.field_1064).create(), GameStage.named("master").format(class_124.field_1064, class_124.field_1067).triggersByKilling("minecraft:ender_dragon").message("majruszsdifficulty.stages.master.started", class_124.field_1064, class_124.field_1067).message("majruszsdifficulty.undead_army.on_master", class_124.field_1064).create()));

    private static List<GameStage> validate(List<GameStage> gameStages) {
        boolean hasDefaultGameStages;
        boolean bl = hasDefaultGameStages = gameStages.stream().filter(gameStage -> gameStage.is("normal") || gameStage.is("expert") || gameStage.is("master")).count() == 3L;
        if (!hasDefaultGameStages) {
            throw new IllegalArgumentException("Default game stages cannot be removed");
        }
        for (GameStage gameStage2 : gameStages) {
            long count = gameStages.stream().filter(stage -> stage.equals(gameStage2)).count();
            if (count <= 1L) continue;
            throw new IllegalArgumentException("Found %d game stages with identical id (%s)".formatted(count, gameStage2.getId()));
        }
        GameStageConfig.keepOldReferencesValid(gameStages, GAME_STAGES);
        GameStageConfig.updateOrdinals(gameStages);
        return gameStages;
    }

    private static List<GameStage> keepOldReferencesValid(List<GameStage> newGameStages, List<GameStage> oldGameStages) {
        for (int idx = 0; idx < newGameStages.size(); ++idx) {
            GameStage newGameStage = newGameStages.get(idx);
            for (GameStage oldGameStage : oldGameStages) {
                if (!oldGameStage.is(newGameStage.getId())) continue;
                newGameStage = oldGameStage.copy(newGameStage);
                break;
            }
            newGameStages.set(idx, newGameStage);
        }
        return newGameStages;
    }

    private static List<GameStage> updateOrdinals(List<GameStage> gameStages) {
        for (int idx = 0; idx < gameStages.size(); ++idx) {
            gameStages.get((int)idx).ordinal = idx;
        }
        return gameStages;
    }

    static {
        Serializables.getStatic(GameStageConfig.class).define("is_per_player_difficulty_enabled", Reader.bool(), () -> IS_PER_PLAYER_DIFFICULTY_ENABLED, v -> {
            IS_PER_PLAYER_DIFFICULTY_ENABLED = v;
        }).define("list", Reader.list((IReader)Reader.custom(GameStage::new)), () -> GAME_STAGES, v -> {
            GAME_STAGES = GameStageConfig.validate(v);
        });
    }
}

