/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.level.BlockHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszsdifficulty.MajruszsDifficulty;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class EnderiumShardLocator
extends class_1792 {
    private static final int OFFSET = 26;

    public EnderiumShardLocator() {
        super(new class_1792.class_1793().method_7894(class_1814.field_8907));
    }

    private static boolean isOre(class_1937 level, class_2338 position) {
        return BlockHelper.getState((class_1937)level, (class_2338)position).method_26204() == MajruszsDifficulty.ENDERIUM_SHARD_ORE_BLOCK.get();
    }

    static {
        Serializables.get(ItemInfo.class).define("EnderiumShardLocatorPos", Reader.optional((IReader)Reader.blockPos()), s -> s.position, (s, v) -> {
            s.position = v;
        }).define("EnderiumShardLocatorCounter", Reader.integer(), s -> s.counter, (s, v) -> {
            s.counter = v;
        });
    }

    private static class ItemInfo {
        public class_2338 position = null;
        public int counter = 0;

        private ItemInfo() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static float getShardDistance(class_1799 itemStack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
            class_1657 player;
            block6: {
                block5: {
                    if (!(entity instanceof class_1657)) break block5;
                    player = (class_1657)entity;
                    if (level != null) break block6;
                }
                return 1.0f;
            }
            if (player.method_31548().method_7395(itemStack) == -1 && !player.method_6079().equals(itemStack)) {
                return 1.0f;
            }
            ItemInfo itemInfo = new ItemInfo();
            Serializables.modify((Object)itemInfo, (class_2520)itemStack.method_7948(), info -> {
                if (itemInfo.position != null && !EnderiumShardLocator.isOre((class_1937)level, itemInfo.position)) {
                    info.position = null;
                }
                info.position = Client.findNearestOre(level, player, info);
                info.counter = (info.counter + 1) % 52;
            });
            if (itemInfo.position == null) {
                return 1.0f;
            }
            return (float)class_3532.method_15350((double)(AnyPos.from((class_243)player.method_19538()).dist(itemInfo.position).doubleValue() / 26.0), (double)0.0, (double)1.0);
        }

        private static class_2338 findNearestOre(class_638 level, class_1657 player, ItemInfo itemInfo) {
            class_2338 nearestPosition = itemInfo.position;
            float nearestDistance = nearestPosition != null ? AnyPos.from((class_243)player.method_19538()).dist(nearestPosition.method_46558()).floatValue() : 26.0f;
            for (int x = -26; x < 26; ++x) {
                for (int z = -26; z < 26; ++z) {
                    float distance;
                    class_2338 position = AnyPos.from((class_2338)player.method_24515()).add((Number)x, (Number)(itemInfo.counter - 26), (Number)z).block();
                    if (!EnderiumShardLocator.isOre((class_1937)level, position) || !(nearestDistance > (distance = AnyPos.from((class_243)player.method_19538()).dist(position.method_46558()).floatValue()))) continue;
                    nearestPosition = position;
                    nearestDistance = distance;
                }
            }
            return nearestPosition;
        }
    }
}

