/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnItemAttributeTooltip;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.AnyRot;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.items.ScrollItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1669;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class EvokerFangScroll
extends ScrollItem {
    private static int ATTACK_DAMAGE = 12;
    private static Range<Integer> ATTACK_RANGE = Range.of((Number)8, (Number)20);

    @Override
    protected void useScroll(class_1799 itemStack, class_1937 level, class_1309 entity, float useRatio) {
        super.useScroll(itemStack, level, entity, useRatio);
        double rotation = Math.toRadians(entity.method_36454()) - 1.5707963267948966;
        this.getAttackPattern(entity, (int)ATTACK_RANGE.lerp(useRatio)).forEach(spawnPoint -> {
            class_1669 evokerFangs = new class_1669(level, spawnPoint.pos.field_1352, spawnPoint.pos.field_1351, spawnPoint.pos.field_1350, (float)rotation, spawnPoint.cooldown, entity);
            Serializables.write((Object)new DamageInfo(ATTACK_DAMAGE), (class_2520)EntityHelper.getOrCreateExtraTag((class_1297)evokerFangs));
            level.method_8649((class_1297)evokerFangs);
        });
    }

    @Override
    protected class_3414 getPrepareSound() {
        return class_3417.field_15193;
    }

    @Override
    protected class_3414 getCastSound() {
        return class_3417.field_14858;
    }

    private List<SpawnPoint> getAttackPattern(class_1309 entity, int attackLength) {
        ArrayList<SpawnPoint> spawnPoints = new ArrayList<SpawnPoint>();
        AnyRot lookRotation = EntityHelper.getLookRotation((class_1297)entity);
        for (int x = 0; x <= attackLength; ++x) {
            for (int z = -1; z <= 1; ++z) {
                int cooldown = Math.abs(x) + 4;
                class_243 position = AnyPos.from((class_243)entity.method_19538()).floor().add(AnyPos.from((Number)x, (Number)0, (Number)z).rot(lookRotation).round()).vec3();
                LevelHelper.findBlockPosOnGround((class_1937)entity.method_37908(), (Number)position.field_1352, (Range)Range.of((Number)(position.field_1351 - 3.0), (Number)(position.field_1351 + 3.0)), (Number)position.field_1350).ifPresent(blockPos -> spawnPoints.add(new SpawnPoint(AnyPos.from((class_2338)blockPos).add((Number)0.5, (Number)0.0, (Number)0.5).vec3(), cooldown)));
            }
        }
        return spawnPoints;
    }

    private static void increaseDamage(OnEntityPreDamaged data) {
        data.damage += (float)((DamageInfo)Serializables.read((Object)new DamageInfo(), (class_2520)EntityHelper.getExtraTag((class_1297)data.source.method_5526()))).damage - data.original;
    }

    private static void addSpellInfo(OnItemAttributeTooltip data) {
        List.of(TextHelper.translatable((String)"majruszsdifficulty.scrolls.attack_damage", (Object[])new Object[]{ATTACK_DAMAGE}).method_27692(class_124.field_1077), TextHelper.translatable((String)"majruszsdifficulty.scrolls.attack_range", (Object[])new Object[]{"%d-%d".formatted(EvokerFangScroll.ATTACK_RANGE.from, EvokerFangScroll.ATTACK_RANGE.to)}).method_27692(class_124.field_1077)).forEach(component -> data.add(class_1304.field_6173, (class_2561)component));
    }

    static {
        OnEntityPreDamaged.listen(EvokerFangScroll::increaseDamage).addCondition(Condition.isLogicalServer()).addCondition(data -> data.source.method_5526() instanceof class_1669).addCondition(data -> EntityHelper.getExtraTag((class_1297)data.source.method_5526()) != null);
        OnItemAttributeTooltip.listen(EvokerFangScroll::addSpellInfo).addCondition(data -> data.itemStack.method_7909() instanceof EvokerFangScroll);
        Serializables.getStatic(Config.Items.class).define("evoker_fang_scroll", EvokerFangScroll.class);
        Serializables.getStatic(EvokerFangScroll.class).define("attack_damage", Reader.integer(), () -> ATTACK_DAMAGE, v -> {
            ATTACK_DAMAGE = (Integer)Range.of((Number)1, (Number)100).clamp((Number)v);
        }).define("attack_range", Reader.range((IReader)Reader.integer()), () -> ATTACK_RANGE, v -> {
            ATTACK_RANGE = Range.of((Number)1, (Number)100).clamp(v);
        });
        Serializables.get(DamageInfo.class).define("MajruszsProgressiveDifficultyEvokerFangDamage", Reader.integer(), s -> s.damage, (s, v) -> {
            s.damage = v;
        });
    }

    private static class DamageInfo {
        int damage = 0;

        public DamageInfo(int damage) {
            this.damage = damage;
        }

        public DamageInfo() {
        }
    }

    private record SpawnPoint(class_243 pos, int cooldown) {
    }
}

