/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.events.OnEntityModelSetup;
import com.majruszlibrary.events.OnItemRendered;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.time.TimeHelper;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5328;

public abstract class ScrollItem
extends class_1792 {
    protected static final int MIN_DURATION = TimeHelper.toTicks((double)1.0);

    public ScrollItem() {
        super(new class_1792.class_1793().method_7894(class_1814.field_8907).method_7889(1));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        this.playSound(this::getPrepareSound, level, (class_1309)player, 1.0f);
        return class_5328.method_29282((class_1937)level, (class_1657)player, (class_1268)hand);
    }

    public class_1799 method_7861(class_1799 itemStack, class_1937 level, class_1309 entity) {
        this.useScroll(itemStack, level, entity, 1.0f);
        return itemStack;
    }

    public void method_7840(class_1799 itemStack, class_1937 level, class_1309 entity, int ticksLeft) {
        if (this.method_7881(itemStack) - ticksLeft < MIN_DURATION) {
            this.disableItem(itemStack, entity, TimeHelper.toTicks((double)1.0));
            return;
        }
        float useRatio = class_3532.method_15363((float)(1.0f - (float)ticksLeft / (float)(this.method_7881(itemStack) - MIN_DURATION)), (float)0.0f, (float)1.0f);
        this.useScroll(itemStack, level, entity, useRatio);
    }

    public class_1839 method_7853(class_1799 itemStack) {
        return class_1839.field_8952;
    }

    public int method_7881(class_1799 itemStack) {
        return TimeHelper.toTicks((double)3.0);
    }

    protected void useScroll(class_1799 itemStack, class_1937 level, class_1309 entity, float useRatio) {
        this.disableItem(itemStack, entity, TimeHelper.toTicks((double)16.0));
        this.playSound(this::getCastSound, level, entity, 2.0f);
    }

    protected void disableItem(class_1799 itemStack, class_1309 entity, int ticks) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            ItemHelper.addCooldown((class_1657)player, (int)ticks, (class_1792[])new class_1792[]{itemStack.method_7909()});
        }
    }

    protected void playSound(Supplier<class_3414> sound, class_1937 level, class_1309 entity, float volumeScale) {
        SoundEmitter.of(sound).source(class_3419.field_15248).volume(SoundEmitter.randomized((float)volumeScale)).position(entity.method_19538()).emit(level);
    }

    protected abstract class_3414 getPrepareSound();

    protected abstract class_3414 getCastSound();

    @Environment(value=EnvType.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void modify(OnEntityModelSetup data) {
            float ticks = (float)data.entity.method_6048() + TimeHelper.getPartialTicks();
            data.model.field_27433.field_3657 = 5.0f;
            data.model.field_27433.field_3655 = 0.0f;
            data.model.field_27433.field_3654 = class_3532.method_15362((float)(ticks * 0.6662f)) * 0.25f;
            data.model.field_27433.field_3675 = 0.0f;
            data.model.field_27433.field_3674 = -2.3561945f;
            data.model.field_3401.field_3657 = -5.0f;
            data.model.field_3401.field_3655 = 0.0f;
            data.model.field_3401.field_3654 = class_3532.method_15362((float)(ticks * 0.6662f)) * 0.25f;
            data.model.field_3401.field_3675 = 0.0f;
            data.model.field_3401.field_3674 = 2.3561945f;
        }

        private static void modify(OnItemRendered data) {
            data.poseStack.method_22904(0.0, -0.1 * Math.sin((float)Side.getLocalPlayer().method_6048() + TimeHelper.getPartialTicks()), 0.0);
        }

        static {
            OnEntityModelSetup.listen(Client::modify).addCondition(data -> data.entity.method_6115()).addCondition(data -> data.entity.method_6030().method_7909() instanceof ScrollItem);
            OnItemRendered.listen(Client::modify).addCondition(data -> data.player.method_6115()).addCondition(data -> data.player.method_6030().equals(data.itemStack)).addCondition(data -> data.itemStack.method_7909() instanceof ScrollItem);
        }
    }
}

