/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnItemAttributeTooltip;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.items.ScrollItem;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class SonicBoomScroll
extends ScrollItem {
    private static int ATTACK_DAMAGE = 14;
    private static Range<Integer> ATTACK_RANGE = Range.of((Number)12, (Number)30);

    @Override
    protected void useScroll(class_1799 itemStack, class_1937 level, class_1309 entity, float useRatio) {
        super.useScroll(itemStack, level, entity, useRatio);
        if (!Side.isLogicalServer()) {
            return;
        }
        AnyPos direction = EntityHelper.getLookDirection((class_1297)entity);
        int attackRange = (int)ATTACK_RANGE.lerp(useRatio);
        for (int idx = 0; idx < attackRange; ++idx) {
            class_243 position = direction.mul((Number)idx).add(entity.method_5836(0.75f)).vec3();
            ParticleEmitter.of((class_2394)class_2398.field_38908).position(position).emit(level);
            level.method_8390(class_1309.class, class_238.method_30048((class_243)position, (double)4.0, (double)4.0, (double)4.0), target -> !target.equals((Object)entity)).forEach(target -> {
                class_243 knockbackDirection = direction.mul((Number)-1.0, (Number)0.0, (Number)-1.0).vec3();
                target.method_5643(level.method_48963().method_48815((class_1297)entity, (class_1297)entity), (float)ATTACK_DAMAGE);
                target.method_6005(1.0, knockbackDirection.field_1352, knockbackDirection.field_1350);
            });
        }
    }

    @Override
    protected class_3414 getPrepareSound() {
        return class_3417.field_38831;
    }

    @Override
    protected class_3414 getCastSound() {
        return class_3417.field_38830;
    }

    private static void addSpellInfo(OnItemAttributeTooltip data) {
        List.of(TextHelper.translatable((String)"majruszsdifficulty.scrolls.attack_damage", (Object[])new Object[]{ATTACK_DAMAGE}).method_27692(class_124.field_1077), TextHelper.translatable((String)"majruszsdifficulty.scrolls.attack_range", (Object[])new Object[]{"%d-%d".formatted(SonicBoomScroll.ATTACK_RANGE.from, SonicBoomScroll.ATTACK_RANGE.to)}).method_27692(class_124.field_1077)).forEach(component -> data.add(class_1304.field_6173, (class_2561)component));
    }

    static {
        OnItemAttributeTooltip.listen(SonicBoomScroll::addSpellInfo).addCondition(data -> data.itemStack.method_7909() instanceof SonicBoomScroll);
        Serializables.getStatic(Config.Items.class).define("sonic_boom_scroll", SonicBoomScroll.class);
        Serializables.getStatic(SonicBoomScroll.class).define("attack_damage", Reader.integer(), () -> ATTACK_DAMAGE, v -> {
            ATTACK_DAMAGE = (Integer)Range.of((Number)1, (Number)100).clamp((Number)v);
        }).define("attack_range", Reader.range((IReader)Reader.integer()), () -> ATTACK_RANGE, v -> {
            ATTACK_RANGE = Range.of((Number)1, (Number)100).clamp(v);
        });
    }
}

