/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnBreakSpeedGet;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnEntitySwimSpeedMultiplierGet;
import com.majruszlibrary.events.OnItemAttributeTooltip;
import com.majruszlibrary.events.OnItemEquipped;
import com.majruszlibrary.events.OnItemRenderColorsGet;
import com.majruszlibrary.events.OnItemTooltip;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.OnPlayerInteracted;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.events.OnSoulJarMultiplierGet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1819;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;

public class SoulJar
extends class_1792 {
    private static final float DAMAGE_BONUS = 3.0f;
    private static final float MOVE_BONUS = 0.15f;
    private static final int ARMOR_BONUS = 3;
    private static final float MINE_BONUS = 0.15f;
    private static final int LUCK_BONUS = 1;
    private static final float SWIM_BONUS = 0.3f;
    private static final AttributeHandler ARMOR_ATTRIBUTE = new AttributeHandler("soul_jar_armor_bonus", () -> class_5134.field_23724, class_1322.class_1323.field_6328);
    private static final AttributeHandler LUCK_ATTRIBUTE = new AttributeHandler("soul_jar_luck_bonus", () -> class_5134.field_23726, class_1322.class_1323.field_6328);
    private static final AttributeHandler MOVE_ATTRIBUTE = new AttributeHandler("soul_jar_movement_bonus", () -> class_5134.field_23719, class_1322.class_1323.field_6331);

    public SoulJar() {
        super(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8907));
    }

    private static void randomize(OnPlayerInteracted data) {
        SoulJar.tryToRandomize(data.itemStack);
    }

    private static void increaseDamage(OnEntityPreDamaged data) {
        data.damage += 3.0f * SoulJar.getMultiplier(data.attacker, data.attacker.method_6079());
        data.spawnMagicParticles = true;
    }

    private static void increaseMineSpeed(OnBreakSpeedGet data) {
        data.speed += data.original * 0.15f * SoulJar.getMultiplier((class_1309)data.player, data.player.method_6079());
    }

    private static void increaseSwimSpeed(OnEntitySwimSpeedMultiplierGet data) {
        data.multiplier += data.original * 0.3f * SoulJar.getMultiplier(data.entity, data.entity.method_6079());
    }

    private static void updateAttributes(OnItemEquipped data) {
        class_1799 itemStack = data.entity.method_6079();
        float multiplier = SoulJar.canHaveSouls(itemStack) ? SoulJar.getMultiplier(data.entity, itemStack) : 0.0f;
        BonusInfo bonusInfo = BonusInfo.read(itemStack);
        ARMOR_ATTRIBUTE.setValue((double)((bonusInfo.has(BonusType.ARMOR) ? 3.0f : 0.0f) * multiplier)).apply(data.entity);
        LUCK_ATTRIBUTE.setValue((double)((bonusInfo.has(BonusType.LUCK) ? 1.0f : 0.0f) * multiplier)).apply(data.entity);
        MOVE_ATTRIBUTE.setValue((double)((bonusInfo.has(BonusType.MOVE) ? 0.15f : 0.0f) * multiplier)).apply(data.entity);
    }

    private static void randomize(OnLootGenerated data) {
        data.generatedLoot.forEach(SoulJar::tryToRandomize);
    }

    private static void decreaseShieldBonus(OnSoulJarMultiplierGet data) {
        data.multiplier *= 0.6666667f;
    }

    private static void tryToRandomize(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof SoulJar) {
            Serializables.modify((Object)new BonusInfo(), (class_2520)itemStack.method_7948(), bonusInfo -> {
                if (bonusInfo.getBonusTypes().isEmpty()) {
                    bonusInfo.randomize();
                }
            });
        }
    }

    private static float getMultiplier(class_1309 entity, class_1799 itemStack) {
        return ((OnSoulJarMultiplierGet)Events.dispatch((Object)new OnSoulJarMultiplierGet(entity, itemStack))).getMultiplier();
    }

    private static boolean canHaveSouls(class_1799 itemStack) {
        return itemStack.method_7909() instanceof SoulJar || itemStack.method_7909() instanceof class_1819;
    }

    static {
        OnPlayerInteracted.listen(SoulJar::randomize).addCondition(data -> SoulJar.canHaveSouls(data.itemStack));
        OnLootGenerated.listen(SoulJar::randomize);
        OnEntityPreDamaged.listen(SoulJar::increaseDamage).addCondition(data -> {
            class_1308 mob;
            class_1309 patt2438$temp = data.target;
            return patt2438$temp instanceof class_1308 && (mob = (class_1308)patt2438$temp).method_6046() == class_1310.field_6289;
        }).addCondition(data -> data.attacker != null).addCondition(data -> BonusInfo.has(data.attacker, BonusType.DAMAGE));
        OnBreakSpeedGet.listen(SoulJar::increaseMineSpeed).addCondition(data -> BonusInfo.has((class_1309)data.player, BonusType.MINE));
        OnEntitySwimSpeedMultiplierGet.listen(SoulJar::increaseSwimSpeed).addCondition(data -> BonusInfo.has(data.entity, BonusType.SWIM));
        OnItemEquipped.listen(SoulJar::updateAttributes);
        OnSoulJarMultiplierGet.listen(SoulJar::decreaseShieldBonus).addCondition(data -> data.itemStack.method_7909() instanceof class_1819);
        Serializables.get(BonusInfo.class).define("SoulJarBonusMask", Reader.integer(), BonusInfo::getMask, BonusInfo::setMask);
    }

    public static class BonusInfo {
        private static final int BONUS_COUNT = 3;
        public final List<BonusType> bonuses = new ArrayList<BonusType>();

        public static BonusInfo read(class_1799 itemStack) {
            BonusInfo bonusInfo = new BonusInfo();
            class_2487 tag = itemStack.method_7969();
            return tag != null ? (BonusInfo)Serializables.read((Object)bonusInfo, (class_2520)tag) : bonusInfo;
        }

        public static boolean has(class_1309 entity, BonusType bonusType) {
            return BonusInfo.read(entity.method_6079()).has(bonusType);
        }

        public void randomize() {
            this.setMask(BonusInfo.toMask(Random.next(Arrays.stream(BonusType.values()).toList(), (int)3)));
        }

        public void setMask(int mask) {
            this.bonuses.clear();
            Arrays.stream(BonusType.values()).filter(bonusType -> (bonusType.getBit() & mask) != 0).forEach(this.bonuses::add);
        }

        public int getMask() {
            return BonusInfo.toMask(this.bonuses);
        }

        public boolean has(BonusType bonusType) {
            return this.bonuses.contains((Object)bonusType);
        }

        public boolean hasBonuses() {
            return !this.bonuses.isEmpty();
        }

        public Optional<BonusType> getBonus(int idx) {
            return idx < this.bonuses.size() ? Optional.of(this.bonuses.get(idx)) : Optional.empty();
        }

        public List<BonusType> getBonusTypes() {
            return this.bonuses;
        }

        public List<class_2561> getComponents() {
            ArrayList<class_2561> components = new ArrayList<class_2561>();
            if (this.bonuses.isEmpty()) {
                class_5250 bonusCount = TextHelper.literal((String)"%d", (Object[])new Object[]{3}).method_27692(class_124.field_1060);
                components.add((class_2561)TextHelper.translatable((String)"item.majruszsdifficulty.soul_jar.item_tooltip1", (Object[])new Object[]{bonusCount}).method_27692(class_124.field_1080));
                components.add((class_2561)TextHelper.translatable((String)"item.majruszsdifficulty.soul_jar.item_tooltip2", (Object[])new Object[0]).method_27692(class_124.field_1080));
            } else {
                components.add((class_2561)TextHelper.empty());
                components.add((class_2561)TextHelper.translatable((String)"item.majruszsdifficulty.soul_jar.item_tooltip3", (Object[])new Object[0]).method_27692(class_124.field_1080));
                class_5250 souls = TextHelper.literal((String)"");
                for (BonusType bonusType : this.getBonusTypes()) {
                    souls.method_10852((class_2561)bonusType.getSoulComponent().method_27693(" "));
                }
                components.add((class_2561)souls);
            }
            return components;
        }

        private static int toMask(List<BonusType> bonuses) {
            int mask = 0;
            for (BonusType bonusType : bonuses) {
                mask |= bonusType.getBit();
            }
            return mask;
        }
    }

    public static enum BonusType {
        DAMAGE("smite", "entity.minecraft.wolf", class_124.field_1061, 0xCC5555, multiplier -> TextHelper.signed((float)(3.0f * multiplier.floatValue()))),
        MOVE("move", "entity.minecraft.horse", class_124.field_1068, 0xDDDDDD, multiplier -> TextHelper.signedPercent((float)(0.15f * multiplier.floatValue()))),
        ARMOR("armor", "entity.majruszsdifficulty.tank", class_124.field_1078, 0x5555CC, multiplier -> TextHelper.signed((int)((int)(3.0f * multiplier.floatValue())))),
        MINE("mine", "entity.minecraft.sniffer", class_124.field_1054, 0xCCCC55, multiplier -> TextHelper.signedPercent((float)(0.15f * multiplier.floatValue()))),
        LUCK("luck", "entity.minecraft.rabbit", class_124.field_1060, 0x55CC55, multiplier -> TextHelper.signed((float)(1.0f * multiplier.floatValue()))),
        SWIM("swim", "entity.minecraft.dolphin", class_124.field_1075, 0x55CCCC, multiplier -> TextHelper.signedPercent((float)(0.3f * multiplier.floatValue())));

        final String bonusId;
        final String mobId;
        final class_124 soulFormatting;
        final int color;
        final Function<Float, String> valueProvider;

        private BonusType(String bonusId, String mobId, class_124 soulFormatting, int color, Function<Float, String> valueProvider) {
            this.bonusId = "item.majruszsdifficulty.soul_jar.%s".formatted(bonusId);
            this.mobId = mobId;
            this.soulFormatting = soulFormatting;
            this.color = color;
            this.valueProvider = valueProvider;
        }

        public int getBit() {
            return 1 << this.ordinal();
        }

        public int getColor() {
            return this.color;
        }

        public class_5250 getBonusComponent(float multiplier) {
            return TextHelper.translatable((String)this.bonusId, (Object[])new Object[]{this.valueProvider.apply(Float.valueOf(multiplier))}).method_27692(class_124.field_1078);
        }

        public class_5250 getSoulComponent() {
            return TextHelper.translatable((String)this.mobId, (Object[])new Object[0]).method_27692(this.soulFormatting);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        private static void changeSoulColor(OnItemRenderColorsGet data) {
            BonusInfo bonusInfo = BonusInfo.read(data.itemStack);
            for (int idx = 0; idx < 3; ++idx) {
                data.add(idx + 1, bonusInfo.getBonus(idx).map(BonusType::getColor).orElse(0xEEEEEE - idx * 0x111111).intValue());
            }
        }

        private static void addTooltip(OnItemAttributeTooltip data) {
            float multiplier = SoulJar.getMultiplier((class_1309)Side.getLocalPlayer(), data.itemStack);
            BonusInfo bonusInfo = BonusInfo.read(data.itemStack);
            for (BonusType bonusType : bonusInfo.getBonusTypes()) {
                data.add(class_1304.field_6171, (class_2561)bonusType.getBonusComponent(multiplier));
            }
        }

        private static void addTooltip(OnItemTooltip data) {
            BonusInfo bonusInfo = BonusInfo.read(data.itemStack);
            if (bonusInfo.hasBonuses() || data.itemStack.method_7909() instanceof SoulJar) {
                data.components.addAll(bonusInfo.getComponents());
            }
        }

        static {
            OnItemRenderColorsGet.listen(Client::changeSoulColor).addCondition(data -> data.itemStack.method_7909() instanceof SoulJar);
            OnItemAttributeTooltip.listen(Client::addTooltip).addCondition(data -> SoulJar.canHaveSouls(data.itemStack));
            OnItemTooltip.listen(Client::addTooltip).addCondition(data -> SoulJar.canHaveSouls(data.itemStack));
        }
    }
}

