/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.events.OnItemInventoryClicked;
import com.majruszlibrary.events.OnPlayerInteracted;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.platform.Side;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.treasurebag.events.OnTreasureBagOpened;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class TreasureBag
extends class_1792 {
    private final class_2960 lootId;

    public static Supplier<TreasureBag> angler() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_angler"));
    }

    public static Supplier<TreasureBag> elderGuardian() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_elder_guardian"));
    }

    public static Supplier<TreasureBag> enderDragon() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_ender_dragon"));
    }

    public static Supplier<TreasureBag> pillager() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_pillager"));
    }

    public static Supplier<TreasureBag> undeadArmy() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_undead_army"));
    }

    public static Supplier<TreasureBag> warden() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_warden"));
    }

    public static Supplier<TreasureBag> wither() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_wither"));
    }

    public TreasureBag(class_2960 lootId) {
        super(new class_1792.class_1793().method_7889(16).method_7894(class_1814.field_8907));
        this.lootId = lootId;
    }

    public class_2960 getLootId() {
        return this.lootId;
    }

    private static void openInHand(OnPlayerInteracted data) {
        if (Side.isLogicalServer()) {
            TreasureBag.open(data.itemStack, data.player);
        }
        data.finish();
    }

    private static void openInInventory(RightClickAction action, class_3222 player) {
        if (!player.field_7512.method_40442(action.containerIdx)) {
            return;
        }
        class_1799 itemStack = player.field_7512.method_7611(action.containerIdx).method_7677();
        if (itemStack.method_7909() instanceof TreasureBag) {
            TreasureBag.open(itemStack, (class_1657)player);
        }
    }

    private static void open(class_1799 itemStack, class_1657 player) {
        TreasureBag treasureBag = (TreasureBag)itemStack.method_7909();
        ObjectArrayList loot = LootHelper.getLootTable((class_2960)treasureBag.lootId).method_51878(LootHelper.toGiftParams((class_1297)player));
        SoundEmitter.of((class_3414)class_3417.field_15197).position(player.method_19538()).emit(player.method_37908());
        Events.dispatch((Object)new OnTreasureBagOpened(player, treasureBag, (List<class_1799>)loot));
        loot.forEach(reward -> ItemHelper.giveToPlayer((class_1799)reward, (class_1657)player));
        ItemHelper.consumeItemOnUse((class_1799)itemStack, (class_1657)player);
    }

    static {
        OnPlayerInteracted.listen(TreasureBag::openInHand).addCondition(data -> data.itemStack.method_7909() instanceof TreasureBag);
        Serializables.get(RightClickAction.class).define("container_idx", Reader.integer(), s -> s.containerIdx, (s, v) -> {
            s.containerIdx = v;
        });
        MajruszsDifficulty.TREASURE_BAG_RIGHT_CLICK_NETWORK.addServerCallback(TreasureBag::openInInventory);
    }

    public static class RightClickAction {
        public int containerIdx;

        public RightClickAction(int containerIdx) {
            this.containerIdx = containerIdx;
        }

        public RightClickAction() {
            this(-1);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        private static void openInInventory(OnItemInventoryClicked data) {
            MajruszsDifficulty.TREASURE_BAG_RIGHT_CLICK_NETWORK.sendToServer((Object)new RightClickAction(data.containerIdx));
            data.cancel();
        }

        static {
            OnItemInventoryClicked.listen(Client::openInInventory).addCondition(data -> data.itemStack.method_7909() instanceof TreasureBag).addCondition(data -> data.action == 1);
        }
    }
}

