/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.itemsets;

import com.majruszlibrary.entity.EffectHelper;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnChorusFruitEaten;
import com.majruszlibrary.events.OnEnderManAngered;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.events.OnLootingLevelGet;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.text.TextHelper;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.itemsets.ItemSet;
import com.majruszsdifficulty.itemsets.ItemSetBonus;
import com.majruszsdifficulty.itemsets.ItemSetRequirement;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_8111;

public class EnderiumSet {
    static final class_1291[] EFFECTS = new class_1291[]{class_1294.field_5898, class_1294.field_5910, class_1294.field_5907, class_1294.field_5918, class_1294.field_5913, class_1294.field_5904, class_1294.field_5922};
    static final ItemSetRequirement HELMET = ItemSetRequirement.of(MajruszsDifficulty.ENDERIUM_HELMET_ITEM, class_1304.field_6169);
    static final ItemSetRequirement CHESTPLATE = ItemSetRequirement.of(MajruszsDifficulty.ENDERIUM_CHESTPLATE_ITEM, class_1304.field_6174);
    static final ItemSetRequirement LEGGINGS = ItemSetRequirement.of(MajruszsDifficulty.ENDERIUM_LEGGINGS_ITEM, class_1304.field_6172);
    static final ItemSetRequirement BOOTS = ItemSetRequirement.of(MajruszsDifficulty.ENDERIUM_BOOTS_ITEM, class_1304.field_6166);
    static final ItemSetBonus ENDERMAN_PROTECTION = ItemSetBonus.requires(HELMET).component("majruszsdifficulty.sets.enderium.bonus_1", TextHelper.translatable((String)"item.majruszsdifficulty.enderium_helmet", (Object[])new Object[0]));
    static final ItemSetBonus END_LOOTING = ItemSetBonus.any(2).component("majruszsdifficulty.sets.enderium.bonus_2", new Object[0]);
    static final ItemSetBonus CHORUS_FRUIT = ItemSetBonus.any(3).component("majruszsdifficulty.sets.enderium.bonus_3", class_1802.field_8233.method_7848());
    static final ItemSetBonus VOID_PROTECTION = ItemSetBonus.any(4).component("majruszsdifficulty.sets.enderium.bonus_4", new Object[0]);
    static final ItemSet ITEM_SET = ItemSet.create().component("majruszsdifficulty.sets.enderium.name").format(class_124.field_1064).require(HELMET, CHESTPLATE, LEGGINGS, BOOTS).bonus(ENDERMAN_PROTECTION, END_LOOTING, CHORUS_FRUIT, VOID_PROTECTION);

    private static void increaseLooting(OnLootingLevelGet data) {
        ++data.level;
    }

    private static void giveRandomEffect(OnChorusFruitEaten data) {
        List<class_1291> notAppliedEffects = Stream.of(EFFECTS).filter(effect -> EffectHelper.getAmplifier(() -> effect, (class_1309)data.entity).isEmpty()).toList();
        if (notAppliedEffects.isEmpty()) {
            notAppliedEffects = List.of(EFFECTS);
        }
        data.entity.method_6092(new class_1293((class_1291)Random.next(notAppliedEffects), TimeHelper.toTicks((double)90.0), 0));
        data.cancelTeleport();
    }

    private static void cancelDeath(OnEntityDied data) {
        if (Side.isLogicalServer()) {
            class_3222 player = (class_3222)data.target;
            LevelHelper.getSpawnPoint((class_3222)player).map(spawnPoint -> new LevelHelper.SpawnPoint(spawnPoint.level, AnyPos.from((class_243)spawnPoint.position).add((Number)0.0, (Number)0.5, (Number)0.0).vec3())).ifPresent(spawnPoint -> spawnPoint.teleport(player));
        }
        EntityHelper.cheatDeath((class_1309)data.target);
        data.target.method_18800(0.0, 0.5, 0.0);
        data.cancelDeath();
    }

    static {
        OnEnderManAngered.listen(OnEnderManAngered::cancelAnger).addCondition(data -> ITEM_SET.canTrigger(ENDERMAN_PROTECTION, (class_1309)data.player));
        OnLootingLevelGet.listen(EnderiumSet::increaseLooting).addCondition(data -> data.source != null).addCondition(data -> data.source.method_5529() instanceof class_1309).addCondition(data -> data.getLevel().method_27983() == class_1937.field_25181).addCondition(data -> ITEM_SET.canTrigger(END_LOOTING, (class_1309)data.source.method_5529()));
        OnChorusFruitEaten.listen(EnderiumSet::giveRandomEffect).addCondition(data -> ITEM_SET.canTrigger(CHORUS_FRUIT, data.entity));
        OnEntityDied.listen(EnderiumSet::cancelDeath).addCondition(data -> ITEM_SET.canTrigger(VOID_PROTECTION, data.target)).addCondition(data -> data.target.method_23318() < (double)(data.target.method_37908().method_31607() - 64)).addCondition(data -> data.source.method_49708(class_8111.field_42347));
    }
}

