/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebag;

import com.majruszlibrary.client.ClientHelper;
import com.majruszlibrary.events.OnItemTooltip;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.registry.Registries;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.items.TreasureBag;
import com.majruszsdifficulty.treasurebag.TreasureBagHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class TreasureBagClient {
    private static final Map<String, List<class_2561>> COMPONENTS = new HashMap<String, List<class_2561>>();

    private static void addTooltip(OnItemTooltip data) {
        if (data.isAdvanced()) {
            data.components.add(TextHelper.translatable((String)"majruszsdifficulty.treasure_bag.item_tooltip", (Object[])new Object[0]).method_27692(class_124.field_1080));
            data.components.add(TextHelper.empty());
        }
        if (ClientHelper.isShiftDown()) {
            List<class_2561> components = COMPONENTS.get(Registries.ITEMS.getId((Object)data.itemStack.method_7909()).toString());
            if (components == null) {
                return;
            }
            data.components.addAll(components);
        } else {
            data.components.add(TextHelper.translatable((String)"majruszsdifficulty.treasure_bag.hint_tooltip", (Object[])new Object[0]).method_27692(class_124.field_1080));
        }
    }

    private static void onProgressReceived(TreasureBagHelper.Progress data) {
        List components = COMPONENTS.computeIfAbsent(data.id.toString(), id -> new ArrayList());
        components.clear();
        components.add(TreasureBagClient.toProgressComponent(data.bagProgress));
        for (TreasureBagHelper.ItemProgress itemProgress : data.bagProgress.items) {
            components.add(TextHelper.literal((String)" ").method_10852(TreasureBagClient.toComponent(itemProgress)));
        }
        if (data.unlockedIndices.size() > 0) {
            TreasureBagClient.sendToChat(data);
        }
    }

    private static void sendToChat(TreasureBagHelper.Progress data) {
        ArrayList<class_5250> components = new ArrayList<class_5250>();
        for (int idx = 0; idx < data.bagProgress.items.size(); ++idx) {
            components.add(TextHelper.literal((String)(data.unlockedIndices.contains(idx) ? "+" : " ")).method_27692(class_124.field_1077).method_10852(TreasureBagClient.toComponent(data.bagProgress.items.get(idx))));
        }
        class_1792 item = (class_1792)Registries.ITEMS.get(data.id);
        class_5250 message = TextHelper.translatable((String)"majruszsdifficulty.treasure_bag.new_items", (Object[])new Object[]{class_2564.method_10885((class_2561)item.method_7848()).method_27692(item.method_7862((class_1799)new class_1799((class_1935)item)).field_8908)});
        class_5250 description = TreasureBagClient.toProgressComponent(data.bagProgress);
        components.forEach(component -> description.method_10852((class_2561)TextHelper.literal((String)"\n").method_10852(component)));
        Side.getLocalPlayer().method_43496((class_2561)message.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)description))));
    }

    private static class_5250 toProgressComponent(TreasureBagHelper.BagProgress bagProgress) {
        long unlockedItems = bagProgress.items.stream().filter(item -> item.isUnlocked).count();
        int totalItems = bagProgress.items.size();
        return TextHelper.translatable((String)"majruszsdifficulty.treasure_bag.list_tooltip", (Object[])new Object[]{unlockedItems, totalItems}).method_27692(class_124.field_1080);
    }

    private static class_2561 toComponent(TreasureBagHelper.ItemProgress itemProgress) {
        if (itemProgress.isUnlocked) {
            return ((class_1792)Registries.ITEMS.get(itemProgress.id)).method_7848().method_27661().method_27692(TreasureBagClient.getUnlockedFormatting(itemProgress.quality));
        }
        return TextHelper.literal((String)"???").method_27692(TreasureBagClient.getLockedFormatting(itemProgress.quality));
    }

    private static class_124 getUnlockedFormatting(int quality) {
        return switch (quality) {
            case 4 -> class_124.field_1065;
            case 3 -> class_124.field_1076;
            case 2 -> class_124.field_1078;
            case 1 -> class_124.field_1060;
            default -> class_124.field_1080;
        };
    }

    private static class_124 getLockedFormatting(int quality) {
        return switch (quality) {
            case 4 -> class_124.field_1065;
            case 3 -> class_124.field_1064;
            case 2 -> class_124.field_1078;
            case 1 -> class_124.field_1077;
            default -> class_124.field_1063;
        };
    }

    static {
        OnItemTooltip.listen(TreasureBagClient::addTooltip).addCondition(data -> data.itemStack.method_7909() instanceof TreasureBag);
        MajruszsDifficulty.TREASURE_BAG_PROGRESS_NETWORK.addClientCallback(TreasureBagClient::onProgressReceived);
    }
}

