/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebag;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnGameInitialized;
import com.majruszlibrary.events.OnLevelsLoaded;
import com.majruszlibrary.events.OnPlayerLoggedIn;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.platform.Services;
import com.majruszlibrary.registry.Registries;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.data.WorldData;
import com.majruszsdifficulty.items.TreasureBag;
import com.majruszsdifficulty.loot.ILootPlatform;
import com.majruszsdifficulty.mixin.IMixinLootPool;
import com.majruszsdifficulty.mixin.IMixinLootPoolSingletonContainer;
import com.majruszsdifficulty.treasurebag.events.OnTreasureBagOpened;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_77;
import net.minecraft.class_8567;

public class TreasureBagHelper {
    private static final ILootPlatform PLATFORM = (ILootPlatform)Services.load(ILootPlatform.class);
    private static final List<TreasureBag> TREASURE_BAGS = new ArrayList<TreasureBag>();
    private static Map<String, PlayerProgress> PLAYERS = new HashMap<String, PlayerProgress>();

    public static void unlockAll(class_1657 player) {
        TreasureBagHelper.PLAYERS.get((Object)player.method_5845()).treasureBags.forEach((id, bagProgress) -> {
            ArrayList<Integer> unlockedIndices = new ArrayList<Integer>();
            for (int idx = 0; idx < bagProgress.items.size(); ++idx) {
                if (!bagProgress.items.get(idx).unlock()) continue;
                unlockedIndices.add(idx);
            }
            TreasureBagHelper.sendToPlayer(player, new class_2960(id), bagProgress, unlockedIndices);
        });
    }

    public static void clearProgress(class_1657 player) {
        PLAYERS.remove(player.method_5845());
        TreasureBagHelper.createDefaultProgress(player);
    }

    public static void createDefaultProgress(class_1657 player) {
        String uuid = player.method_5845();
        PlayerProgress playerProgress = PLAYERS.computeIfAbsent(uuid, key -> new PlayerProgress());
        class_8567 params = LootHelper.toGiftParams((class_1297)player);
        for (TreasureBag treasureBag : TREASURE_BAGS) {
            class_2960 bagId = Registries.ITEMS.getId((Object)treasureBag);
            BagProgress bagProgress = playerProgress.get(treasureBag);
            if (bagProgress.items.isEmpty()) {
                TreasureBagHelper.createDefaultProgress(bagProgress, params, treasureBag.getLootId());
            }
            TreasureBagHelper.sendToPlayer(player, bagId, bagProgress);
        }
        MajruszsDifficulty.WORLD_DATA.setDirty();
    }

    public static PlayerProgress getProgress(class_1657 player) {
        return PLAYERS.get(player.method_5667().toString());
    }

    public static BagProgress getProgress(class_1657 player, TreasureBag item) {
        return TreasureBagHelper.getProgress(player).get(item);
    }

    private static void setupDefaultValues(OnLevelsLoaded data) {
        PLAYERS = new HashMap<String, PlayerProgress>();
    }

    private static void updateTreasureBags(OnGameInitialized data) {
        for (class_1792 item : Registries.ITEMS) {
            if (!(item instanceof TreasureBag)) continue;
            TreasureBag treasureBag = (TreasureBag)item;
            TREASURE_BAGS.add(treasureBag);
        }
    }

    private static void createDefaultProgress(OnPlayerLoggedIn data) {
        TreasureBagHelper.createDefaultProgress((class_1657)data.player);
    }

    private static void updateProgress(OnTreasureBagOpened data) {
        ArrayList<Integer> unlockedIndices = new ArrayList<Integer>();
        BagProgress bagProgress = TreasureBagHelper.getProgress(data.player, data.treasureBag);
        for (class_1799 itemStack : data.loot) {
            for (int idx = 0; idx < bagProgress.items.size(); ++idx) {
                ItemProgress itemProgress = bagProgress.items.get(idx);
                if (!itemProgress.id.equals((Object)Registries.ITEMS.getId((Object)itemStack.method_7909())) || !itemProgress.unlock()) continue;
                unlockedIndices.add(idx);
            }
        }
        if (!unlockedIndices.isEmpty()) {
            MajruszsDifficulty.WORLD_DATA.setDirty();
            TreasureBagHelper.sendToPlayer(data.player, Registries.ITEMS.getId((Object)data.treasureBag), bagProgress, unlockedIndices);
        }
    }

    private static void sendToPlayer(class_1657 player, class_2960 id, BagProgress bagProgress) {
        TreasureBagHelper.sendToPlayer(player, id, bagProgress, List.of());
    }

    private static void sendToPlayer(class_1657 player, class_2960 id, BagProgress bagProgress, List<Integer> unlockedIndices) {
        MajruszsDifficulty.TREASURE_BAG_PROGRESS_NETWORK.sendToClient((class_3222)player, (Object)new Progress(id, bagProgress, unlockedIndices));
    }

    private static void createDefaultProgress(BagProgress bagProgress, class_8567 params, class_2960 lootId) {
        for (class_77 lootItem : TreasureBagHelper.getLootItems(LootHelper.getLootTable((class_2960)lootId))) {
            lootItem.method_433(itemStack -> {
                class_2960 itemId = TreasureBagHelper.getId(itemStack);
                if (bagProgress.items.stream().noneMatch(itemProgress -> itemProgress.id.equals((Object)itemId))) {
                    bagProgress.items.add(new ItemProgress(itemId, false, ((IMixinLootPoolSingletonContainer)lootItem).getQuality()));
                }
            }, new class_47.class_48(params).method_309(lootId));
        }
        bagProgress.items.sort(Comparator.comparingInt(a -> -a.quality));
    }

    private static List<class_77> getLootItems(class_52 lootTable) {
        return PLATFORM.getLootPools(lootTable).flatMap(lootPool -> Arrays.stream(((IMixinLootPool)lootPool).getEntries())).filter(entry -> entry instanceof class_77).map(entry -> (class_77)entry).toList();
    }

    private static class_2960 getId(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8529) ? new class_2960("minecraft:enchanted_book") : Registries.ITEMS.getId((Object)itemStack.method_7909());
    }

    static {
        OnLevelsLoaded.listen(TreasureBagHelper::setupDefaultValues);
        OnGameInitialized.listen(TreasureBagHelper::updateTreasureBags);
        OnPlayerLoggedIn.listen(TreasureBagHelper::createDefaultProgress);
        OnTreasureBagOpened.listen(TreasureBagHelper::updateProgress);
        Serializables.getStatic(WorldData.class).define("treasure_bags", Reader.map((IReader)Reader.custom(PlayerProgress::new)), () -> PLAYERS, v -> {
            PLAYERS = v;
        });
        Serializables.get(PlayerProgress.class).define("treasure_bags", Reader.map((IReader)Reader.custom(BagProgress::new)), s -> s.treasureBags, (s, v) -> {
            s.treasureBags = v;
        });
        Serializables.get(BagProgress.class).define("items", Reader.list((IReader)Reader.custom(ItemProgress::new)), s -> s.items, (s, v) -> {
            s.items = v;
        });
        Serializables.get(ItemProgress.class).define("id", Reader.location(), s -> s.id, (s, v) -> {
            s.id = v;
        }).define("is_unlocked", Reader.bool(), s -> s.isUnlocked, (s, v) -> {
            s.isUnlocked = v;
        }).define("quality", Reader.integer(), s -> s.quality, (s, v) -> {
            s.quality = v;
        });
        Serializables.get(Progress.class).define("id", Reader.location(), s -> s.id, (s, v) -> {
            s.id = v;
        }).define("bag_progress", Reader.custom(BagProgress::new), s -> s.bagProgress, (s, v) -> {
            s.bagProgress = v;
        }).define("unlocked_indices", Reader.list((IReader)Reader.integer()), s -> s.unlockedIndices, (s, v) -> {
            s.unlockedIndices = v;
        });
    }

    public static class PlayerProgress {
        public Map<String, BagProgress> treasureBags = new HashMap<String, BagProgress>();

        public BagProgress get(TreasureBag item) {
            return this.treasureBags.computeIfAbsent(Registries.ITEMS.getId((Object)item).toString(), key -> new BagProgress());
        }
    }

    public static class BagProgress {
        public List<ItemProgress> items = new ArrayList<ItemProgress>();
    }

    public static class ItemProgress {
        public class_2960 id;
        public boolean isUnlocked;
        public int quality;

        public ItemProgress(class_2960 id, boolean isUnlocked, int quality) {
            this.id = id;
            this.isUnlocked = isUnlocked;
            this.quality = quality;
        }

        public ItemProgress() {
        }

        public boolean unlock() {
            boolean wasUnlockedAlready = this.isUnlocked;
            this.isUnlocked = true;
            return !wasUnlockedAlready;
        }
    }

    public static class Progress {
        public class_2960 id;
        public BagProgress bagProgress;
        public List<Integer> unlockedIndices;

        public Progress(class_2960 id, BagProgress bagProgress, List<Integer> unlockedIndices) {
            this.id = id;
            this.bagProgress = bagProgress;
            this.unlockedIndices = unlockedIndices;
        }

        public Progress() {
        }
    }
}

