/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.text.TextHelper;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyDefeated;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyLoaded;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyStarted;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyStateChanged;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyTicked;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyWaveFinished;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class UndeadArmy {
    public final class_3213 waveInfo = (class_3213)new class_3213((class_2561)TextHelper.empty(), class_1259.class_1260.field_5786, class_1259.class_1261.field_5791).method_5411(true);
    public final class_3213 bossInfo = new class_3213((class_2561)TextHelper.empty(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5796);
    public final List<class_3222> participants = new ArrayList<class_3222>();
    public List<MobInfo> mobsLeft = new ArrayList<MobInfo>();
    public GameStage gameStage;
    public class_2338 position;
    public Direction direction;
    public Phase phase = new Phase();
    public int currentWave = 0;
    public class_1297 boss = null;
    public boolean areEntitiesLoaded = false;

    public void start(class_2338 position, Direction direction) {
        this.gameStage = GameStageHelper.determineGameStage((class_1937)this.getLevel(), position.method_46558());
        this.position = position;
        this.direction = direction;
        this.areEntitiesLoaded = true;
        this.setState(Phase.State.STARTED, 6.4f);
        Events.dispatch((Object)new OnUndeadArmyStarted(this));
    }

    public void finish() {
        this.setState(Phase.State.FINISHED, 0.0f);
    }

    public void tick() {
        if (!this.areEntitiesLoaded) {
            this.areEntitiesLoaded = this.mobsLeft.stream().allMatch(mobInfo -> mobInfo.uuid == null || EntityHelper.isLoaded((class_3218)this.getLevel(), (UUID)mobInfo.uuid));
            if (this.areEntitiesLoaded) {
                Events.dispatch((Object)new OnUndeadArmyLoaded(this));
            } else {
                return;
            }
        }
        if (this.getLevel().method_8407() == class_1267.field_5801) {
            this.finish();
            return;
        }
        Events.dispatch((Object)new OnUndeadArmyTicked(this));
    }

    public void highlight() {
        this.forEachSpawnedUndead(entity -> entity.method_6092(new class_1293(class_1294.field_5912, TimeHelper.toTicks((double)15.0), 0)));
    }

    public void killAllMobs() {
        this.forEachSpawnedUndead(class_1297::method_5768);
        this.mobsLeft.clear();
    }

    public void setState(Phase.State state, float durationLeft) {
        this.phase.state = state;
        this.phase.ticksLeft = TimeHelper.toTicks((double)durationLeft);
        this.phase.ticksTotal = Math.max(this.phase.ticksLeft, 1);
        Events.dispatch((Object)new OnUndeadArmyStateChanged(this));
        if (this.phase.state == Phase.State.WAVE_PREPARING && this.currentWave > 0) {
            Events.dispatch((Object)new OnUndeadArmyWaveFinished(this));
        } else if (this.phase.state == Phase.State.UNDEAD_DEFEATED && this.isLastWave()) {
            Events.dispatch((Object)new OnUndeadArmyDefeated(this));
        }
    }

    public double distanceTo(class_2338 position) {
        return AnyPos.from((class_243)position.method_46558()).dist2d(this.position.method_46558()).doubleValue();
    }

    public boolean hasFinished() {
        return this.phase.state == Phase.State.FINISHED;
    }

    public boolean isInRange(class_2338 position) {
        return this.distanceTo(position) < (double)UndeadArmyConfig.AREA_RADIUS;
    }

    public boolean isLastWave() {
        return (long)this.currentWave == UndeadArmyConfig.WAVE_DEFS.stream().filter(waveDef -> this.gameStage.getOrdinal() >= waveDef.gameStage.getOrdinal()).count();
    }

    public boolean isPartOfWave(class_1297 entity) {
        return this.mobsLeft.stream().anyMatch(mobInfo -> mobInfo.uuid != null && mobInfo.uuid.equals(entity.method_5667()));
    }

    private void forEachSpawnedUndead(Consumer<class_1309> consumer) {
        this.mobsLeft.stream().map(mobInfo -> mobInfo.toEntity(this.getLevel())).filter(entity -> entity != null).forEach(entity -> consumer.accept((class_1309)entity));
    }

    public class_3218 getLevel() {
        return Side.getServer().method_30002();
    }

    static {
        Serializables.get(UndeadArmy.class).define("mobs_left", Reader.list((IReader)Reader.custom(MobInfo::new)), s -> s.mobsLeft, (s, v) -> {
            s.mobsLeft = v;
        }).define("game_stage", Reader.string(), s -> s.gameStage.getId(), (s, v) -> {
            s.gameStage = GameStageHelper.find(v);
        }).define("position", Reader.blockPos(), s -> s.position, (s, v) -> {
            s.position = v;
        }).define("direction", Reader.enumeration(Direction::values), s -> s.direction, (s, v) -> {
            s.direction = v;
        }).define("phase", Reader.custom(Phase::new), s -> s.phase, (s, v) -> {
            s.phase = v;
        }).define("current_wave", Reader.integer(), s -> s.currentWave, (s, v) -> {
            s.currentWave = v;
        });
        Serializables.get(Phase.class).define("state", Reader.enumeration(Phase.State::values), s -> s.state, (s, v) -> {
            s.state = v;
        }).define("ticks_left", Reader.integer(), s -> s.ticksLeft, (s, v) -> {
            s.ticksLeft = v;
        }).define("ticks_total", Reader.integer(), s -> s.ticksTotal, (s, v) -> {
            s.ticksTotal = v;
        }).define("health_total", Reader.integer(), s -> s.healthTotal, (s, v) -> {
            s.healthTotal = v;
        });
        Serializables.get(MobInfo.class).define("type", Reader.entityType(), s -> s.type, (s, v) -> {
            s.type = v;
        }).define("equipment", Reader.optional((IReader)Reader.location()), s -> s.equipment, (s, v) -> {
            s.equipment = v;
        }).define("position", Reader.blockPos(), s -> s.position, (s, v) -> {
            s.position = v;
        }).define("is_boss", Reader.bool(), s -> s.isBoss, (s, v) -> {
            s.isBoss = v;
        }).define("uuid", Reader.optional((IReader)Reader.uuid()), s -> s.uuid, (s, v) -> {
            s.uuid = v;
        });
    }

    public static class Phase {
        public State state = State.CREATED;
        public int ticksLeft = 0;
        public int ticksTotal = 1;
        public int healthTotal = 0;

        public float getRatio() {
            return class_3532.method_15363((float)(1.0f - (float)this.ticksLeft / (float)this.ticksTotal), (float)0.0f, (float)1.0f);
        }

        public float getTicksActive() {
            return this.ticksTotal - this.ticksLeft;
        }

        public static enum State {
            CREATED,
            STARTED,
            WAVE_PREPARING,
            WAVE_ONGOING,
            UNDEAD_DEFEATED,
            UNDEAD_WON,
            FINISHED;

        }
    }

    public static enum Direction {
        WEST(-1, 0),
        EAST(1, 0),
        NORTH(0, -1),
        SOUTH(0, 1);

        public final int x;
        public final int z;

        private Direction(int x, int z) {
            this.x = x;
            this.z = z;
        }
    }

    public static class MobInfo {
        public class_1299<?> type;
        public class_2960 equipment;
        public class_2338 position;
        public boolean isBoss = false;
        public UUID uuid = null;

        public MobInfo(UndeadArmyConfig.MobDef def, class_2338 position, boolean isBoss) {
            this.type = def.type.get();
            this.equipment = def.equipment;
            this.position = position;
            this.isBoss = isBoss;
        }

        public MobInfo() {
        }

        @Nullable
        public class_1297 toEntity(class_3218 level) {
            return this.uuid != null ? level.method_14190(this.uuid) : null;
        }

        public float getHealth(class_3218 level) {
            float f;
            class_1297 class_12972 = this.toEntity(level);
            if (class_12972 instanceof class_1309) {
                class_1309 entity = (class_1309)class_12972;
                f = entity.method_6032();
            } else {
                f = 0.0f;
            }
            return f;
        }

        public float getMaxHealth(class_3218 level) {
            float f;
            class_1297 class_12972 = this.toEntity(level);
            if (class_12972 instanceof class_1309) {
                class_1309 entity = (class_1309)class_12972;
                f = entity.method_6063();
            } else {
                f = 0.0f;
            }
            return f;
        }
    }
}

