/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszlibrary.command.Command;
import com.majruszlibrary.command.CommandData;
import com.majruszlibrary.command.IParameter;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.UndeadArmyHelper;
import com.majruszsdifficulty.undeadarmy.listeners.UndeadArmyTrigger;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class UndeadArmyCommands {
    private static final IParameter<UndeadArmy.Direction> DIRECTION = Command.enumeration(UndeadArmy.Direction::values).named("direction");
    private static final IParameter<List<class_243>> POSITIONS = Command.anyPosition();
    private static final IParameter<List<? extends class_1297>> ENTITIES = Command.entities();

    private static int start(CommandData data) throws CommandSyntaxException {
        Optional direction = data.getOptional(DIRECTION);
        List positions = data.getOptional(POSITIONS).orElseGet(List::of);
        if (positions.isEmpty()) {
            positions.add(data.getCaller().method_19538());
        }
        for (class_243 position : positions) {
            class_2338 blockPos = AnyPos.from((class_243)position).block();
            if (UndeadArmyHelper.tryToSpawn(blockPos, direction)) {
                data.source.method_9226(() -> TextHelper.translatable((String)"commands.undeadarmy.started", (Object[])new Object[]{"(%s)".formatted(blockPos.method_23854())}), true);
                continue;
            }
            data.source.method_9213((class_2561)TextHelper.translatable((String)"commands.undeadarmy.cannot_start", (Object[])new Object[]{"(%s)".formatted(blockPos.method_23854())}));
        }
        return 0;
    }

    private static int listAll(CommandData data) throws CommandSyntaxException {
        List<UndeadArmy> undeadArmies = UndeadArmyHelper.getUndeadArmies();
        if (!undeadArmies.isEmpty()) {
            class_5250 component = TextHelper.translatable((String)"commands.undeadarmy.list", (Object[])new Object[0]);
            undeadArmies.forEach(undeadArmy -> {
                component.method_27693("\n- ");
                component.method_10852((class_2561)TextHelper.translatable((String)"majruszsdifficulty.undead_army.title", (Object[])new Object[0]));
                component.method_10852((class_2561)TextHelper.empty());
                component.method_10852((class_2561)TextHelper.translatable((String)"majruszsdifficulty.undead_army.wave", (Object[])new Object[]{TextHelper.toRoman((int)Math.max(undeadArmy.currentWave, 1))}));
                component.method_27693(" (%s)".formatted(undeadArmy.position.method_23854()));
            });
            data.source.method_9226(() -> component, true);
            return 0;
        }
        data.source.method_9213((class_2561)TextHelper.translatable((String)"commands.undeadarmy.list_empty", (Object[])new Object[0]));
        return -1;
    }

    private static int sendProgress(CommandData data) throws CommandSyntaxException {
        for (class_1297 entity : data.getOptional(ENTITIES).orElseGet(() -> List.of(data.getCaller()))) {
            class_2487 tag = EntityHelper.getExtraTag((class_1297)entity);
            int undeadLeft = tag != null ? ((UndeadArmyTrigger.Progress)Serializables.read((Object)new UndeadArmyTrigger.Progress(), (class_2520)tag)).undeadLeft : UndeadArmyConfig.KILL_REQUIREMENT_FIRST;
            data.source.method_9226(() -> TextHelper.translatable((String)"commands.undeadarmy.progress", (Object[])new Object[]{entity.method_5476(), Math.max(undeadLeft, 1)}), true);
        }
        return 0;
    }

    private static void create(String command, String successId, Consumer<UndeadArmy> consumer) {
        Command.create().literal(new String[]{"undeadarmy"}).hasPermission(4).literal(new String[]{command}).execute(data -> UndeadArmyCommands.handle(data, successId, consumer)).parameter(POSITIONS).execute(data -> UndeadArmyCommands.handle(data, successId, consumer)).register();
    }

    private static int handle(CommandData data, String successId, Consumer<UndeadArmy> consumer) {
        List positions = data.getOptional(POSITIONS).orElseGet(List::of);
        if (positions.isEmpty()) {
            positions.add(data.getCaller().method_19538());
        }
        for (class_243 position : positions) {
            class_2338 blockPos = AnyPos.from((class_243)position).block();
            UndeadArmy undeadArmy = UndeadArmyHelper.findNearestUndeadArmy(blockPos);
            if (undeadArmy != null) {
                consumer.accept(undeadArmy);
                data.source.method_9226(() -> TextHelper.translatable((String)("commands.undeadarmy." + successId), (Object[])new Object[]{"(%s)".formatted(blockPos.method_23854())}), true);
                continue;
            }
            data.source.method_9213((class_2561)TextHelper.translatable((String)"commands.undeadarmy.missing", (Object[])new Object[]{"(%s)".formatted(blockPos.method_23854())}));
        }
        return 0;
    }

    static {
        Command.create().literal(new String[]{"undeadarmy"}).hasPermission(4).literal(new String[]{"start"}).execute(UndeadArmyCommands::start).parameter(DIRECTION).execute(UndeadArmyCommands::start).parameter(POSITIONS).execute(UndeadArmyCommands::start).register();
        Command.create().literal(new String[]{"undeadarmy"}).hasPermission(4).literal(new String[]{"listall"}).execute(UndeadArmyCommands::listAll).register();
        Command.create().literal(new String[]{"undeadarmy"}).hasPermission(4).literal(new String[]{"progress"}).execute(UndeadArmyCommands::sendProgress).parameter(ENTITIES).execute(UndeadArmyCommands::sendProgress).register();
        UndeadArmyCommands.create("highlight", "highlighted", UndeadArmy::highlight);
        UndeadArmyCommands.create("killall", "killed", UndeadArmy::killAllMobs);
        UndeadArmyCommands.create("stop", "finished", UndeadArmy::finish);
    }
}

