/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_2960;

public class UndeadArmyConfig {
    public static boolean IS_ENABLED = true;
    public static boolean RESET_ALL_PARTICIPANTS_KILLS = true;
    public static float WAVE_DURATION = 1200.0f;
    public static float PREPARING_DURATION = 10.0f;
    public static float HIGHLIGHT_DELAY = 300.0f;
    public static float EXTRA_PLAYER_RATIO = 0.5f;
    public static int AREA_RADIUS = 70;
    public static int KILL_REQUIREMENT = 100;
    public static int KILL_REQUIREMENT_FIRST = 25;
    public static int KILL_REQUIREMENT_WARNING = 3;
    public static List<WaveDef> WAVE_DEFS = List.of(new WaveDef(List.of(new MobDef(class_1299.field_6051, "majruszsdifficulty:undead_army/wave_1_mob", 2), new MobDef(class_1299.field_6137, "majruszsdifficulty:undead_army/wave_1_mob", 2), new MobDef(class_1299.field_6051, "majruszsdifficulty:undead_army/wave_1_mob", 2), new MobDef(class_1299.field_6137, "majruszsdifficulty:undead_army/wave_1_mob", 2)), null, "normal", 8), new WaveDef(List.of(new MobDef(class_1299.field_6051, "majruszsdifficulty:undead_army/wave_2_mob", 2), new MobDef(class_1299.field_6137, "majruszsdifficulty:undead_army/wave_2_mob", 3), new MobDef(class_1299.field_6051, "majruszsdifficulty:undead_army/wave_2_mob", 3), new MobDef(class_1299.field_6137, "majruszsdifficulty:undead_army/wave_2_mob", 2)), null, "normal", 16), new WaveDef(List.of(new MobDef(class_1299.field_6051, "majruszsdifficulty:undead_army/wave_3_mob", 3), new MobDef(class_1299.field_6137, "majruszsdifficulty:undead_army/wave_3_skeleton", 3), new MobDef(class_1299.field_6071, "majruszsdifficulty:undead_army/wave_3_mob", 3), new MobDef(class_1299.field_6098, "majruszsdifficulty:undead_army/wave_3_skeleton", 3)), new MobDef((Supplier<? extends class_1299<?>>)MajruszsDifficulty.TANK_ENTITY), "normal", 24), new WaveDef(List.of(new MobDef(class_1299.field_6051, "majruszsdifficulty:undead_army/wave_4_mob", 2), new MobDef(class_1299.field_6076, "majruszsdifficulty:undead_army/wave_4_mob", 1), new MobDef(class_1299.field_6137, "majruszsdifficulty:undead_army/wave_4_skeleton", 2), new MobDef(class_1299.field_6076, "majruszsdifficulty:undead_army/wave_4_mob", 1), new MobDef((Supplier<? extends class_1299<?>>)MajruszsDifficulty.TANK_ENTITY), new MobDef(class_1299.field_6071, "majruszsdifficulty:undead_army/wave_4_mob", 3), new MobDef(class_1299.field_6076, "majruszsdifficulty:undead_army/wave_4_mob", 1), new MobDef(class_1299.field_6098, "majruszsdifficulty:undead_army/wave_4_skeleton", 3), new MobDef(class_1299.field_6076, "majruszsdifficulty:undead_army/wave_4_mob", 1)), null, "expert", 32), new WaveDef(List.of(new MobDef(class_1299.field_6051, "majruszsdifficulty:undead_army/wave_5_mob", 1), new MobDef(class_1299.field_6137, "majruszsdifficulty:undead_army/wave_5_skeleton", 1), new MobDef(class_1299.field_6098, "majruszsdifficulty:undead_army/wave_5_skeleton", 3), new MobDef(class_1299.field_6076, "majruszsdifficulty:undead_army/wave_5_mob", 2), new MobDef((Supplier<? extends class_1299<?>>)MajruszsDifficulty.TANK_ENTITY), new MobDef(class_1299.field_6071, "majruszsdifficulty:undead_army/wave_5_mob", 3), new MobDef(class_1299.field_6076, "majruszsdifficulty:undead_army/wave_5_mob", 2)), new MobDef((Supplier<? extends class_1299<?>>)MajruszsDifficulty.CERBERUS_ENTITY), "expert", 40), new WaveDef(List.of(new MobDef(class_1299.field_6051, "majruszsdifficulty:undead_army/wave_6_mob", 1), new MobDef(class_1299.field_6137, "majruszsdifficulty:undead_army/wave_6_skeleton", 1), new MobDef((Supplier<? extends class_1299<?>>)MajruszsDifficulty.TANK_ENTITY), new MobDef(class_1299.field_6098, "majruszsdifficulty:undead_army/wave_6_skeleton", 1), new MobDef(class_1299.field_6071, "majruszsdifficulty:undead_army/wave_6_mob", 1), new MobDef(class_1299.field_6076, "majruszsdifficulty:undead_army/wave_6_wither_skeleton", 1), new MobDef((Supplier<? extends class_1299<?>>)MajruszsDifficulty.CERBERUS_ENTITY)), new MobDef((Supplier<? extends class_1299<?>>)MajruszsDifficulty.GIANT_ENTITY, "majruszsdifficulty:undead_army/wave_6_mob", 1), "master", 48));

    static {
        Serializables.getStatic(UndeadArmyConfig.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
            IS_ENABLED = v;
        }).define("reset_all_participants_kills", Reader.bool(), () -> RESET_ALL_PARTICIPANTS_KILLS, v -> {
            RESET_ALL_PARTICIPANTS_KILLS = v;
        }).define("wave_duration", Reader.number(), () -> Float.valueOf(WAVE_DURATION), v -> {
            WAVE_DURATION = ((Float)Range.of((Number)Float.valueOf(300.0f), (Number)Float.valueOf(3600.0f)).clamp((Number)v)).floatValue();
        }).define("preparing_duration", Reader.number(), () -> Float.valueOf(PREPARING_DURATION), v -> {
            PREPARING_DURATION = ((Float)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(60.0f)).clamp((Number)v)).floatValue();
        }).define("highlight_delay", Reader.number(), () -> Float.valueOf(HIGHLIGHT_DELAY), v -> {
            HIGHLIGHT_DELAY = ((Float)Range.of((Number)Float.valueOf(30.0f), (Number)Float.valueOf(3600.0f)).clamp((Number)v)).floatValue();
        }).define("extra_size_ratio_per_player", Reader.number(), () -> Float.valueOf(EXTRA_PLAYER_RATIO), v -> {
            EXTRA_PLAYER_RATIO = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)).clamp((Number)v)).floatValue();
        }).define("area_radius", Reader.integer(), () -> AREA_RADIUS, v -> {
            AREA_RADIUS = (Integer)Range.of((Number)35, (Number)140).clamp((Number)v);
        }).define("kill_requirement", Reader.integer(), () -> KILL_REQUIREMENT, v -> {
            KILL_REQUIREMENT = (Integer)Range.of((Number)0, (Number)1000).clamp((Number)v);
        }).define("kill_requirement_first", Reader.integer(), () -> KILL_REQUIREMENT_FIRST, v -> {
            KILL_REQUIREMENT_FIRST = (Integer)Range.of((Number)1, (Number)1000).clamp((Number)v);
        }).define("kill_requirement_warning", Reader.integer(), () -> KILL_REQUIREMENT_WARNING, v -> {
            KILL_REQUIREMENT_WARNING = (Integer)Range.of((Number)1, (Number)1000).clamp((Number)v);
        }).define("waves", Reader.list((IReader)Reader.custom(WaveDef::new)), () -> WAVE_DEFS, v -> {
            WAVE_DEFS = v;
        });
        Serializables.get(WaveDef.class).define("mobs", Reader.list((IReader)Reader.custom(MobDef::new)), s -> s.mobDefs, (s, v) -> {
            s.mobDefs = v;
        }).define("boss", Reader.optional((IReader)Reader.custom(MobDef::new)), s -> s.bossDef, (s, v) -> {
            s.bossDef = v;
        }).define("game_stage", Reader.string(), s -> s.gameStage.getId(), (s, v) -> {
            s.gameStage = GameStageHelper.find(v);
        }).define("exp", Reader.integer(), s -> s.experience, (s, v) -> {
            s.experience = (Integer)Range.of((Number)0, (Number)1000).clamp((Number)v);
        });
        Serializables.get(MobDef.class).define("type", Reader.entityType(), s -> s.type.get(), (s, v) -> {
            s.type = () -> v;
        }).define("equipment", Reader.optional((IReader)Reader.location()), s -> s.equipment, (s, v) -> {
            s.equipment = v;
        }).define("count", Reader.integer(), s -> s.count, (s, v) -> {
            s.count = (Integer)Range.of((Number)1, (Number)20).clamp((Number)v);
        });
    }

    public static class MobDef {
        public Supplier<? extends class_1299<?>> type;
        public class_2960 equipment;
        public int count = 1;

        public MobDef(Supplier<? extends class_1299<?>> type, String equipment, int count) {
            this.type = type;
            this.equipment = equipment != null ? new class_2960(equipment) : null;
            this.count = count;
        }

        public MobDef(class_1299<?> type, String equipment, int count) {
            this(() -> type, equipment, count);
        }

        public MobDef(Supplier<? extends class_1299<?>> type) {
            this(type, null, 1);
        }

        public MobDef() {
        }
    }

    public static class WaveDef {
        public List<MobDef> mobDefs = new ArrayList<MobDef>();
        public MobDef bossDef;
        public GameStage gameStage;
        public int experience = 0;

        public WaveDef(List<MobDef> mobDefs, MobDef bossDef, String gameStageId, int experience) {
            this.mobDefs = mobDefs;
            this.bossDef = bossDef;
            this.gameStage = GameStageHelper.find(gameStageId);
            this.experience = experience;
        }

        public WaveDef() {
        }
    }
}

