/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnLevelsLoaded;
import com.majruszlibrary.events.OnServerTicked;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.data.WorldData;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5217;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class UndeadArmyHelper {
    private static List<UndeadArmy> UNDEAD_ARMIES = new ArrayList<UndeadArmy>();

    public static boolean tryToSpawn(class_1657 player) {
        return EntityHelper.isOutside((class_1297)player) && EntityHelper.isIn((class_1297)player, (class_5321)class_1937.field_25179) && UndeadArmyHelper.tryToSpawn(UndeadArmyHelper.getAttackPosition(player), Optional.empty());
    }

    public static boolean tryToSpawn(class_2338 position, Optional<UndeadArmy.Direction> direction) {
        return UndeadArmyConfig.IS_ENABLED && UndeadArmyHelper.getLevel().method_8407() != class_1267.field_5801 && !UndeadArmyHelper.getLevel().method_8450().method_8355(class_1928.field_19422) && UndeadArmyHelper.findNearestUndeadArmy(position) == null && UndeadArmyHelper.setupNewArmy(position, direction);
    }

    @Nullable
    public static UndeadArmy findNearestUndeadArmy(class_2338 position) {
        UndeadArmy nearestArmy = null;
        double minDistance = Double.MAX_VALUE;
        for (UndeadArmy undeadArmy : UNDEAD_ARMIES) {
            double distance;
            if (!undeadArmy.isInRange(position) || !((distance = undeadArmy.distanceTo(position)) < minDistance)) continue;
            nearestArmy = undeadArmy;
            minDistance = distance;
        }
        return nearestArmy;
    }

    public static boolean isPartOfUndeadArmy(class_1297 entity) {
        return UNDEAD_ARMIES.stream().anyMatch(undeadArmy -> undeadArmy.isPartOfWave(entity));
    }

    public static List<UndeadArmy> getUndeadArmies() {
        return Collections.unmodifiableList(UNDEAD_ARMIES);
    }

    public static class_3218 getLevel() {
        return Side.getServer().method_30002();
    }

    private static void setupDefaultValues(OnLevelsLoaded data) {
        UNDEAD_ARMIES = new ArrayList<UndeadArmy>();
    }

    private static void tick(OnServerTicked data) {
        UNDEAD_ARMIES.forEach(UndeadArmy::tick);
        boolean hasAnyArmyFinished = UNDEAD_ARMIES.removeIf(UndeadArmy::hasFinished);
        if (hasAnyArmyFinished && UNDEAD_ARMIES.isEmpty()) {
            LevelHelper.setClearWeather((class_1937)UndeadArmyHelper.getLevel(), (int)TimeHelper.toTicks((double)0.5));
            class_5217 class_52172 = UndeadArmyHelper.getLevel().method_8401();
            if (class_52172 instanceof class_5268) {
                class_5268 levelData = (class_5268)class_52172;
                levelData.method_167(TimeHelper.toTicks((double)1800.0));
            }
        }
    }

    private static boolean setupNewArmy(class_2338 position, Optional<UndeadArmy.Direction> direction) {
        UndeadArmy undeadArmy = new UndeadArmy();
        undeadArmy.start(position, direction.orElse((UndeadArmy.Direction)((Object)Random.next((Object[])UndeadArmy.Direction.values()))));
        UNDEAD_ARMIES.add(undeadArmy);
        return true;
    }

    private static class_2338 getAttackPosition(class_1657 player) {
        int x = (int)player.method_23317();
        int z = (int)player.method_23321();
        return new class_2338(x, player.method_37908().method_8624(class_2902.class_2903.field_13202, x, z), z);
    }

    static {
        OnLevelsLoaded.listen(UndeadArmyHelper::setupDefaultValues);
        OnServerTicked.listen(UndeadArmyHelper::tick);
        Serializables.getStatic(WorldData.class).define("undead_armies", Reader.list((IReader)Reader.custom(UndeadArmy::new)), () -> UNDEAD_ARMIES, v -> {
            UNDEAD_ARMIES = v;
        });
    }
}

