/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy.listeners;

import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.UndeadArmyHelper;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyLoaded;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyStateChanged;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyTicked;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_2960;

public class MobSpawner {
    private static void tryToSpawn(OnUndeadArmyTicked data) {
        data.undeadArmy.mobsLeft.stream().filter(mobDef -> mobDef.uuid == null).findFirst().ifPresent(mobInfo -> MobSpawner.spawnMob(data.undeadArmy, mobInfo));
    }

    private static void generateMobList(OnUndeadArmyStateChanged data) {
        float sizeMultiplier = 1.0f + (float)(data.undeadArmy.participants.size() - 1) * UndeadArmyConfig.EXTRA_PLAYER_RATIO;
        UndeadArmyConfig.WaveDef waveDef = UndeadArmyConfig.WAVE_DEFS.get(data.undeadArmy.currentWave);
        waveDef.mobDefs.forEach(mobDef -> {
            int count = Random.round((double)((float)mobDef.count * sizeMultiplier));
            for (int idx = 0; idx < count; ++idx) {
                data.undeadArmy.mobsLeft.add(new UndeadArmy.MobInfo((UndeadArmyConfig.MobDef)mobDef, MobSpawner.getRandomSpawnPosition(data.undeadArmy), false));
            }
        });
        if (waveDef.bossDef != null) {
            data.undeadArmy.mobsLeft.add(new UndeadArmy.MobInfo(waveDef.bossDef, MobSpawner.getRandomSpawnPosition(data.undeadArmy), true));
        }
        data.undeadArmy.phase.healthTotal = 0;
    }

    private static void readdGoals(OnUndeadArmyLoaded data) {
        data.undeadArmy.mobsLeft.forEach(mobInfo -> {
            class_1297 patt2876$temp = mobInfo.toEntity(data.getServerLevel());
            if (patt2876$temp instanceof class_1314) {
                class_1314 mob = (class_1314)patt2876$temp;
                MobSpawner.addGoals(mob, data.undeadArmy.position);
            }
        });
    }

    private static void spawnMob(UndeadArmy undeadArmy, UndeadArmy.MobInfo mobInfo) {
        class_243 position = AnyPos.from((class_2338)mobInfo.position).add((Number)0.0, (Number)0.25, (Number)0.0).vec3();
        class_1297 entity = EntityHelper.createSpawner(() -> mobInfo.type, (class_1937)undeadArmy.getLevel()).position(position).spawn();
        if (!(entity instanceof class_1314)) {
            undeadArmy.mobsLeft.remove(mobInfo);
            return;
        }
        class_1314 mob = (class_1314)entity;
        mobInfo.uuid = mob.method_5667();
        MobSpawner.updateWaveHealth(undeadArmy, mobInfo);
        MobSpawner.tryToLoadEquipment(mob, mobInfo);
        MobSpawner.addGoals(mob, undeadArmy.position);
        MobSpawner.makePersistent(mob);
    }

    private static void updateWaveHealth(UndeadArmy undeadArmy, UndeadArmy.MobInfo mobInfo) {
        undeadArmy.phase.healthTotal = (int)((float)undeadArmy.phase.healthTotal + mobInfo.getMaxHealth(undeadArmy.getLevel()));
    }

    private static class_243 buildOffset(UndeadArmy undeadArmy) {
        int spawnRadius = UndeadArmyConfig.AREA_RADIUS - 15;
        UndeadArmy.Direction direction = undeadArmy.direction;
        int x = direction.z != 0 ? 24 : 8;
        int y = 0;
        int z = direction.x != 0 ? 24 : 8;
        return AnyPos.from((Number)(direction.x * spawnRadius), (Number)0, (Number)(direction.z * spawnRadius)).add(Random.nextVector((int)(-x), (int)x, (int)(-y), (int)y, (int)(-z), (int)z)).vec3();
    }

    private static void tryToLoadEquipment(class_1314 mob, UndeadArmy.MobInfo mobInfo) {
        if (mobInfo.equipment == null) {
            return;
        }
        LootHelper.getLootTable((class_2960)mobInfo.equipment).method_51878(LootHelper.toGiftParams((class_1297)mob)).forEach(itemStack -> ItemHelper.equip((class_1308)mob, (class_1799)itemStack));
        Arrays.stream(class_1304.values()).forEach(slot -> mob.method_5946(slot, 0.025f));
    }

    private static void addGoals(class_1314 mob, class_2338 position) {
        EntityHelper.getTargetSelector((class_1308)mob).method_6277(0, (class_1352)new UndeadArmyForgiveTeammateGoal(mob));
        EntityHelper.getGoalSelector((class_1308)mob).method_6277(4, (class_1352)new UndeadArmyAttackPositionGoal((class_1308)mob, position));
    }

    private static void makePersistent(class_1314 mob) {
        mob.method_5971();
    }

    private static class_2338 getRandomSpawnPosition(UndeadArmy undeadArmy) {
        int z;
        int x;
        int y;
        int tries = 0;
        do {
            class_243 offset = MobSpawner.buildOffset(undeadArmy);
            x = undeadArmy.position.method_10263() + (int)offset.field_1352;
            z = undeadArmy.position.method_10260() + (int)offset.field_1350;
        } while ((y = undeadArmy.getLevel().method_8624(class_2902.class_2903.field_13197, x, z)) != undeadArmy.getLevel().method_8624(class_2902.class_2903.field_13203, x, z) && ++tries < 5);
        return new class_2338(x, y, z);
    }

    static {
        OnUndeadArmyTicked.listen(MobSpawner::tryToSpawn).addCondition(data -> TimeHelper.haveSecondsPassed((double)1.0)).addCondition(data -> data.undeadArmy.phase.state == UndeadArmy.Phase.State.WAVE_ONGOING);
        OnUndeadArmyStateChanged.listen(MobSpawner::generateMobList).addCondition(data -> data.undeadArmy.phase.state == UndeadArmy.Phase.State.WAVE_PREPARING);
        OnUndeadArmyLoaded.listen(MobSpawner::readdGoals);
    }

    private static class UndeadArmyForgiveTeammateGoal
    extends class_1352 {
        final class_1314 mob;

        public UndeadArmyForgiveTeammateGoal(class_1314 mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public void method_6269() {
            this.mob.method_5980(null);
            this.mob.method_6015(null);
            this.mob.method_19540(false);
        }

        public boolean method_6264() {
            return this.mob.method_5968() != null && UndeadArmyHelper.isPartOfUndeadArmy((class_1297)this.mob) && UndeadArmyHelper.isPartOfUndeadArmy((class_1297)this.mob.method_5968());
        }
    }

    private static class UndeadArmyAttackPositionGoal
    extends class_1352 {
        final class_1308 undead;
        final class_2338 attackPosition;
        final class_1408 navigation;
        final float speedModifier = 1.25f;
        final float maxDistanceFromPosition = 16.0f;
        int ticksToRecalculatePath = 0;

        public UndeadArmyAttackPositionGoal(class_1308 mob, class_2338 attackPosition) {
            this.undead = mob;
            this.navigation = mob.method_5942();
            this.attackPosition = attackPosition;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return !this.isInRadius() && !this.hasAnyTarget();
        }

        public boolean method_6266() {
            return !this.method_6264() && !this.navigation.method_6357();
        }

        public void method_6269() {
            this.ticksToRecalculatePath = 0;
        }

        public void method_6268() {
            if (--this.ticksToRecalculatePath > 0) {
                return;
            }
            this.ticksToRecalculatePath = 10;
            double d = this.attackPosition.method_10263();
            double d2 = this.attackPosition.method_10264();
            double d3 = this.attackPosition.method_10260();
            Objects.requireNonNull(this);
            this.navigation.method_6337(d, d2, d3, 1.25);
        }

        private boolean isInRadius() {
            double d = this.getDistanceToAttackPosition();
            Objects.requireNonNull(this);
            return d < 16.0;
        }

        private boolean hasAnyTarget() {
            return this.undead.method_5968() != null || this.undead.method_6065() != null;
        }

        private double getDistanceToAttackPosition() {
            return AnyPos.from((class_243)this.undead.method_19538()).dist2d(this.attackPosition.method_46558()).doubleValue();
        }
    }
}

