/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy.listeners;

import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyLoaded;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyStateChanged;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyTicked;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class ProgressIndicator {
    private static void update(OnUndeadArmyTicked data) {
        ProgressIndicator.updateVisibility(data.undeadArmy);
        ProgressIndicator.updateParticipants(data.undeadArmy);
        ProgressIndicator.updateProgress(data.undeadArmy);
    }

    private static void update(OnUndeadArmyStateChanged data) {
        data.undeadArmy.waveInfo.method_5413(ProgressIndicator.getPhaseComponent(data.undeadArmy));
        if (data.undeadArmy.phase.state == UndeadArmy.Phase.State.FINISHED) {
            ProgressIndicator.removeParticipants(data.undeadArmy);
        }
    }

    private static void update(OnUndeadArmyLoaded data) {
        data.undeadArmy.waveInfo.method_5413(ProgressIndicator.getPhaseComponent(data.undeadArmy));
    }

    private static void updateVisibility(UndeadArmy undeadArmy) {
        boolean isBossAlive = undeadArmy.boss != null;
        undeadArmy.waveInfo.method_14091(undeadArmy.phase.state != UndeadArmy.Phase.State.STARTED);
        if (!undeadArmy.bossInfo.method_14093() && isBossAlive) {
            undeadArmy.bossInfo.method_5413(ProgressIndicator.getBossName(undeadArmy));
        }
        undeadArmy.bossInfo.method_14091(isBossAlive);
    }

    private static void updateParticipants(UndeadArmy undeadArmy) {
        if (undeadArmy.phase.state == UndeadArmy.Phase.State.FINISHED) {
            return;
        }
        ArrayList currentParticipants = new ArrayList(undeadArmy.waveInfo.method_14092());
        undeadArmy.participants.forEach(player -> {
            if (!currentParticipants.contains(player)) {
                undeadArmy.waveInfo.method_14088(player);
                undeadArmy.bossInfo.method_14088(player);
            }
        });
        currentParticipants.forEach(player -> {
            if (!undeadArmy.participants.contains(player)) {
                undeadArmy.waveInfo.method_14089(player);
                undeadArmy.bossInfo.method_14089(player);
            }
        });
    }

    private static void updateProgress(UndeadArmy undeadArmy) {
        switch (undeadArmy.phase.state) {
            case STARTED: {
                undeadArmy.waveInfo.method_5408(0.0f);
                break;
            }
            case WAVE_PREPARING: {
                undeadArmy.waveInfo.method_5408(undeadArmy.phase.getRatio());
                undeadArmy.bossInfo.method_5408(0.0f);
                break;
            }
            case WAVE_ONGOING: {
                undeadArmy.waveInfo.method_5408(ProgressIndicator.getHealthRatioLeft(undeadArmy));
                undeadArmy.bossInfo.method_5408(ProgressIndicator.getBossHealthRatioLeft(undeadArmy));
                break;
            }
            case UNDEAD_DEFEATED: {
                undeadArmy.waveInfo.method_5408(0.0f);
                break;
            }
            case UNDEAD_WON: {
                undeadArmy.waveInfo.method_5408(1.0f);
            }
        }
    }

    private static void removeParticipants(UndeadArmy undeadArmy) {
        undeadArmy.waveInfo.method_14094();
        undeadArmy.bossInfo.method_14094();
    }

    private static class_2561 getPhaseComponent(UndeadArmy undeadArmy) {
        return switch (undeadArmy.phase.state) {
            case UndeadArmy.Phase.State.WAVE_PREPARING -> TextHelper.translatable((String)"majruszsdifficulty.undead_army.%s".formatted(undeadArmy.currentWave > 0 ? "between_waves" : "title"), (Object[])new Object[0]);
            case UndeadArmy.Phase.State.WAVE_ONGOING -> TextHelper.translatable((String)"majruszsdifficulty.undead_army.title", (Object[])new Object[0]).method_27693(" ").method_10852((class_2561)TextHelper.translatable((String)"majruszsdifficulty.undead_army.wave", (Object[])new Object[]{TextHelper.toRoman((int)undeadArmy.currentWave)}));
            case UndeadArmy.Phase.State.UNDEAD_DEFEATED -> TextHelper.translatable((String)"majruszsdifficulty.undead_army.victory", (Object[])new Object[0]);
            case UndeadArmy.Phase.State.UNDEAD_WON -> TextHelper.translatable((String)"majruszsdifficulty.undead_army.failed", (Object[])new Object[0]);
            default -> TextHelper.empty();
        };
    }

    private static float getHealthRatioLeft(UndeadArmy undeadArmy) {
        if (ProgressIndicator.hasNooneSpawnedYet(undeadArmy)) {
            return 1.0f;
        }
        float healthLeft = 0.0f;
        float healthTotal = Math.max((float)undeadArmy.phase.healthTotal, 1.0f);
        for (UndeadArmy.MobInfo mobInfo : undeadArmy.mobsLeft) {
            healthLeft += mobInfo.getHealth(undeadArmy.getLevel());
        }
        return class_3532.method_15363((float)(healthLeft / healthTotal), (float)0.0f, (float)1.0f);
    }

    private static boolean hasNooneSpawnedYet(UndeadArmy undeadArmy) {
        return undeadArmy.mobsLeft.stream().allMatch(mob -> mob.toEntity(undeadArmy.getLevel()) == null);
    }

    private static float getBossHealthRatioLeft(UndeadArmy undeadArmy) {
        float f;
        class_1297 class_12972 = undeadArmy.boss;
        if (class_12972 instanceof class_1309) {
            class_1309 boss = (class_1309)class_12972;
            f = class_3532.method_15363((float)(boss.method_6032() / boss.method_6063()), (float)0.0f, (float)1.0f);
        } else {
            f = 0.0f;
        }
        return f;
    }

    private static class_2561 getBossName(UndeadArmy undeadArmy) {
        return undeadArmy.boss.method_5476().method_27661().method_27692(class_124.field_1061);
    }

    static {
        OnUndeadArmyTicked.listen(ProgressIndicator::update);
        OnUndeadArmyStateChanged.listen(ProgressIndicator::update);
        OnUndeadArmyLoaded.listen(ProgressIndicator::update);
    }
}

