/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects;

import com.majruszlibrary.entity.EffectDef;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.effects.bleeding.BleedingConfig;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.Animal;
import org.jetbrains.annotations.Nullable;

public class Bleeding
extends MobEffect {
    public static boolean apply(LivingEntity target, @Nullable LivingEntity attacker) {
        EffectDef effectDef = Bleeding.getCurrentEffect(GameStageHelper.determineGameStage(target.m_9236_(), target.m_20182_()));
        return target.m_7292_((net.minecraft.world.effect.MobEffectInstance)new MobEffectInstance(TimeHelper.toTicks((double)effectDef.duration), effectDef.amplifier, attacker));
    }

    public static EffectDef getCurrentEffect(GameStage gameStage) {
        return BleedingConfig.EFFECTS.get(gameStage);
    }

    public static boolean isEnabled() {
        return BleedingConfig.IS_ENABLED;
    }

    public static boolean canApplyTo(LivingEntity entity) {
        Mob mob;
        return BleedingConfig.IS_APPLICABLE_TO_ANIMALS && entity instanceof Animal || BleedingConfig.IS_APPLICABLE_TO_ILLAGERS && entity instanceof Mob && (mob = (Mob)entity).m_6336_() == MobType.f_21643_ || BleedingConfig.OTHER_APPLICABLE_MOBS.contains(entity.m_6095_());
    }

    public Bleeding() {
        super(MobEffectCategory.HARMFUL, -2271915);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
    }

    public void m_19461_(@Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entity, int amplifier, double health) {
    }

    public boolean m_6584_(int duration, int amplifier) {
        return false;
    }

    public static class MobEffectInstance
    extends net.minecraft.world.effect.MobEffectInstance {
        @Nullable
        public final Entity damageSourceEntity;

        public MobEffectInstance(int duration, int amplifier, @Nullable LivingEntity attacker) {
            super((MobEffect)MajruszsDifficulty.BLEEDING_EFFECT.get(), duration, amplifier, false, false, true);
            this.damageSourceEntity = attacker;
        }
    }
}

