/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebag;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnGameInitialized;
import com.majruszlibrary.events.OnLevelsLoaded;
import com.majruszlibrary.events.OnPlayerLoggedIn;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.platform.Services;
import com.majruszlibrary.registry.Registries;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.data.WorldData;
import com.majruszsdifficulty.items.TreasureBag;
import com.majruszsdifficulty.loot.ILootPlatform;
import com.majruszsdifficulty.mixin.IMixinLootPool;
import com.majruszsdifficulty.mixin.IMixinLootPoolSingletonContainer;
import com.majruszsdifficulty.treasurebag.events.OnTreasureBagOpened;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;

public class TreasureBagHelper {
    private static final ILootPlatform PLATFORM = (ILootPlatform)Services.load(ILootPlatform.class);
    private static final List<TreasureBag> TREASURE_BAGS = new ArrayList<TreasureBag>();
    private static Map<String, PlayerProgress> PLAYERS = new HashMap<String, PlayerProgress>();

    public static void unlockAll(Player player) {
        TreasureBagHelper.PLAYERS.get((Object)player.m_20149_()).treasureBags.forEach((id, bagProgress) -> {
            ArrayList<Integer> unlockedIndices = new ArrayList<Integer>();
            for (int idx = 0; idx < bagProgress.items.size(); ++idx) {
                if (!bagProgress.items.get(idx).unlock()) continue;
                unlockedIndices.add(idx);
            }
            TreasureBagHelper.sendToPlayer(player, new ResourceLocation(id), bagProgress, unlockedIndices);
        });
    }

    public static void clearProgress(Player player) {
        PLAYERS.remove(player.m_20149_());
        TreasureBagHelper.createDefaultProgress(player);
    }

    public static void createDefaultProgress(Player player) {
        String uuid = player.m_20149_();
        PlayerProgress playerProgress = PLAYERS.computeIfAbsent(uuid, key -> new PlayerProgress());
        LootParams params = LootHelper.toGiftParams((Entity)player);
        for (TreasureBag treasureBag : TREASURE_BAGS) {
            ResourceLocation bagId = Registries.ITEMS.getId((Object)treasureBag);
            BagProgress bagProgress = playerProgress.get(treasureBag);
            if (bagProgress.items.isEmpty()) {
                TreasureBagHelper.createDefaultProgress(bagProgress, params, treasureBag.getLootId());
            }
            TreasureBagHelper.sendToPlayer(player, bagId, bagProgress);
        }
        MajruszsDifficulty.WORLD_DATA.setDirty();
    }

    public static PlayerProgress getProgress(Player player) {
        return PLAYERS.get(player.m_20148_().toString());
    }

    public static BagProgress getProgress(Player player, TreasureBag item) {
        return TreasureBagHelper.getProgress(player).get(item);
    }

    private static void setupDefaultValues(OnLevelsLoaded data) {
        PLAYERS = new HashMap<String, PlayerProgress>();
    }

    private static void updateTreasureBags(OnGameInitialized data) {
        for (Item item : Registries.ITEMS) {
            if (!(item instanceof TreasureBag)) continue;
            TreasureBag treasureBag = (TreasureBag)item;
            TREASURE_BAGS.add(treasureBag);
        }
    }

    private static void createDefaultProgress(OnPlayerLoggedIn data) {
        TreasureBagHelper.createDefaultProgress((Player)data.player);
    }

    private static void updateProgress(OnTreasureBagOpened data) {
        ArrayList<Integer> unlockedIndices = new ArrayList<Integer>();
        BagProgress bagProgress = TreasureBagHelper.getProgress(data.player, data.treasureBag);
        for (ItemStack itemStack : data.loot) {
            for (int idx = 0; idx < bagProgress.items.size(); ++idx) {
                ItemProgress itemProgress = bagProgress.items.get(idx);
                if (!itemProgress.id.equals((Object)Registries.ITEMS.getId((Object)itemStack.m_41720_())) || !itemProgress.unlock()) continue;
                unlockedIndices.add(idx);
            }
        }
        if (!unlockedIndices.isEmpty()) {
            MajruszsDifficulty.WORLD_DATA.setDirty();
            TreasureBagHelper.sendToPlayer(data.player, Registries.ITEMS.getId((Object)data.treasureBag), bagProgress, unlockedIndices);
        }
    }

    private static void sendToPlayer(Player player, ResourceLocation id, BagProgress bagProgress) {
        TreasureBagHelper.sendToPlayer(player, id, bagProgress, List.of());
    }

    private static void sendToPlayer(Player player, ResourceLocation id, BagProgress bagProgress, List<Integer> unlockedIndices) {
        MajruszsDifficulty.TREASURE_BAG_PROGRESS_NETWORK.sendToClient((ServerPlayer)player, (Object)new Progress(id, bagProgress, unlockedIndices));
    }

    private static void createDefaultProgress(BagProgress bagProgress, LootParams params, ResourceLocation lootId) {
        for (LootItem lootItem : TreasureBagHelper.getLootItems(LootHelper.getLootTable((ResourceLocation)lootId))) {
            lootItem.m_6948_(itemStack -> {
                ResourceLocation itemId = TreasureBagHelper.getId(itemStack);
                if (bagProgress.items.stream().noneMatch(itemProgress -> itemProgress.id.equals((Object)itemId))) {
                    bagProgress.items.add(new ItemProgress(itemId, false, ((IMixinLootPoolSingletonContainer)lootItem).getQuality()));
                }
            }, new LootContext.Builder(params).m_287259_(lootId));
        }
        bagProgress.items.sort(Comparator.comparingInt(a -> -a.quality));
    }

    private static List<LootItem> getLootItems(LootTable lootTable) {
        return PLATFORM.getLootPools(lootTable).flatMap(lootPool -> Arrays.stream(((IMixinLootPool)lootPool).getEntries())).filter(entry -> entry instanceof LootItem).map(entry -> (LootItem)entry).toList();
    }

    private static ResourceLocation getId(ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_42517_) ? new ResourceLocation("minecraft:enchanted_book") : Registries.ITEMS.getId((Object)itemStack.m_41720_());
    }

    static {
        OnLevelsLoaded.listen(TreasureBagHelper::setupDefaultValues);
        OnGameInitialized.listen(TreasureBagHelper::updateTreasureBags);
        OnPlayerLoggedIn.listen(TreasureBagHelper::createDefaultProgress);
        OnTreasureBagOpened.listen(TreasureBagHelper::updateProgress);
        Serializables.getStatic(WorldData.class).define("treasure_bags", Reader.map((IReader)Reader.custom(PlayerProgress::new)), () -> PLAYERS, v -> {
            PLAYERS = v;
        });
        Serializables.get(PlayerProgress.class).define("treasure_bags", Reader.map((IReader)Reader.custom(BagProgress::new)), s -> s.treasureBags, (s, v) -> {
            s.treasureBags = v;
        });
        Serializables.get(BagProgress.class).define("items", Reader.list((IReader)Reader.custom(ItemProgress::new)), s -> s.items, (s, v) -> {
            s.items = v;
        });
        Serializables.get(ItemProgress.class).define("id", Reader.location(), s -> s.id, (s, v) -> {
            s.id = v;
        }).define("is_unlocked", Reader.bool(), s -> s.isUnlocked, (s, v) -> {
            s.isUnlocked = v;
        }).define("quality", Reader.integer(), s -> s.quality, (s, v) -> {
            s.quality = v;
        });
        Serializables.get(Progress.class).define("id", Reader.location(), s -> s.id, (s, v) -> {
            s.id = v;
        }).define("bag_progress", Reader.custom(BagProgress::new), s -> s.bagProgress, (s, v) -> {
            s.bagProgress = v;
        }).define("unlocked_indices", Reader.list((IReader)Reader.integer()), s -> s.unlockedIndices, (s, v) -> {
            s.unlockedIndices = v;
        });
    }

    public static class PlayerProgress {
        public Map<String, BagProgress> treasureBags = new HashMap<String, BagProgress>();

        public BagProgress get(TreasureBag item) {
            return this.treasureBags.computeIfAbsent(Registries.ITEMS.getId((Object)item).toString(), key -> new BagProgress());
        }
    }

    public static class BagProgress {
        public List<ItemProgress> items = new ArrayList<ItemProgress>();
    }

    public static class ItemProgress {
        public ResourceLocation id;
        public boolean isUnlocked;
        public int quality;

        public ItemProgress(ResourceLocation id, boolean isUnlocked, int quality) {
            this.id = id;
            this.isUnlocked = isUnlocked;
            this.quality = quality;
        }

        public ItemProgress() {
        }

        public boolean unlock() {
            boolean wasUnlockedAlready = this.isUnlocked;
            this.isUnlocked = true;
            return !wasUnlockedAlready;
        }
    }

    public static class Progress {
        public ResourceLocation id;
        public BagProgress bagProgress;
        public List<Integer> unlockedIndices;

        public Progress(ResourceLocation id, BagProgress bagProgress, List<Integer> unlockedIndices) {
            this.id = id;
            this.bagProgress = bagProgress;
            this.unlockedIndices = unlockedIndices;
        }

        public Progress() {
        }
    }
}

