/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.mixin;

import com.majruszlibrary.events.OnMobSpawnRateGet;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.math.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NaturalSpawner.class})
public abstract class MixinNaturalSpawner {
    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"spawnCategoryForChunk (Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/LevelChunk;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"})
    private static void spawnCategoryForChunk(MobCategory category, ServerLevel level, LevelChunk chunk, NaturalSpawner.SpawnPredicate predicate, NaturalSpawner.AfterSpawnCallback spawnCallback, CallbackInfo callbackInfo) {
        int mobsCount = Random.round(Events.dispatch(new OnMobSpawnRateGet(category, level, chunk)).getSpawnRate());
        if (mobsCount == 0) {
            callbackInfo.cancel();
        }
        int extraMobsCount = mobsCount - 1;
        for (int idx = 0; idx < extraMobsCount; ++idx) {
            NaturalSpawner.m_47038_((MobCategory)category, (ServerLevel)level, (ChunkAccess)chunk, (BlockPos)MixinNaturalSpawner.majruszlibrary$getRandomSpawnPos(level, chunk), (NaturalSpawner.SpawnPredicate)predicate, (NaturalSpawner.AfterSpawnCallback)spawnCallback);
        }
    }

    private static BlockPos majruszlibrary$getRandomSpawnPos(ServerLevel level, LevelChunk chunk) {
        ChunkPos chunkpos = chunk.m_7697_();
        int x = chunkpos.m_45604_() + Random.nextInt(16);
        int z = chunkpos.m_45605_() + Random.nextInt(16);
        int y = Random.nextInt(level.m_141937_(), chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z) + 1);
        return new BlockPos(x, y, z);
    }
}

