/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.mixin;

import com.majruszlibrary.events.OnDimensionChanged;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.events.base.Events;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayer {
    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"die (Lnet/minecraft/world/damagesource/DamageSource;)V"})
    private void die(DamageSource source, CallbackInfo callback) {
        if (Events.dispatch(new OnEntityDied(source, (LivingEntity)((ServerPlayer)this))).isDeathCancelled()) {
            callback.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"triggerDimensionChangeTriggers (Lnet/minecraft/server/level/ServerLevel;)V"})
    private void triggerDimensionChangeTriggers(ServerLevel level, CallbackInfo callback) {
        ServerPlayer player = (ServerPlayer)this;
        Events.dispatch(new OnDimensionChanged(player, level, player.m_284548_()));
    }
}

