/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects;

import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EffectHelper;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GlassRegeneration
extends MobEffect {
    private static final SoundEmitter GLASS_BREAK = SoundEmitter.of((SoundEvent)SoundEvents.f_11983_).source(SoundSource.PLAYERS).volume(SoundEmitter.randomized((float)0.25f));

    public GlassRegeneration() {
        super(MobEffectCategory.BENEFICIAL, -3318613);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity.m_21223_() < entity.m_21233_()) {
            entity.m_5634_(1.0f);
        }
    }

    public void m_19461_(@Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entity, int amplifier, double health) {
        this.m_6742_(entity, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        int cooldown = TimeHelper.toTicks((double)8.0) >> amplifier;
        return cooldown <= 0 || duration % cooldown == 0;
    }

    private static void removeOnHit(OnEntityDamaged data) {
        data.target.m_21195_((MobEffect)MajruszsDifficulty.GLASS_REGENERATION_EFFECT.get());
        GLASS_BREAK.position(data.target.m_20182_()).emit((Level)data.getServerLevel());
    }

    static {
        OnEntityDamaged.listen(GlassRegeneration::removeOnHit).addCondition(Condition.isLogicalServer()).addCondition(data -> EffectHelper.has(MajruszsDifficulty.GLASS_REGENERATION_EFFECT, (LivingEntity)data.target));
    }
}

