/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnEntitySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.events.base.CustomCondition;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public class PillagerWithFireworks {
    private static boolean IS_ENABLED = true;
    private static GameStage REQUIRED_GAME_STAGE = GameStageHelper.find("master");
    private static float CHANCE = 0.15f;
    private static boolean IS_SCALED_BY_CRD = true;
    private static float CROSSBOW_MULTISHOT_CHANCE = 0.25f;
    private static float FIREWORK_DROP_CHANCE = 0.25f;
    private static int FIREWORK_COUNT = 8;

    private static void giveFireworks(OnEntitySpawned data) {
        Pillager pillager = (Pillager)data.entity;
        ItemStack crossbow = pillager.m_21205_();
        if (crossbow.m_150930_(Items.f_42717_) && Random.check((float)CROSSBOW_MULTISHOT_CHANCE)) {
            crossbow.m_41663_(Enchantments.f_44959_, 1);
        }
        ItemStack fireworks = new ItemStack((ItemLike)Items.f_42688_, FIREWORK_COUNT);
        CompoundTag explosionTag = new CompoundTag();
        explosionTag.m_128405_("Type", 0);
        explosionTag.m_128385_("Colors", new int[]{4860464, 0x666666});
        ListTag explosionsTag = new ListTag();
        explosionsTag.add((Object)explosionTag);
        fireworks.m_41698_("Fireworks").m_128365_("Explosions", (Tag)explosionsTag);
        pillager.m_8061_(EquipmentSlot.OFFHAND, fireworks);
        pillager.m_21409_(EquipmentSlot.OFFHAND, FIREWORK_DROP_CHANCE);
    }

    static {
        OnEntitySpawned.listen(PillagerWithFireworks::giveFireworks).addCondition(Condition.isLogicalServer()).addCondition(Condition.chanceCRD(() -> Float.valueOf(CHANCE), () -> IS_SCALED_BY_CRD)).addCondition(data -> IS_ENABLED).addCondition(CustomCondition.check(REQUIRED_GAME_STAGE)).addCondition(data -> !data.isLoadedFromDisk).addCondition(data -> data.entity.m_6095_().equals(EntityType.f_20513_));
        Serializables.getStatic(Config.Features.class).define("pillager_with_fireworks", PillagerWithFireworks.class);
        Serializables.getStatic(PillagerWithFireworks.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
            IS_ENABLED = v;
        }).define("required_game_stage", Reader.string(), () -> REQUIRED_GAME_STAGE.getId(), v -> {
            REQUIRED_GAME_STAGE = GameStageHelper.find(v);
        }).define("chance", Reader.number(), () -> Float.valueOf(CHANCE), v -> {
            CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("is_scaled_by_crd", Reader.bool(), () -> IS_SCALED_BY_CRD, v -> {
            IS_SCALED_BY_CRD = v;
        }).define("crossbow_multishot_chance", Reader.number(), () -> Float.valueOf(CROSSBOW_MULTISHOT_CHANCE), v -> {
            CROSSBOW_MULTISHOT_CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("firework_drop_chance", Reader.number(), () -> Float.valueOf(FIREWORK_DROP_CHANCE), v -> {
            FIREWORK_DROP_CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("firework_count", Reader.integer(), () -> FIREWORK_COUNT, v -> {
            FIREWORK_COUNT = (Integer)Range.of((Number)1, (Number)64).clamp((Number)v);
        });
    }
}

