/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.particles;

import com.majruszlibrary.client.CustomParticle;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.time.TimeHelper;
import com.mojang.math.Axis;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class BloodParticle
extends CustomParticle {
    private final SpriteSet spriteSet;
    private final float yOffset;
    private final Quaternionf onGroundQuaternion;
    private float color;

    public BloodParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        float randomRatio = Random.nextFloat();
        this.spriteSet = spriteSet;
        this.f_107215_ = xSpeed + Random.nextDouble((double)-0.05f, (double)0.05f);
        this.f_107216_ = ySpeed * 0.5;
        this.f_107217_ = zSpeed + Random.nextDouble((double)-0.05f, (double)0.05f);
        this.f_107225_ = (int)((float)TimeHelper.toTicks((double)40.0) * Mth.m_14179_((float)randomRatio, (float)0.8f, (float)1.0f));
        this.f_107224_ = (int)((float)this.f_107225_ * Mth.m_14179_((float)randomRatio, (float)0.0f, (float)0.5f));
        this.scaleFormula = lifetime -> Float.valueOf(1.5f);
        this.yOffset = Mth.m_14179_((float)randomRatio, (float)0.001f, (float)0.005f);
        this.onGroundQuaternion = Axis.f_252529_.m_252961_(1.5707964f).rotateZ((float)((int)(randomRatio * 4.0f)) * 1.5707964f);
        this.color = Mth.m_14179_((float)randomRatio, (float)0.8f, (float)1.0f);
        this.m_108339_(this.spriteSet);
        this.updateColor();
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.spriteSet);
        this.updateColor();
    }

    public float getY(float y) {
        return y + this.yOffset;
    }

    public Quaternionf getQuaternion(Quaternionf quaternion) {
        return this.f_107218_ ? this.onGroundQuaternion : quaternion;
    }

    private void updateColor() {
        float color = this.color * (0.4f + 0.6f * (1.0f - (float)this.f_107224_ / (float)this.f_107225_));
        this.m_107253_(color, color, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    extends CustomParticle.SimpleFactory {
        public Factory(SpriteSet sprite) {
            super(sprite, BloodParticle::new);
        }
    }
}

