/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.text.TextHelper;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyDefeated;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyLoaded;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyStarted;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyStateChanged;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyTicked;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyWaveFinished;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class UndeadArmy {
    public final ServerBossEvent waveInfo = (ServerBossEvent)new ServerBossEvent((Component)TextHelper.empty(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_10).m_7006_(true);
    public final ServerBossEvent bossInfo = new ServerBossEvent((Component)TextHelper.empty(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_6);
    public final List<ServerPlayer> participants = new ArrayList<ServerPlayer>();
    public List<MobInfo> mobsLeft = new ArrayList<MobInfo>();
    public GameStage gameStage;
    public BlockPos position;
    public Direction direction;
    public Phase phase = new Phase();
    public int currentWave = 0;
    public Entity boss = null;
    public boolean areEntitiesLoaded = false;

    public void start(BlockPos position, Direction direction) {
        this.gameStage = GameStageHelper.determineGameStage((Level)this.getLevel(), position.m_252807_());
        this.position = position;
        this.direction = direction;
        this.areEntitiesLoaded = true;
        this.setState(Phase.State.STARTED, 6.4f);
        Events.dispatch((Object)new OnUndeadArmyStarted(this));
    }

    public void finish() {
        this.setState(Phase.State.FINISHED, 0.0f);
    }

    public void tick() {
        if (!this.areEntitiesLoaded) {
            this.areEntitiesLoaded = this.mobsLeft.stream().allMatch(mobInfo -> mobInfo.uuid == null || EntityHelper.isLoaded((ServerLevel)this.getLevel(), (UUID)mobInfo.uuid));
            if (this.areEntitiesLoaded) {
                Events.dispatch((Object)new OnUndeadArmyLoaded(this));
            } else {
                return;
            }
        }
        if (this.getLevel().m_46791_() == Difficulty.PEACEFUL) {
            this.finish();
            return;
        }
        Events.dispatch((Object)new OnUndeadArmyTicked(this));
    }

    public void highlight() {
        this.forEachSpawnedUndead(entity -> entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, TimeHelper.toTicks((double)15.0), 0)));
    }

    public void killAllMobs() {
        this.forEachSpawnedUndead(Entity::m_6074_);
        this.mobsLeft.clear();
    }

    public void setState(Phase.State state, float durationLeft) {
        this.phase.state = state;
        this.phase.ticksLeft = TimeHelper.toTicks((double)durationLeft);
        this.phase.ticksTotal = Math.max(this.phase.ticksLeft, 1);
        Events.dispatch((Object)new OnUndeadArmyStateChanged(this));
        if (this.phase.state == Phase.State.WAVE_PREPARING && this.currentWave > 0) {
            Events.dispatch((Object)new OnUndeadArmyWaveFinished(this));
        } else if (this.phase.state == Phase.State.UNDEAD_DEFEATED && this.isLastWave()) {
            Events.dispatch((Object)new OnUndeadArmyDefeated(this));
        }
    }

    public double distanceTo(BlockPos position) {
        return AnyPos.from((Vec3)position.m_252807_()).dist2d(this.position.m_252807_()).doubleValue();
    }

    public boolean hasFinished() {
        return this.phase.state == Phase.State.FINISHED;
    }

    public boolean isInRange(BlockPos position) {
        return this.distanceTo(position) < (double)UndeadArmyConfig.AREA_RADIUS;
    }

    public boolean isLastWave() {
        return (long)this.currentWave == UndeadArmyConfig.WAVE_DEFS.stream().filter(waveDef -> this.gameStage.getOrdinal() >= waveDef.gameStage.getOrdinal()).count();
    }

    public boolean isPartOfWave(Entity entity) {
        return this.mobsLeft.stream().anyMatch(mobInfo -> mobInfo.uuid != null && mobInfo.uuid.equals(entity.m_20148_()));
    }

    private void forEachSpawnedUndead(Consumer<LivingEntity> consumer) {
        this.mobsLeft.stream().map(mobInfo -> mobInfo.toEntity(this.getLevel())).filter(entity -> entity != null).forEach(entity -> consumer.accept((LivingEntity)entity));
    }

    public ServerLevel getLevel() {
        return Side.getServer().m_129783_();
    }

    static {
        Serializables.get(UndeadArmy.class).define("mobs_left", Reader.list((IReader)Reader.custom(MobInfo::new)), s -> s.mobsLeft, (s, v) -> {
            s.mobsLeft = v;
        }).define("game_stage", Reader.string(), s -> s.gameStage.getId(), (s, v) -> {
            s.gameStage = GameStageHelper.find(v);
        }).define("position", Reader.blockPos(), s -> s.position, (s, v) -> {
            s.position = v;
        }).define("direction", Reader.enumeration(Direction::values), s -> s.direction, (s, v) -> {
            s.direction = v;
        }).define("phase", Reader.custom(Phase::new), s -> s.phase, (s, v) -> {
            s.phase = v;
        }).define("current_wave", Reader.integer(), s -> s.currentWave, (s, v) -> {
            s.currentWave = v;
        });
        Serializables.get(Phase.class).define("state", Reader.enumeration(Phase.State::values), s -> s.state, (s, v) -> {
            s.state = v;
        }).define("ticks_left", Reader.integer(), s -> s.ticksLeft, (s, v) -> {
            s.ticksLeft = v;
        }).define("ticks_total", Reader.integer(), s -> s.ticksTotal, (s, v) -> {
            s.ticksTotal = v;
        }).define("health_total", Reader.integer(), s -> s.healthTotal, (s, v) -> {
            s.healthTotal = v;
        });
        Serializables.get(MobInfo.class).define("type", Reader.entityType(), s -> s.type, (s, v) -> {
            s.type = v;
        }).define("equipment", Reader.optional((IReader)Reader.location()), s -> s.equipment, (s, v) -> {
            s.equipment = v;
        }).define("position", Reader.blockPos(), s -> s.position, (s, v) -> {
            s.position = v;
        }).define("is_boss", Reader.bool(), s -> s.isBoss, (s, v) -> {
            s.isBoss = v;
        }).define("uuid", Reader.optional((IReader)Reader.uuid()), s -> s.uuid, (s, v) -> {
            s.uuid = v;
        });
    }

    public static class Phase {
        public State state = State.CREATED;
        public int ticksLeft = 0;
        public int ticksTotal = 1;
        public int healthTotal = 0;

        public float getRatio() {
            return Mth.m_14036_((float)(1.0f - (float)this.ticksLeft / (float)this.ticksTotal), (float)0.0f, (float)1.0f);
        }

        public float getTicksActive() {
            return this.ticksTotal - this.ticksLeft;
        }

        public static enum State {
            CREATED,
            STARTED,
            WAVE_PREPARING,
            WAVE_ONGOING,
            UNDEAD_DEFEATED,
            UNDEAD_WON,
            FINISHED;

        }
    }

    public static enum Direction {
        WEST(-1, 0),
        EAST(1, 0),
        NORTH(0, -1),
        SOUTH(0, 1);

        public final int x;
        public final int z;

        private Direction(int x, int z) {
            this.x = x;
            this.z = z;
        }
    }

    public static class MobInfo {
        public EntityType<?> type;
        public ResourceLocation equipment;
        public BlockPos position;
        public boolean isBoss = false;
        public UUID uuid = null;

        public MobInfo(UndeadArmyConfig.MobDef def, BlockPos position, boolean isBoss) {
            this.type = def.type.get();
            this.equipment = def.equipment;
            this.position = position;
            this.isBoss = isBoss;
        }

        public MobInfo() {
        }

        @Nullable
        public Entity toEntity(ServerLevel level) {
            return this.uuid != null ? level.m_8791_(this.uuid) : null;
        }

        public float getHealth(ServerLevel level) {
            float f;
            Entity entity = this.toEntity(level);
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                f = entity2.m_21223_();
            } else {
                f = 0.0f;
            }
            return f;
        }

        public float getMaxHealth(ServerLevel level) {
            float f;
            Entity entity = this.toEntity(level);
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                f = entity2.m_21233_();
            } else {
                f = 0.0f;
            }
            return f;
        }
    }
}

