/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.emitter;

import com.majruszlibrary.math.Random;
import com.majruszlibrary.registry.Registries;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SoundEmitter {
    static final Properties DEFAULT_PROPERTIES = new Properties(SoundSource.AMBIENT);
    static final Map<Object, Properties> PROPERTIES = new HashMap<Object, Properties>();
    private final SoundEvent event;
    private SoundSource source;
    private Supplier<Vec3> position = () -> Vec3.f_82478_;
    private Supplier<Float> volume;
    private Supplier<Float> pitch;

    public static void setDefault(SoundEvent event, Properties properties) {
        PROPERTIES.put(event, properties);
    }

    public static SoundEmitter of(Supplier<? extends SoundEvent> event) {
        return new SoundEmitter(event.get(), PROPERTIES.getOrDefault(event.get(), DEFAULT_PROPERTIES));
    }

    public static SoundEmitter of(SoundEvent event) {
        return SoundEmitter.of(() -> event);
    }

    public static Supplier<Float> randomized(float min, float max) {
        return () -> Float.valueOf(Random.nextFloat(min, max));
    }

    public static Supplier<Float> randomized(float value) {
        return SoundEmitter.randomized(value * 0.8f, value * 1.2f);
    }

    public void emit(Level level) {
        Vec3 position = this.position.get();
        level.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, this.event, this.source, this.volume.get().floatValue(), this.pitch.get().floatValue());
    }

    public void send(ServerPlayer player) {
        Vec3 position = this.position.get();
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Registries.SOUND_EVENTS.getHolder(this.event), this.source, position.f_82479_, position.f_82480_, position.f_82481_, this.volume.get().floatValue(), this.pitch.get().floatValue(), (long)Random.nextInt()));
    }

    public SoundEmitter source(SoundSource source) {
        this.source = source;
        return this;
    }

    public SoundEmitter position(Supplier<Vec3> position) {
        this.position = position;
        return this;
    }

    public SoundEmitter position(Vec3 position) {
        return this.position(() -> position);
    }

    public SoundEmitter volume(Supplier<Float> volume) {
        this.volume = volume;
        return this;
    }

    public SoundEmitter volume(float volume) {
        return this.volume(() -> Float.valueOf(volume));
    }

    public SoundEmitter pitch(Supplier<Float> pitch) {
        this.pitch = pitch;
        return this;
    }

    public SoundEmitter pitch(float pitch) {
        return this.pitch(() -> Float.valueOf(pitch));
    }

    private SoundEmitter(SoundEvent event, Properties properties) {
        this.event = event;
        this.source = properties.source;
        this.volume = properties.volume;
        this.pitch = properties.pitch;
    }

    static {
        SoundEmitter.setDefault(SoundEvents.f_144074_, new Properties(SoundSource.PLAYERS));
        SoundEmitter.setDefault(SoundEvents.f_11911_, new Properties(SoundSource.PLAYERS));
        SoundEmitter.setDefault(SoundEvents.f_11887_, new Properties(SoundSource.PLAYERS));
        SoundEmitter.setDefault(SoundEvents.f_11852_, new Properties(SoundSource.PLAYERS));
        SoundEmitter.setDefault(SoundEvents.f_215762_, new Properties(SoundSource.PLAYERS));
        SoundEmitter.setDefault(SoundEvents.f_12018_, new Properties(SoundSource.PLAYERS));
        SoundEmitter.setDefault(SoundEvents.f_12019_, new Properties(SoundSource.PLAYERS));
    }

    public record Properties(SoundSource source, Supplier<Float> volume, Supplier<Float> pitch) {
        public Properties(SoundSource source) {
            this(source, SoundEmitter.randomized(0.7f), SoundEmitter.randomized(1.0f));
        }
    }
}

