/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.events;

import com.majruszlibrary.events.base.Event;
import com.majruszlibrary.events.base.Events;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OnItemRenderColorsGet {
    public final ItemStack itemStack;
    private final Map<Integer, Integer> colors = new HashMap<Integer, Integer>();

    public static Event<OnItemRenderColorsGet> listen(Consumer<OnItemRenderColorsGet> consumer) {
        return Events.get(OnItemRenderColorsGet.class).add(consumer);
    }

    public OnItemRenderColorsGet(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public void add(int layerIdx, int color) {
        this.colors.put(layerIdx, color);
    }

    public boolean hasColorsDefined() {
        return this.colors.size() > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemColor toItemColor() {
        return new ItemColor(this.colors);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        private final Map<Integer, Integer> colors;

        public ItemColor(Map<Integer, Integer> colors) {
            this.colors = colors;
        }

        public int m_92671_(ItemStack itemStack, int layerIdx) {
            return this.colors.getOrDefault(layerIdx, 0xFFFFFF);
        }
    }
}

