/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.queen_bee.mixin.entities;

import com.cerbon.queen_bee.config.QBCommonConfigs;
import com.cerbon.queen_bee.item.QBItems;
import com.cerbon.queen_bee.util.IBeeEntityMixin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Bee.class})
public abstract class BeeEntityMixin
extends Animal
implements NeutralMob,
IBeeEntityMixin {
    @Unique
    private int queen_bee_despawnTime;
    @Unique
    private boolean queen_bee_canDespawn;

    public BeeEntityMixin(EntityType<? extends Bee> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void queen_bee_addCustomData(@NotNull CompoundTag pCompound, CallbackInfo ci) {
        pCompound.m_128405_("QBDespawnTime", this.queen_bee_getDespawnTime());
        pCompound.m_128379_("QBCanDespawn", this.queen_bee_canDespawn());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void queen_bee_readCustomData(@NotNull CompoundTag pCompound, CallbackInfo ci) {
        this.queen_bee_despawnTime = pCompound.m_128451_("QBDespawnTime");
        this.queen_bee_canDespawn = pCompound.m_128471_("QBCanDespawn");
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void queen_bee_despawnBee(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            if (this.queen_bee_getDespawnTime() > 0) {
                --this.queen_bee_despawnTime;
            }
            if (this.queen_bee_getDespawnTime() == 0 && this.queen_bee_canDespawn()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public boolean m_6779_(@NotNull LivingEntity target) {
        if (((Boolean)QBCommonConfigs.ENABLE_ANTENNA.get()).booleanValue()) {
            String targetDimension = target.m_9236_().m_46472_().m_135782_().toString();
            boolean isTargetInBumblezoneDimension = targetDimension.equals("the_bumblezone:the_bumblezone");
            boolean isTargetWearingAntenna = target.m_6844_(EquipmentSlot.HEAD).m_41720_() == QBItems.ANTENNA.get();
            boolean isAntennaEnabledInBlumblezoneDimension = (Boolean)QBCommonConfigs.ENABLE_ANTENNA_BUMBLEZONE_DIMENSION.get();
            if (isAntennaEnabledInBlumblezoneDimension && isTargetInBumblezoneDimension && isTargetWearingAntenna) {
                return false;
            }
            if (isTargetWearingAntenna && !isTargetInBumblezoneDimension) {
                return false;
            }
        }
        return super.m_6779_(target);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target != null && ((Boolean)QBCommonConfigs.ENABLE_ANTENNA.get()).booleanValue()) {
            String targetDimension = target.m_9236_().m_46472_().m_135782_().toString();
            boolean isTargetInBumblezoneDimension = targetDimension.equals("the_bumblezone:the_bumblezone");
            boolean isTargetWearingAntenna = target.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)QBItems.ANTENNA.get());
            boolean isAntennaEnabledInBlumblezoneDimension = (Boolean)QBCommonConfigs.ENABLE_ANTENNA_BUMBLEZONE_DIMENSION.get();
            if (isAntennaEnabledInBlumblezoneDimension && isTargetInBumblezoneDimension && isTargetWearingAntenna) {
                return;
            }
            if (isTargetWearingAntenna && !isTargetInBumblezoneDimension) {
                return;
            }
        }
        super.m_6710_(target);
    }

    @Override
    public int queen_bee_getDespawnTime() {
        return this.queen_bee_despawnTime;
    }

    @Override
    public void queen_bee_setDespawnTime(int ticks) {
        this.queen_bee_despawnTime = ticks;
    }

    @Override
    public boolean queen_bee_canDespawn() {
        return this.queen_bee_canDespawn;
    }

    @Override
    public void queen_bee_setCanDespawn(boolean canDespawn) {
        this.queen_bee_canDespawn = canDespawn;
    }
}

