/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.general.event;

import com.cerbon.cerbons_api.api.general.event.IEvent;
import java.util.function.Supplier;

public class TimedEvent
implements IEvent {
    private final Runnable callback;
    private final Supplier<Boolean> shouldCancel;
    private final int delay;
    private final int duration;
    private int age;

    public TimedEvent(Runnable callback, int delay, int duration, Supplier<Boolean> shouldCancel) {
        this.callback = callback;
        this.delay = delay;
        this.duration = duration;
        this.shouldCancel = shouldCancel;
        this.age = 0;
    }

    public TimedEvent(Runnable callback, int delay, int duration) {
        this(callback, delay, duration, () -> false);
    }

    public TimedEvent(Runnable callback, int delay, Supplier<Boolean> shouldCancel) {
        this(callback, delay, 1, shouldCancel);
    }

    public TimedEvent(Runnable callback, int delay) {
        this(callback, delay, 1, () -> false);
    }

    @Override
    public boolean shouldDoEvent() {
        return this.age++ >= this.delay && this.shouldCancel.get() == false;
    }

    @Override
    public void doEvent() {
        this.callback.run();
    }

    @Override
    public boolean shouldRemoveEvent() {
        return this.shouldCancel.get() != false || this.age >= this.delay + this.duration;
    }

    @Override
    public int tickSize() {
        return 1;
    }
}

