/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.static_utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class PacketUtils {
    public static List<Float> readFloatList(FriendlyByteBuf buf, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count should be greater than zero");
        }
        ArrayList<Float> list = new ArrayList<Float>();
        for (int i = 0; i < count; ++i) {
            list.add(Float.valueOf(buf.readFloat()));
        }
        return list;
    }

    public static void writeFloatList(FriendlyByteBuf buf, List<Float> list) {
        for (Float f : list) {
            buf.writeFloat(f.floatValue());
        }
    }

    public static void writeVec3(FriendlyByteBuf buf, Vec3 vec) {
        PacketUtils.writeFloatList(buf, Arrays.asList(Float.valueOf((float)vec.f_82479_), Float.valueOf((float)vec.f_82480_), Float.valueOf((float)vec.f_82481_)));
    }

    public static Vec3 readVec3(FriendlyByteBuf buf) {
        List<Float> floatList = PacketUtils.readFloatList(buf, 3);
        return new Vec3((double)floatList.get(0).floatValue(), (double)floatList.get(1).floatValue(), (double)floatList.get(2).floatValue());
    }
}

