/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.capability.providers;

import com.cerbon.cerbons_api.api.general.data.HistoricalData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegisterCapability
public class BlockPosHistoryProvider
implements ICapabilitySerializable<CompoundTag> {
    private final BlockPos initialValue;
    private final int maxHistory;
    private final boolean persistData;
    private BlockPosHistory positionalHistory;
    private final LazyOptional<BlockPosHistory> optional = LazyOptional.of(this::createHistoricalData);
    public static final Capability<BlockPosHistory> HISTORICAL_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<BlockPosHistory>(){});

    public BlockPosHistoryProvider(BlockPos initialValue, int maxHistory, boolean persistData) {
        this.initialValue = initialValue;
        this.maxHistory = maxHistory;
        this.persistData = persistData;
    }

    public BlockPosHistoryProvider(int maxHistory, boolean persistData) {
        this(new BlockPos(0, 0, 0), maxHistory, persistData);
    }

    private BlockPosHistory createHistoricalData() {
        if (this.positionalHistory == null) {
            this.positionalHistory = new BlockPosHistory(this.initialValue, this.maxHistory);
        }
        return this.positionalHistory;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.positionalHistory == null || !this.persistData) {
            return tag;
        }
        tag.m_128388_("LastBlocksPos", this.positionalHistory.stream().mapToLong(BlockPos::m_121878_).toArray());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (!tag.m_128441_("LastBlocksPos") || !this.persistData) {
            return;
        }
        List<BlockPos> blocksPos = Arrays.stream(tag.m_128467_("LastBlocksPos")).mapToObj(BlockPos::m_122022_).toList();
        this.positionalHistory = new BlockPosHistory(new BlockPos(0, 0, 0), this.maxHistory);
        this.positionalHistory.remove(0);
        this.positionalHistory.addAll(blocksPos);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return HISTORICAL_DATA.orEmpty(cap, this.optional);
    }

    public static class BlockPosHistory
    extends HistoricalData<BlockPos> {
        public BlockPosHistory(BlockPos initialValue, int maxHistory) {
            super(initialValue, maxHistory);
        }
    }
}

