/*
 * Decompiled with CFR 0.152.
 */
package com.clockworkcaracal.betterbees.events;

import com.clockworkcaracal.betterbees.blocks.ModBeehiveBlock;
import com.clockworkcaracal.betterbees.tileentity.ModBeehiveTileEntity;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="betterbeekeeping")
public class ModEvents {
    public static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void beeSpawn(EntityJoinWorldEvent event) {
        BeeEntity bee;
        World world = event.getWorld();
        if (!world.func_201670_d() && event.getEntity() instanceof BeeEntity && (bee = (BeeEntity)event.getEntity()).func_226409_eA_()) {
            BlockPos hive_pos = bee.func_226410_eB_();
            if (world.func_72863_F().func_225313_a(hive_pos.func_177958_n() >> 4, hive_pos.func_177956_o() >> 4) != null && world.func_226691_t_(hive_pos).func_225486_c(hive_pos) < 0.15f) {
                ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(world.field_72995_K ? LogicalSide.CLIENT : LogicalSide.SERVER);
                executor.func_212871_a_((Runnable)new TickDelayedTask(0, () -> ModEvents.beeHibernation(hive_pos, bee, world, event)));
            }
        }
    }

    private static void beeHibernation(BlockPos hive_pos, BeeEntity bee, World world, EntityJoinWorldEvent event) {
        BeehiveTileEntity hiveEntity;
        Block hive_block = world.func_180495_p(hive_pos).func_177230_c();
        if (hive_block instanceof BeehiveBlock && !(hiveEntity = (BeehiveTileEntity)world.func_175625_s(hive_pos)).func_226970_h_()) {
            event.setCanceled(true);
            hiveEntity.func_226962_a_((Entity)bee, false, -23500);
            LOGGER.debug("Bee has returned to its hive.");
        }
    }

    @SubscribeEvent
    public static void depositHoney(EntityLeaveWorldEvent event) {
        BeeEntity bee;
        World world = event.getWorld();
        if (!world.func_201670_d() && event.getEntity() instanceof BeeEntity && (bee = (BeeEntity)event.getEntity()).func_226409_eA_() && bee.func_226424_eq_() != null) {
            BlockPos hive_pos = bee.func_226410_eB_();
            BlockPos flower_pos = bee.func_226424_eq_();
            if (world.func_72863_F().func_225313_a(hive_pos.func_177958_n() >> 4, hive_pos.func_177956_o() >> 4) != null && world.func_72863_F().func_225313_a(flower_pos.func_177958_n() >> 4, flower_pos.func_177956_o() >> 4) != null) {
                ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(world.field_72995_K ? LogicalSide.CLIENT : LogicalSide.SERVER);
                executor.func_212871_a_((Runnable)new TickDelayedTask(0, () -> ModEvents.saveFlower(hive_pos, flower_pos, world)));
            }
        }
    }

    private static void saveFlower(BlockPos hive_pos, BlockPos flower_pos, World world) {
        Block hive_block = world.func_180495_p(hive_pos).func_177230_c();
        if (hive_block instanceof ModBeehiveBlock) {
            ModBeehiveTileEntity hiveEntity = (ModBeehiveTileEntity)world.func_175625_s(hive_pos);
            Block flowerBlock = world.func_180495_p(flower_pos).func_177230_c();
            if (flowerBlock instanceof FlowerBlock || flowerBlock instanceof TallFlowerBlock) {
                hiveEntity.addNectar(flowerBlock);
            }
        }
    }
}

