/*
 * Decompiled with CFR 0.152.
 */
package com.clockworkcaracal.betterbees.events;

import com.clockworkcaracal.betterbees.blockentity.ModBeehiveBlockEntity;
import com.clockworkcaracal.betterbees.blocks.ModBeehiveBlock;
import com.clockworkcaracal.betterbees.config.BetterBeeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="betterbeekeeping")
public class ModEvents {
    public static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void beeSpawn(EntityJoinLevelEvent event) {
        Bee bee;
        Level world;
        if (((Boolean)BetterBeeConfig.BEE_HIBERNATION.get()).booleanValue() && !(world = event.getLevel()).m_5776_() && event.getEntity() instanceof Bee && (bee = (Bee)event.getEntity()).m_27854_()) {
            BlockPos hive_pos = bee.m_27855_();
            if (world.m_7726_().m_7131_(hive_pos.m_123341_() >> 4, hive_pos.m_123342_() >> 4) != null && ((Biome)world.m_204166_(hive_pos).m_203334_()).m_198904_(hive_pos)) {
                BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(world.f_46443_ ? LogicalSide.CLIENT : LogicalSide.SERVER);
                executor.m_6937_((Runnable)new TickTask(0, () -> ModEvents.beeHibernation(hive_pos, bee, world, event)));
            }
        }
    }

    private static void beeHibernation(BlockPos hive_pos, Bee bee, Level world, EntityJoinLevelEvent event) {
        BeehiveBlockEntity hiveEntity;
        Block hive_block = world.m_8055_(hive_pos).m_60734_();
        if (hive_block instanceof BeehiveBlock && !(hiveEntity = (BeehiveBlockEntity)world.m_7702_(hive_pos)).m_58775_()) {
            event.setCanceled(true);
            hiveEntity.m_58744_((Entity)bee, false, -23500);
        }
    }

    @SubscribeEvent
    public static void depositHoney(EntityLeaveLevelEvent event) {
        Bee bee;
        Level world;
        if (((Boolean)BetterBeeConfig.FLAVORED_HONEY.get()).booleanValue() && !(world = event.getLevel()).m_5776_() && event.getEntity() instanceof Bee && (bee = (Bee)event.getEntity()).m_27854_() && bee.m_27851_() != null) {
            BlockPos hive_pos = bee.m_27855_();
            BlockPos flower_pos = bee.m_27851_();
            if (world.m_7726_().m_7131_(hive_pos.m_123341_() >> 4, hive_pos.m_123342_() >> 4) != null && world.m_7726_().m_7131_(flower_pos.m_123341_() >> 4, flower_pos.m_123342_() >> 4) != null) {
                BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(world.f_46443_ ? LogicalSide.CLIENT : LogicalSide.SERVER);
                executor.m_6937_((Runnable)new TickTask(0, () -> ModEvents.saveFlower(hive_pos, flower_pos, world)));
            }
        }
    }

    private static void saveFlower(BlockPos hive_pos, BlockPos flower_pos, Level world) {
        Block hive_block = world.m_8055_(hive_pos).m_60734_();
        if (hive_block instanceof ModBeehiveBlock) {
            ModBeehiveBlockEntity hiveEntity = (ModBeehiveBlockEntity)world.m_7702_(hive_pos);
            BlockState flower_state = world.m_8055_(flower_pos);
            Block flower_block = flower_state.m_60734_();
            if (flower_block instanceof FlowerBlock || flower_block instanceof TallFlowerBlock) {
                hiveEntity.addNectar(flower_state);
            }
        }
    }
}

