/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.minecraftApi;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.gson.AnimationSerializing;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class PlayerAnimationRegistry {
    private static final HashMap<class_2960, KeyframeAnimation> animations = new HashMap();

    @Nullable
    public static KeyframeAnimation getAnimation(@NotNull class_2960 identifier) {
        return animations.get(identifier);
    }

    @NotNull
    public static Optional<KeyframeAnimation> getAnimationOptional(@NotNull class_2960 identifier) {
        return Optional.ofNullable(PlayerAnimationRegistry.getAnimation(identifier));
    }

    public static Map<class_2960, KeyframeAnimation> getAnimations() {
        return Map.copyOf(animations);
    }

    public static Map<String, KeyframeAnimation> getModAnimations(String modid) {
        HashMap<String, KeyframeAnimation> map = new HashMap<String, KeyframeAnimation>();
        for (Map.Entry<class_2960, KeyframeAnimation> entry : animations.entrySet()) {
            if (!entry.getKey().method_12836().equals(modid)) continue;
            map.put(entry.getKey().method_12832(), entry.getValue());
        }
        return map;
    }

    @ApiStatus.Internal
    public static void resourceLoaderCallback(@NotNull class_3300 manager, Logger logger) {
        animations.clear();
        for (class_2960 resource : manager.method_14488("player_animation", location -> location.endsWith(".json"))) {
            try {
                InputStream input = manager.method_14486(resource).method_14482();
                try {
                    for (KeyframeAnimation animation : AnimationSerializing.deserializeAnimation(input)) {
                        animations.put(new class_2960(resource.method_12836(), PlayerAnimationRegistry.serializeTextToString((String)animation.extraData.get("name")).toLowerCase(Locale.ROOT)), animation);
                    }
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (IOException e) {
                logger.error("Error while loading payer animation: " + resource);
                logger.error(e.getMessage());
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String sStackTrace = sw.toString();
                logger.error(sStackTrace);
            }
        }
    }

    public static String serializeTextToString(String arg) {
        try {
            class_5250 component = class_2561.class_2562.method_10877((String)arg);
            if (component != null) {
                return component.getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arg.replace("\"", "");
    }
}

