/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.ChestCavityType;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganManager;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.util.ChestCavityUtil;

public class DefaultChestCavityType
implements ChestCavityType {
    private Map<class_2960, Float> defaultOrganScores = null;
    private ChestCavityInventory defaultChestCavity = new ChestCavityInventory();
    private Map<class_2960, Float> baseOrganScores = new HashMap<class_2960, Float>();
    private Map<class_1856, Map<class_2960, Float>> exceptionalOrganList = new HashMap<class_1856, Map<class_2960, Float>>();
    private List<class_1799> droppableOrgans = new LinkedList<class_1799>();
    private List<Integer> forbiddenSlots = new ArrayList<Integer>();
    private boolean bossChestCavity = false;
    private boolean playerChestCavity = false;

    public DefaultChestCavityType() {
        this.prepareDefaultChestCavity();
    }

    private void prepareDefaultChestCavity() {
        for (int i = 0; i < this.defaultChestCavity.method_5439(); ++i) {
            this.defaultChestCavity.method_5447(i, new class_1799((class_1935)class_1802.field_8831, 64));
        }
    }

    @Override
    public Map<class_2960, Float> getDefaultOrganScores() {
        if (this.defaultOrganScores == null) {
            this.defaultOrganScores = new HashMap<class_2960, Float>();
            if (!ChestCavityUtil.determineDefaultOrganScores(this)) {
                this.defaultOrganScores = null;
            }
        }
        return this.defaultOrganScores;
    }

    @Override
    public float getDefaultOrganScore(class_2960 id) {
        return this.getDefaultOrganScores().getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public ChestCavityInventory getDefaultChestCavity() {
        return this.defaultChestCavity;
    }

    public void setDefaultChestCavity(ChestCavityInventory inv) {
        this.defaultChestCavity = inv;
    }

    public Map<class_2960, Float> getBaseOrganScores() {
        return this.baseOrganScores;
    }

    public float getBaseOrganScore(class_2960 id) {
        return this.getBaseOrganScores().getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public void setBaseOrganScores(Map<class_2960, Float> organScores) {
        this.baseOrganScores = organScores;
    }

    public void setBaseOrganScore(class_2960 id, float score) {
        this.baseOrganScores.put(id, Float.valueOf(score));
    }

    public Map<class_1856, Map<class_2960, Float>> getExceptionalOrganList() {
        return this.exceptionalOrganList;
    }

    public Map<class_2960, Float> getExceptionalOrganScore(class_1799 itemStack) {
        for (class_1856 ingredient : this.getExceptionalOrganList().keySet()) {
            if (!ingredient.method_8093(itemStack)) continue;
            return this.getExceptionalOrganList().get(ingredient);
        }
        return null;
    }

    public void setExceptionalOrganList(Map<class_1856, Map<class_2960, Float>> list) {
        this.exceptionalOrganList = list;
    }

    public void setExceptionalOrgan(class_1856 ingredient, Map<class_2960, Float> scores) {
        this.exceptionalOrganList.put(ingredient, scores);
    }

    public List<class_1799> getDroppableOrgans() {
        if (this.droppableOrgans == null) {
            this.deriveDroppableOrgans();
        }
        return this.droppableOrgans;
    }

    public void setDroppableOrgans(List<class_1799> list) {
        this.droppableOrgans = list;
    }

    private void deriveDroppableOrgans() {
        this.droppableOrgans = new LinkedList<class_1799>();
        for (int i = 0; i < this.defaultChestCavity.method_5439(); ++i) {
            class_1799 stack = this.defaultChestCavity.method_5438(i);
            if (!OrganManager.isTrueOrgan(stack.method_7909())) continue;
            this.droppableOrgans.add(stack);
        }
    }

    public List<Integer> getForbiddenSlots() {
        return this.forbiddenSlots;
    }

    public void setForbiddenSlots(List<Integer> list) {
        this.forbiddenSlots = list;
    }

    public void forbidSlot(int slot) {
        this.forbiddenSlots.add(slot);
    }

    public void allowSlot(int slot) {
        int index = this.forbiddenSlots.indexOf(slot);
        if (index != -1) {
            this.forbiddenSlots.remove(index);
        }
    }

    @Override
    public boolean isSlotForbidden(int index) {
        return this.forbiddenSlots.contains(index);
    }

    public boolean isBossChestCavity() {
        return this.bossChestCavity;
    }

    public void setBossChestCavity(boolean bool) {
        this.bossChestCavity = bool;
    }

    public boolean isPlayerChestCavity() {
        return this.playerChestCavity;
    }

    public void setPlayerChestCavity(boolean bool) {
        this.playerChestCavity = bool;
    }

    @Override
    public void fillChestCavityInventory(ChestCavityInventory chestCavity) {
        chestCavity.method_5448();
        for (int i = 0; i < chestCavity.method_5439(); ++i) {
            chestCavity.method_5447(i, this.defaultChestCavity.method_5438(i));
        }
    }

    @Override
    public void loadBaseOrganScores(Map<class_2960, Float> organScores) {
        organScores.clear();
    }

    @Override
    public OrganData catchExceptionalOrgan(class_1799 slot) {
        Map<class_2960, Float> organMap = this.getExceptionalOrganScore(slot);
        if (organMap != null) {
            OrganData organData = new OrganData();
            organData.organScores = organMap;
            organData.pseudoOrgan = true;
            return organData;
        }
        return null;
    }

    @Override
    public List<class_1799> generateLootDrops(Random random, int looting) {
        ArrayList<class_1799> loot = new ArrayList<class_1799>();
        if (this.playerChestCavity) {
            return loot;
        }
        if (this.bossChestCavity) {
            this.generateGuaranteedOrganDrops(random, looting, loot);
            return loot;
        }
        if (random.nextFloat() < ChestCavity.config.UNIVERSAL_DONOR_RATE + ChestCavity.config.ORGAN_BUNDLE_LOOTING_BOOST * (float)looting) {
            this.generateRareOrganDrops(random, looting, loot);
        }
        return loot;
    }

    public void generateRareOrganDrops(Random random, int looting, List<class_1799> loot) {
        LinkedList<class_1799> organPile = new LinkedList<class_1799>(this.getDroppableOrgans());
        int rolls = 1 + random.nextInt(3) + random.nextInt(3);
        ChestCavityUtil.drawOrgansFromPile(organPile, rolls, random, loot);
    }

    public void generateGuaranteedOrganDrops(Random random, int looting, List<class_1799> loot) {
        LinkedList<class_1799> organPile = new LinkedList<class_1799>(this.getDroppableOrgans());
        int rolls = 3 + random.nextInt(2 + looting) + random.nextInt(2 + looting);
        ChestCavityUtil.drawOrgansFromPile(organPile, rolls, random, loot);
    }

    @Override
    public void setOrganCompatibility(ChestCavityInstance instance) {
        ChestCavityInventory chestCavity = instance.inventory;
        for (int i = 0; i < chestCavity.method_5439(); ++i) {
            class_1799 itemStack = chestCavity.method_5438(i);
            if (itemStack == null) continue;
            if (itemStack == class_1799.field_8037) continue;
            class_2487 tag = new class_2487();
            tag.method_25927("owner", instance.compatibility_id);
            tag.method_10582("name", instance.owner.method_5476().getString());
            itemStack.method_7959(ChestCavity.COMPATIBILITY_TAG.toString(), (class_2520)tag);
        }
        if (!this.playerChestCavity) {
            int universalOrgans = 0;
            Random random = instance.owner.method_6051();
            if (this.bossChestCavity) {
                universalOrgans = 3 + random.nextInt(2) + random.nextInt(2);
            } else if (random.nextFloat() < ChestCavity.config.UNIVERSAL_DONOR_RATE) {
                universalOrgans = 1 + random.nextInt(3) + random.nextInt(3);
            }
            while (universalOrgans > 0) {
                int i = random.nextInt(chestCavity.method_5439());
                class_1799 itemStack = chestCavity.method_5438(i);
                if (itemStack != null && itemStack != class_1799.field_8037) {
                    itemStack.method_7983(ChestCavity.COMPATIBILITY_TAG.toString());
                }
                --universalOrgans;
            }
        }
    }

    @Override
    public float getHeartBleedCap() {
        if (this.bossChestCavity) {
            return 5.0f;
        }
        return Float.MAX_VALUE;
    }

    @Override
    public boolean isOpenable(ChestCavityInstance instance) {
        boolean weakEnough = instance.owner.method_6032() <= (float)ChestCavity.config.CHEST_OPENER_ABSOLUTE_HEALTH_THRESHOLD || instance.owner.method_6032() <= instance.owner.method_6063() * ChestCavity.config.CHEST_OPENER_FRACTIONAL_HEALTH_THRESHOLD;
        boolean chestVulnerable = instance.owner.method_6118(class_1304.field_6174).method_7960();
        boolean easeOfAccess = instance.getOrganScore(CCOrganScores.EASE_OF_ACCESS) > 0.0f;
        return chestVulnerable && (easeOfAccess || weakEnough);
    }

    @Override
    public void onDeath(ChestCavityInstance cc) {
        cc.projectileQueue.clear();
        if (cc.connectedCrystal != null) {
            cc.connectedCrystal.method_6837(null);
            cc.connectedCrystal = null;
        }
        if (!(!cc.opened || this.playerChestCavity && ChestCavity.config.KEEP_CHEST_CAVITY)) {
            ChestCavityUtil.dropUnboundOrgans(cc);
        }
        if (this.playerChestCavity) {
            ChestCavityUtil.insertWelfareOrgans(cc);
        }
    }
}

