/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.instance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import ladysnake.requiem.api.v1.possession.PossessionComponent;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1511;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.ChestCavityType;
import net.tigereye.chestcavity.crossmod.requiem.CCRequiem;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.listeners.OrganOnHitContext;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChestCavityInstance
implements class_1265 {
    public static final Logger LOGGER = LogManager.getLogger();
    protected ChestCavityType type;
    public class_1309 owner;
    public UUID compatibility_id;
    public boolean opened = false;
    public ChestCavityInventory inventory = new ChestCavityInventory();
    public Map<class_2960, Float> oldOrganScores = new HashMap<class_2960, Float>();
    protected Map<class_2960, Float> organScores = new HashMap<class_2960, Float>();
    public List<OrganOnHitContext> onHitListeners = new ArrayList<OrganOnHitContext>();
    public LinkedList<Consumer<class_1309>> projectileQueue = new LinkedList();
    public int heartBleedTimer = 0;
    public int bloodPoisonTimer = 0;
    public int liverTimer = 0;
    public float metabolismRemainder = 0.0f;
    public float lungRemainder = 0.0f;
    public int projectileCooldown = 0;
    public int furnaceProgress = 0;
    public class_1511 connectedCrystal = null;
    public class_2540 updatePacket = null;
    public ChestCavityInstance ccBeingOpened = null;

    public ChestCavityInstance(ChestCavityType type, class_1309 owner) {
        this.type = type;
        this.owner = owner;
        this.compatibility_id = owner.method_5667();
        ChestCavityUtil.evaluateChestCavity(this);
    }

    public ChestCavityType getChestCavityType() {
        class_1308 victim;
        if (CCRequiem.REQUIEM_ACTIVE && (victim = PossessionComponent.getHost((class_1297)this.owner)) instanceof ChestCavityEntity) {
            return ((ChestCavityEntity)victim).getChestCavityInstance().getChestCavityType();
        }
        return this.type;
    }

    public Map<class_2960, Float> getOrganScores() {
        return this.organScores;
    }

    public void setOrganScores(Map<class_2960, Float> organScores) {
        this.organScores = organScores;
    }

    public float getOrganScore(class_2960 id) {
        class_1308 victim;
        if (CCRequiem.REQUIEM_ACTIVE && (victim = PossessionComponent.getHost((class_1297)this.owner)) instanceof ChestCavityEntity) {
            return ((ChestCavityEntity)victim).getChestCavityInstance().getOrganScore(id);
        }
        return this.organScores.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public float getOldOrganScore(class_2960 id) {
        return this.oldOrganScores.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public void method_5453(class_1263 sender) {
        ChestCavityUtil.clearForbiddenSlots(this);
        ChestCavityUtil.evaluateChestCavity(this);
    }

    public void fromTag(class_2487 tag, class_1309 owner) {
        class_2487 temp;
        LOGGER.debug("[Chest Cavity] Reading ChestCavityManager fromTag");
        this.owner = owner;
        if (tag.method_10545("ChestCavity")) {
            class_2487 ccTag = tag.method_10562("ChestCavity");
            this.opened = ccTag.method_10577("opened");
            this.heartBleedTimer = ccTag.method_10550("HeartTimer");
            this.bloodPoisonTimer = ccTag.method_10550("KidneyTimer");
            this.liverTimer = ccTag.method_10550("LiverTimer");
            this.metabolismRemainder = ccTag.method_10583("MetabolismRemainder");
            this.lungRemainder = ccTag.method_10583("LungRemainder");
            this.furnaceProgress = ccTag.method_10550("FurnaceProgress");
            this.compatibility_id = ccTag.method_10545("compatibility_id") ? ccTag.method_25926("compatibility_id") : owner.method_5667();
            try {
                this.inventory.method_5488(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (ccTag.method_10545("Inventory")) {
                class_2499 NbtList = ccTag.method_10554("Inventory", 10);
                this.inventory.readTags(NbtList);
            } else if (this.opened) {
                LOGGER.warn("[Chest Cavity] " + owner.method_5477().method_10851() + "'s Chest Cavity is mangled. It will be replaced");
                ChestCavityUtil.generateChestCavityIfOpened(this);
            }
            this.inventory.method_5489(this);
        } else if (tag.method_10545("cardinal_components") && (temp = tag.method_10562("cardinal_components")).method_10545("chestcavity:inventorycomponent") && (temp = tag.method_10562("chestcavity:inventorycomponent")).method_10545("chestcavity")) {
            LOGGER.info("[Chest Cavity] Found " + owner.method_5477().method_10851() + "'s old [Cardinal Components] Chest Cavity.");
            this.opened = true;
            class_2499 NbtList = temp.method_10554("Inventory", 10);
            try {
                this.inventory.method_5488(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.inventory.readTags(NbtList);
            this.inventory.method_5489(this);
        }
        ChestCavityUtil.evaluateChestCavity(this);
    }

    public void toTag(class_2487 tag) {
        class_2487 ccTag = new class_2487();
        ccTag.method_10556("opened", this.opened);
        ccTag.method_25927("compatibility_id", this.compatibility_id);
        ccTag.method_10569("HeartTimer", this.heartBleedTimer);
        ccTag.method_10569("KidneyTimer", this.bloodPoisonTimer);
        ccTag.method_10569("LiverTimer", this.liverTimer);
        ccTag.method_10548("MetabolismRemainder", this.metabolismRemainder);
        ccTag.method_10548("LungRemainder", this.lungRemainder);
        ccTag.method_10569("FurnaceProgress", this.liverTimer);
        ccTag.method_10566("Inventory", (class_2520)this.inventory.getTags());
        tag.method_10566("ChestCavity", (class_2520)ccTag);
    }

    public void clone(ChestCavityInstance other) {
        this.opened = other.opened;
        this.type = other.type;
        this.compatibility_id = other.compatibility_id;
        try {
            this.inventory.method_5488(this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            this.inventory.method_5447(i, other.inventory.method_5438(i));
        }
        this.inventory.readTags(other.inventory.getTags());
        this.inventory.method_5489(this);
        this.heartBleedTimer = other.heartBleedTimer;
        this.liverTimer = other.liverTimer;
        this.bloodPoisonTimer = other.bloodPoisonTimer;
        this.metabolismRemainder = other.metabolismRemainder;
        this.lungRemainder = other.lungRemainder;
        this.furnaceProgress = other.furnaceProgress;
        this.connectedCrystal = other.connectedCrystal;
        ChestCavityUtil.evaluateChestCavity(this);
    }
}

