/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.organs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganJsonFormat;

public class OrganSerializer {
    public class_3545<class_2960, OrganData> read(class_2960 id, OrganJsonFormat organJson) {
        if (organJson.itemID == null) {
            throw new JsonSyntaxException("Organ " + id + " must have an item ID");
        }
        if (organJson.organScores == null) {
            throw new JsonSyntaxException("Organ " + id + " must have organScores");
        }
        OrganData organData = new OrganData();
        class_2960 itemID = new class_2960(organJson.itemID);
        organData.pseudoOrgan = organJson.pseudoOrgan;
        organData.organScores = this.readOrganScoresFromJson(id, organJson.organScores);
        return new class_3545((Object)itemID, (Object)organData);
    }

    private Map<class_2960, Float> readOrganScoresFromJson(class_2960 id, JsonArray json) {
        HashMap<class_2960, Float> organScores = new HashMap<class_2960, Float>();
        for (JsonElement entry : json) {
            try {
                JsonObject obj = entry.getAsJsonObject();
                if (!obj.has("id")) {
                    ChestCavity.LOGGER.error("Missing id component in " + id.toString() + "'s organ scores");
                    continue;
                }
                if (!obj.has("value")) {
                    ChestCavity.LOGGER.error("Missing value component in " + id.toString() + "'s organ scores");
                    continue;
                }
                class_2960 ability = new class_2960(obj.get("id").getAsString());
                organScores.put(ability, Float.valueOf(obj.get("value").getAsFloat()));
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error parsing " + id.toString() + "'s organ scores!");
            }
        }
        return organScores;
    }
}

