/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.listeners;

import it.unimi.dsi.fastutil.ints.IntComparators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.registration.CCTags;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import net.tigereye.chestcavity.util.OrganUtil;

public class OrganActivationListeners {
    private static Map<class_2960, BiConsumer<class_1309, ChestCavityInstance>> abilityIDMap = new HashMap<class_2960, BiConsumer<class_1309, ChestCavityInstance>>();

    public static void register() {
        OrganActivationListeners.register(CCOrganScores.CREEPY, OrganActivationListeners::ActivateCreepy);
        OrganActivationListeners.register(CCOrganScores.DRAGON_BREATH, OrganActivationListeners::ActivateDragonBreath);
        OrganActivationListeners.register(CCOrganScores.DRAGON_BOMBS, OrganActivationListeners::ActivateDragonBombs);
        OrganActivationListeners.register(CCOrganScores.FORCEFUL_SPIT, OrganActivationListeners::ActivateForcefulSpit);
        OrganActivationListeners.register(CCOrganScores.FURNACE_POWERED, OrganActivationListeners::ActivateFurnacePowered);
        OrganActivationListeners.register(CCOrganScores.IRON_REPAIR, OrganActivationListeners::ActivateIronRepair);
        OrganActivationListeners.register(CCOrganScores.PYROMANCY, OrganActivationListeners::ActivatePyromancy);
        OrganActivationListeners.register(CCOrganScores.GHASTLY, OrganActivationListeners::ActivateGhastly);
        OrganActivationListeners.register(CCOrganScores.GRAZING, OrganActivationListeners::ActivateGrazing);
        OrganActivationListeners.register(CCOrganScores.SHULKER_BULLETS, OrganActivationListeners::ActivateShulkerBullets);
        OrganActivationListeners.register(CCOrganScores.SILK, OrganActivationListeners::ActivateSilk);
    }

    public static void register(class_2960 id, BiConsumer<class_1309, ChestCavityInstance> ability) {
        abilityIDMap.put(id, ability);
    }

    public static boolean activate(class_2960 id, ChestCavityInstance cc) {
        if (abilityIDMap.containsKey(id)) {
            abilityIDMap.get(id).accept(cc.owner, cc);
            return true;
        }
        return false;
    }

    public static void ActivateCreepy(class_1309 entity, ChestCavityInstance cc) {
        if (cc.getOrganScore(CCOrganScores.CREEPY) < 1.0f) {
            return;
        }
        if (entity.method_6059(CCStatusEffects.EXPLOSION_COOLDOWN)) {
            return;
        }
        float explosion_yield = cc.getOrganScore(CCOrganScores.EXPLOSIVE);
        ChestCavityUtil.destroyOrgansWithKey(cc, CCOrganScores.EXPLOSIVE);
        OrganUtil.explode(entity, explosion_yield);
        if (entity.method_5805()) {
            entity.method_6092(new class_1293(CCStatusEffects.EXPLOSION_COOLDOWN, ChestCavity.config.EXPLOSION_COOLDOWN, 0, false, false, true));
        }
    }

    public static void ActivateDragonBreath(class_1309 entity, ChestCavityInstance cc) {
        float breath = cc.getOrganScore(CCOrganScores.DRAGON_BREATH);
        if (entity instanceof class_1657) {
            ((class_1657)entity).method_7322(breath * 0.6f);
        }
        if (breath <= 0.0f) {
            return;
        }
        if (!entity.method_6059(CCStatusEffects.DRAGON_BREATH_COOLDOWN)) {
            entity.method_6092(new class_1293(CCStatusEffects.DRAGON_BREATH_COOLDOWN, ChestCavity.config.DRAGON_BREATH_COOLDOWN, 0, false, false, true));
            cc.projectileQueue.add(OrganUtil::spawnDragonBreath);
        }
    }

    public static void ActivateDragonBombs(class_1309 entity, ChestCavityInstance cc) {
        float projectiles = cc.getOrganScore(CCOrganScores.DRAGON_BOMBS);
        if (projectiles < 1.0f) {
            return;
        }
        if (!entity.method_6059(CCStatusEffects.DRAGON_BOMB_COOLDOWN)) {
            OrganUtil.queueDragonBombs(entity, cc, (int)projectiles);
        }
    }

    public static void ActivateForcefulSpit(class_1309 entity, ChestCavityInstance cc) {
        float projectiles = cc.getOrganScore(CCOrganScores.FORCEFUL_SPIT);
        if (projectiles < 1.0f) {
            return;
        }
        if (!entity.method_6059(CCStatusEffects.FORCEFUL_SPIT_COOLDOWN)) {
            OrganUtil.queueForcefulSpit(entity, cc, (int)projectiles);
        }
    }

    public static void ActivateFurnacePowered(class_1309 entity, ChestCavityInstance cc) {
        int furnacePowered = Math.round(cc.getOrganScore(CCOrganScores.FURNACE_POWERED));
        if (furnacePowered < 1) {
            return;
        }
        int fuelValue = 0;
        class_1799 itemStack = cc.owner.method_6118(class_1304.field_6173);
        if (itemStack != null && itemStack != class_1799.field_8037) {
            try {
                fuelValue = (Integer)FuelRegistry.INSTANCE.get((class_1935)itemStack.method_7909());
            }
            catch (Exception e) {
                fuelValue = 0;
            }
        }
        if (fuelValue == 0 && (itemStack = cc.owner.method_6118(class_1304.field_6171)) != null && itemStack != class_1799.field_8037) {
            try {
                fuelValue = (Integer)FuelRegistry.INSTANCE.get((class_1935)itemStack.method_7909());
            }
            catch (Exception e) {
                fuelValue = 0;
            }
        }
        if (fuelValue == 0) {
            return;
        }
        class_1293 newSEI = null;
        if (cc.owner.method_6059(CCStatusEffects.FURNACE_POWER)) {
            class_1293 oldPower = cc.owner.method_6112(CCStatusEffects.FURNACE_POWER);
            if (oldPower.method_5578() >= furnacePowered - 1) {
                return;
            }
            class_2487 oldTag = new class_2487();
            ArrayList<Integer> durations = new ArrayList<Integer>();
            durations.add(fuelValue);
            oldPower.method_5582(oldTag);
            while (true) {
                durations.add(oldTag.method_10550("Duration"));
                if (!oldTag.method_10545("HiddenEffect")) break;
                oldTag = oldTag.method_10562("HiddenEffect");
            }
            durations.sort((Comparator<Integer>)IntComparators.OPPOSITE_COMPARATOR);
            int amplifier = 0;
            for (Integer duration : durations) {
                newSEI = new class_1293(CCStatusEffects.FURNACE_POWER, duration.intValue(), amplifier, false, false, true, newSEI);
                ++amplifier;
            }
        } else {
            newSEI = new class_1293(CCStatusEffects.FURNACE_POWER, fuelValue, 0, false, false, true);
        }
        entity.method_6016(CCStatusEffects.FURNACE_POWER);
        entity.method_6092(newSEI);
        itemStack.method_7934(1);
    }

    public static void ActivateIronRepair(class_1309 entity, ChestCavityInstance cc) {
        float ironRepair = cc.getOrganScore(CCOrganScores.IRON_REPAIR) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.IRON_REPAIR);
        if (ironRepair <= 0.0f) {
            return;
        }
        if (cc.owner.method_6059(CCStatusEffects.IRON_REPAIR_COOLDOWN)) {
            return;
        }
        if (cc.owner.method_6032() >= cc.owner.method_6063()) {
            return;
        }
        class_1799 itemStack = cc.owner.method_6118(class_1304.field_6173);
        if (!(itemStack != null && CCTags.IRON_REPAIR_MATERIAL.method_15141((Object)itemStack.method_7909()) || (itemStack = cc.owner.method_6118(class_1304.field_6171)) != null && CCTags.IRON_REPAIR_MATERIAL.method_15141((Object)itemStack.method_7909()))) {
            return;
        }
        cc.owner.method_6025(cc.owner.method_6063() * ChestCavity.config.IRON_REPAIR_PERCENT);
        entity.method_5783(class_3417.field_21077, 0.75f, 1.0f);
        cc.owner.method_6092(new class_1293(CCStatusEffects.IRON_REPAIR_COOLDOWN, (int)((float)ChestCavity.config.IRON_REPAIR_COOLDOWN / ironRepair), 0, false, false, true));
        itemStack.method_7934(1);
    }

    public static void ActivateGhastly(class_1309 entity, ChestCavityInstance cc) {
        float ghastly = cc.getOrganScore(CCOrganScores.GHASTLY);
        if (ghastly < 1.0f) {
            return;
        }
        if (!entity.method_6059(CCStatusEffects.GHASTLY_COOLDOWN)) {
            OrganUtil.queueGhastlyFireballs(entity, cc, (int)ghastly);
        }
    }

    private static void ActivateGrazing(class_1309 entity, ChestCavityInstance cc) {
        float grazing = cc.getOrganScore(CCOrganScores.GRAZING);
        if (grazing <= 0.0f) {
            return;
        }
        class_2338 blockPos = entity.method_24515().method_10074();
        boolean ateGrass = false;
        if (entity.field_6002.method_8320(blockPos).method_27852(class_2246.field_10219) || entity.field_6002.method_8320(blockPos).method_27852(class_2246.field_10402)) {
            entity.field_6002.method_8652(blockPos, class_2246.field_10566.method_9564(), 2);
            ateGrass = true;
        } else if (entity.field_6002.method_8320(blockPos).method_27852(class_2246.field_22120) || entity.field_6002.method_8320(blockPos).method_27852(class_2246.field_22113)) {
            entity.field_6002.method_8652(blockPos, class_2246.field_10515.method_9564(), 2);
            ateGrass = true;
        }
        if (ateGrass) {
            int duration;
            if (entity.method_6059(CCStatusEffects.RUMINATING)) {
                class_1293 ruminating = entity.method_6112(CCStatusEffects.RUMINATING);
                duration = (int)Math.min((float)(ChestCavity.config.RUMINATION_TIME * ChestCavity.config.RUMINATION_GRASS_PER_SQUARE * ChestCavity.config.RUMINATION_SQUARES_PER_STOMACH) * grazing, (float)(ruminating.method_5584() + ChestCavity.config.RUMINATION_TIME * ChestCavity.config.RUMINATION_GRASS_PER_SQUARE));
            } else {
                duration = ChestCavity.config.RUMINATION_TIME * ChestCavity.config.RUMINATION_GRASS_PER_SQUARE;
            }
            entity.method_6092(new class_1293(CCStatusEffects.RUMINATING, duration, 0, false, false, true));
        }
    }

    public static void ActivatePyromancy(class_1309 entity, ChestCavityInstance cc) {
        float pyromancy = cc.getOrganScore(CCOrganScores.PYROMANCY);
        if (pyromancy < 1.0f) {
            return;
        }
        if (!entity.method_6059(CCStatusEffects.PYROMANCY_COOLDOWN)) {
            OrganUtil.queuePyromancyFireballs(entity, cc, (int)pyromancy);
        }
    }

    public static void ActivateShulkerBullets(class_1309 entity, ChestCavityInstance cc) {
        float projectiles = cc.getOrganScore(CCOrganScores.SHULKER_BULLETS);
        if (projectiles < 1.0f) {
            return;
        }
        if (!entity.method_6059(CCStatusEffects.SHULKER_BULLET_COOLDOWN)) {
            OrganUtil.queueShulkerBullets(entity, cc, (int)projectiles);
        }
    }

    public static void ActivateSilk(class_1309 entity, ChestCavityInstance cc) {
        if (cc.getOrganScore(CCOrganScores.SILK) == 0.0f) {
            return;
        }
        if (entity.method_6059(CCStatusEffects.SILK_COOLDOWN)) {
            return;
        }
        if (OrganUtil.spinWeb(entity, cc, cc.getOrganScore(CCOrganScores.SILK))) {
            entity.method_6092(new class_1293(CCStatusEffects.SILK_COOLDOWN, ChestCavity.config.SILK_COOLDOWN, 0, false, false, true));
        }
    }
}

