/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.listeners;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.listeners.OrganTickCallback;
import net.tigereye.chestcavity.registration.CCDamageSource;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.util.OrganUtil;

public class OrganTickListeners {
    public static void register() {
        OrganTickCallback.EVENT.register(OrganTickListeners::TickIncompatibility);
        OrganTickCallback.EVENT.register(OrganTickListeners::TickProjectileQueue);
        OrganTickCallback.EVENT.register(OrganTickListeners::TickHealth);
        OrganTickCallback.EVENT.register(OrganTickListeners::TickFiltration);
        OrganTickCallback.EVENT.register(OrganTickListeners::TickBuoyant);
        OrganTickCallback.EVENT.register(OrganTickListeners::TickCrystalsynthesis);
        OrganTickCallback.EVENT.register(OrganTickListeners::TickHydroallergenic);
        OrganTickCallback.EVENT.register(OrganTickListeners::TickHydrophobia);
        OrganTickCallback.EVENT.register(OrganTickListeners::TickGlowing);
    }

    public static void TickBuoyant(class_1309 entity, ChestCavityInstance chestCavity) {
        if (entity.method_24828() || entity.method_5740()) {
            return;
        }
        float buoyancy = chestCavity.getOrganScore(CCOrganScores.BUOYANT) - chestCavity.getChestCavityType().getDefaultOrganScore(CCOrganScores.BUOYANT);
        if (buoyancy != 0.0f) {
            entity.method_5762(0.0, (double)buoyancy * 0.02, 0.0);
        }
    }

    public static void TickCrystalsynthesis(class_1309 entity, ChestCavityInstance cc) {
        float crystalsynthesis = cc.getOrganScore(CCOrganScores.CRYSTALSYNTHESIS);
        if (cc.connectedCrystal != null) {
            if (cc.connectedCrystal.method_31481()) {
                entity.method_5643(class_1282.field_5852, crystalsynthesis * 2.0f);
                cc.connectedCrystal = null;
            } else if (crystalsynthesis != 0.0f) {
                cc.connectedCrystal.method_6837(entity.method_24515().method_10087(2));
            } else {
                cc.connectedCrystal.method_6837(null);
                cc.connectedCrystal = null;
            }
        }
        if (crystalsynthesis != 0.0f && entity.field_6002.method_8510() % (long)ChestCavity.config.CRYSTALSYNTHESIS_FREQUENCY == 0L && !(entity instanceof class_1510)) {
            class_1511 oldcrystal = cc.connectedCrystal;
            List list = entity.field_6002.method_18467(class_1511.class, entity.method_5829().method_1014((double)ChestCavity.config.CRYSTALSYNTHESIS_RANGE));
            class_1511 endCrystalEntity = null;
            double d = Double.MAX_VALUE;
            for (class_1511 endCrystalEntity2 : list) {
                double e = endCrystalEntity2.method_5858((class_1297)entity);
                if (!(e < d)) continue;
                d = e;
                endCrystalEntity = endCrystalEntity2;
            }
            cc.connectedCrystal = endCrystalEntity;
            if (oldcrystal != null && oldcrystal != cc.connectedCrystal) {
                oldcrystal.method_6837(null);
            }
            if (cc.connectedCrystal != null) {
                if (entity instanceof class_1657) {
                    class_1657 playerEntity = (class_1657)entity;
                    class_1702 hungerManager = playerEntity.method_7344();
                    if (hungerManager.method_7587()) {
                        if (crystalsynthesis >= 5.0f || (float)(entity.field_6002.method_8510() % (long)(ChestCavity.config.CRYSTALSYNTHESIS_FREQUENCY * 5)) < (float)ChestCavity.config.CRYSTALSYNTHESIS_FREQUENCY * crystalsynthesis) {
                            hungerManager.method_7585(1, 0.0f);
                        }
                    } else if (hungerManager.method_7589() < (float)hungerManager.method_7586()) {
                        hungerManager.method_7585(1, crystalsynthesis / 10.0f);
                    } else {
                        playerEntity.method_6025(crystalsynthesis / 5.0f);
                    }
                } else {
                    entity.method_6025(crystalsynthesis / 5.0f);
                }
            }
        }
    }

    public static void TickHealth(class_1309 entity, ChestCavityInstance cc) {
        if (cc.getOrganScore(CCOrganScores.HEALTH) <= 0.0f && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.HEALTH) != 0.0f) {
            if (entity.field_6002.method_8510() % (long)ChestCavity.config.HEARTBLEED_RATE == 0L) {
                ++cc.heartBleedTimer;
                entity.method_5643(CCDamageSource.HEARTBLEED, Math.min((float)cc.heartBleedTimer, cc.getChestCavityType().getHeartBleedCap()));
            }
        } else {
            cc.heartBleedTimer = 0;
        }
    }

    public static void TickFiltration(class_1309 entity, ChestCavityInstance cc) {
        if (entity.method_5770().method_8608()) {
            return;
        }
        if (cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.FILTRATION) <= 0.0f) {
            return;
        }
        float KidneyRatio = cc.getOrganScore(CCOrganScores.FILTRATION) / cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.FILTRATION);
        if (KidneyRatio < 1.0f) {
            ++cc.bloodPoisonTimer;
            if (cc.bloodPoisonTimer >= ChestCavity.config.KIDNEY_RATE) {
                entity.method_6092(new class_1293(class_1294.field_5899, (int)Math.max(1.0f, 48.0f * (1.0f - KidneyRatio))));
                cc.bloodPoisonTimer = 0;
            }
        }
    }

    private static void TickProjectileQueue(class_1309 entity, ChestCavityInstance cc) {
        if (cc.projectileCooldown > 0) {
            --cc.projectileCooldown;
            return;
        }
        if (!cc.projectileQueue.isEmpty()) {
            cc.projectileCooldown = 5;
            cc.projectileQueue.pop().accept(entity);
        }
    }

    private static void TickHydroallergenic(class_1309 entity, ChestCavityInstance cc) {
        if (entity.method_5770().method_8608()) {
            return;
        }
        float Hydroallergy = cc.getOrganScore(CCOrganScores.HYDROALLERGENIC);
        if (Hydroallergy <= 0.0f) {
            return;
        }
        if (entity.method_5869()) {
            if (!entity.method_6059(CCStatusEffects.WATER_VULNERABILITY)) {
                entity.method_5643(class_1282.field_5846, 10.0f);
                entity.method_6092(new class_1293(CCStatusEffects.WATER_VULNERABILITY, (int)(260.0f / Hydroallergy), 0, false, false, true));
            }
        } else if (entity.method_5721() && !entity.method_6059(CCStatusEffects.WATER_VULNERABILITY)) {
            entity.method_5643(class_1282.field_5846, 1.0f);
            entity.method_6092(new class_1293(CCStatusEffects.WATER_VULNERABILITY, (int)(260.0f / Hydroallergy), 0, false, false, true));
        }
    }

    public static void TickHydrophobia(class_1309 entity, ChestCavityInstance cc) {
        float hydrophobia = cc.getOrganScore(CCOrganScores.HYDROPHOBIA);
        if (hydrophobia <= 0.0f || cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.HYDROPHOBIA) != 0.0f) {
            return;
        }
        if (entity.method_5721()) {
            OrganUtil.teleportRandomly(entity, hydrophobia * 32.0f);
        }
    }

    public static void TickIncompatibility(class_1309 entity, ChestCavityInstance chestCavity) {
        if (entity.method_5770().method_8608() || ChestCavity.config.DISABLE_ORGAN_REJECTION) {
            return;
        }
        float incompatibility = chestCavity.getOrganScore(CCOrganScores.INCOMPATIBILITY);
        if (incompatibility > 0.0f && !entity.method_6059(CCStatusEffects.ORGAN_REJECTION)) {
            entity.method_6092(new class_1293(CCStatusEffects.ORGAN_REJECTION, (int)((float)ChestCavity.config.ORGAN_REJECTION_RATE / incompatibility), 0, false, true, true));
        }
    }

    public static void TickGlowing(class_1309 entity, ChestCavityInstance chestCavity) {
        if (entity.method_5770().method_8608()) {
            return;
        }
        float glowing = chestCavity.getOrganScore(CCOrganScores.GLOWING);
        if (glowing > 0.0f && !entity.method_6059(class_1294.field_5912)) {
            entity.method_6092(new class_1293(class_1294.field_5912, 200, 0, false, true, true));
        }
    }
}

