/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.util;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.ChestCavityType;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganManager;
import net.tigereye.chestcavity.crossmod.requiem.CCRequiem;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.listeners.OrganAddStatusEffectCallback;
import net.tigereye.chestcavity.listeners.OrganOnHitContext;
import net.tigereye.chestcavity.listeners.OrganOnHitListener;
import net.tigereye.chestcavity.listeners.OrganTickCallback;
import net.tigereye.chestcavity.listeners.OrganUpdateCallback;
import net.tigereye.chestcavity.registration.CCEnchantments;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.registration.CCTagOrgans;
import net.tigereye.chestcavity.util.NetworkUtil;
import net.tigereye.chestcavity.util.OrganUtil;

public class ChestCavityUtil {
    public static void addOrganScore(class_2960 id, float value, Map<class_2960, Float> organScores) {
        organScores.put(id, Float.valueOf(organScores.getOrDefault(id, Float.valueOf(0.0f)).floatValue() + value));
    }

    public static float applyBoneDefense(ChestCavityInstance cc, float damage) {
        float boneDiff = (cc.getOrganScore(CCOrganScores.DEFENSE) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.DEFENSE)) / 4.0f;
        return (float)((double)damage * Math.pow(1.0f - ChestCavity.config.BONE_DEFENSE, boneDiff));
    }

    public static int applyBreathInWater(ChestCavityInstance cc, int oldAir, int newAir) {
        if (!cc.opened || cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.BREATH_CAPACITY) == cc.getOrganScore(CCOrganScores.BREATH_CAPACITY) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.WATERBREATH) == cc.getOrganScore(CCOrganScores.WATERBREATH)) {
            return newAir;
        }
        float airLoss = 1.0f;
        float waterBreath = cc.getOrganScore(CCOrganScores.WATERBREATH);
        if (cc.owner.method_5624()) {
            waterBreath /= 4.0f;
        }
        if (waterBreath > 0.0f) {
            airLoss += -2.0f * waterBreath;
        }
        if (airLoss > 0.0f) {
            if (oldAir == newAir) {
                airLoss = 0.0f;
            } else {
                float capacity = cc.getOrganScore(CCOrganScores.BREATH_CAPACITY);
                if ((airLoss *= (float)(oldAir - newAir)) > 0.0f) {
                    float lungRatio = 20.0f;
                    if (capacity != 0.0f) {
                        lungRatio = Math.min(2.0f / capacity, 20.0f);
                    }
                    airLoss = airLoss * lungRatio + cc.lungRemainder;
                }
            }
        }
        cc.lungRemainder = airLoss % 1.0f;
        int airResult = Math.min(oldAir - (int)airLoss, cc.owner.method_5748());
        if (airResult <= -20) {
            airResult = 0;
            cc.lungRemainder = 0.0f;
            cc.owner.method_5643(class_1282.field_5859, 2.0f);
        }
        return airResult;
    }

    public static int applyBreathOnLand(ChestCavityInstance cc, int oldAir, int airGain) {
        if (!cc.opened || cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.BREATH_RECOVERY) == cc.getOrganScore(CCOrganScores.BREATH_RECOVERY) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.BREATH_CAPACITY) == cc.getOrganScore(CCOrganScores.BREATH_CAPACITY) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.WATERBREATH) == cc.getOrganScore(CCOrganScores.WATERBREATH)) {
            return oldAir;
        }
        float airLoss = cc.owner.method_6059(class_1294.field_5923) || cc.owner.method_6059(class_1294.field_5927) ? 0.0f : 1.0f;
        float breath = cc.getOrganScore(CCOrganScores.BREATH_RECOVERY);
        if (cc.owner.method_5624()) {
            breath /= 4.0f;
        }
        if (cc.owner.method_5721()) {
            breath += cc.getOrganScore(CCOrganScores.WATERBREATH) / 4.0f;
        }
        if (breath > 0.0f) {
            airLoss += (float)(-airGain) * breath / 2.0f;
        }
        if (airLoss > 0.0f) {
            int resperation = class_1890.method_8211((class_1309)cc.owner);
            if (cc.owner.method_6051().nextInt(resperation + 1) != 0) {
                airLoss = 0.0f;
            } else {
                float capacity = cc.getOrganScore(CCOrganScores.BREATH_CAPACITY);
                float breathRatio = 20.0f;
                if (capacity != 0.0f) {
                    breathRatio = Math.min(2.0f / capacity, 20.0f);
                }
                airLoss = airLoss * breathRatio + cc.lungRemainder;
            }
        } else if (oldAir == cc.owner.method_5748()) {
            return oldAir;
        }
        cc.lungRemainder = airLoss % 1.0f;
        int airResult = Math.min(oldAir - (int)airLoss - airGain, cc.owner.method_5748());
        if (airResult <= -20) {
            airResult = 0;
            cc.lungRemainder = 0.0f;
            cc.owner.method_5643(class_1282.field_5859, 2.0f);
        }
        return airResult;
    }

    public static float applyDefenses(ChestCavityInstance cc, class_1282 source, float damage) {
        if (!cc.opened) {
            return damage;
        }
        if (ChestCavityUtil.attemptArrowDodging(cc, source)) {
            return 0.0f;
        }
        if (!source.method_5537()) {
            damage = ChestCavityUtil.applyBoneDefense(cc, damage);
        }
        if (source == class_1282.field_5868) {
            damage = ChestCavityUtil.applyLeapingToFallDamage(cc, damage);
        }
        if (source == class_1282.field_5868 || source == class_1282.field_5843) {
            damage = ChestCavityUtil.applyImpactResistant(cc, damage);
        }
        if (source.method_5534()) {
            damage = ChestCavityUtil.applyFireResistant(cc, damage);
        }
        return damage;
    }

    public static int applyDigestion(ChestCavityInstance cc, float digestion, int hunger) {
        if (digestion == 1.0f) {
            return hunger;
        }
        if (digestion < 0.0f) {
            cc.owner.method_6092(new class_1293(class_1294.field_5916, (int)((float)(-hunger) * digestion * 400.0f)));
            return 0;
        }
        return Math.max((int)((float)hunger * digestion), 1);
    }

    public static float applyFireResistant(ChestCavityInstance cc, float damage) {
        float fireproof = cc.getOrganScore(CCOrganScores.FIRE_RESISTANT);
        if (fireproof > 0.0f) {
            return (float)((double)damage * Math.pow(1.0f - ChestCavity.config.FIREPROOF_DEFENSE, fireproof / 4.0f));
        }
        return damage;
    }

    public static float applyImpactResistant(ChestCavityInstance cc, float damage) {
        float impactResistant = cc.getOrganScore(CCOrganScores.IMPACT_RESISTANT);
        if (impactResistant > 0.0f) {
            return (float)((double)damage * Math.pow(1.0f - ChestCavity.config.IMPACT_DEFENSE, impactResistant / 4.0f));
        }
        return damage;
    }

    public static Float applyLeaping(ChestCavityInstance cc, float velocity) {
        float leaping = cc.getOrganScore(CCOrganScores.LEAPING);
        float defaultLeaping = cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.LEAPING);
        return Float.valueOf(velocity * Math.max(0.0f, 1.0f + (leaping - defaultLeaping) * 0.25f));
    }

    public static float applyLeapingToFallDamage(ChestCavityInstance cc, float damage) {
        float leapingDiff = cc.getOrganScore(CCOrganScores.LEAPING) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.LEAPING);
        if (leapingDiff > 0.0f) {
            return Math.max(0.0f, damage - leapingDiff * leapingDiff / 4.0f);
        }
        return damage;
    }

    public static float applyNutrition(ChestCavityInstance cc, float nutrition, float saturation) {
        if (nutrition == 4.0f) {
            return saturation;
        }
        if (nutrition < 0.0f) {
            cc.owner.method_6092(new class_1293(class_1294.field_5903, (int)(saturation * nutrition * 800.0f)));
            return 0.0f;
        }
        return saturation * nutrition / 4.0f;
    }

    public static int applySpleenMetabolism(ChestCavityInstance cc, int foodStarvationTimer) {
        if (!cc.opened) {
            return foodStarvationTimer;
        }
        float metabolismDiff = cc.getOrganScore(CCOrganScores.METABOLISM) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.METABOLISM);
        if (metabolismDiff == 0.0f) {
            return foodStarvationTimer;
        }
        if (metabolismDiff > 0.0f) {
            cc.metabolismRemainder += metabolismDiff;
            foodStarvationTimer += (int)cc.metabolismRemainder;
        } else {
            cc.metabolismRemainder += 1.0f - 1.0f / (-metabolismDiff + 1.0f);
            foodStarvationTimer -= (int)cc.metabolismRemainder;
        }
        cc.metabolismRemainder %= 1.0f;
        return foodStarvationTimer;
    }

    public static float applySwimSpeedInWater(ChestCavityInstance cc) {
        if (!cc.opened || !cc.owner.method_5799()) {
            return 1.0f;
        }
        float speedDiff = cc.getOrganScore(CCOrganScores.SWIM_SPEED) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.SWIM_SPEED);
        if (speedDiff == 0.0f) {
            return 1.0f;
        }
        return Math.max(0.0f, 1.0f + speedDiff * ChestCavity.config.SWIMSPEED_FACTOR / 8.0f);
    }

    public static boolean attemptArrowDodging(ChestCavityInstance cc, class_1282 source) {
        float dodge = cc.getOrganScore(CCOrganScores.ARROW_DODGING);
        if (dodge == 0.0f) {
            return false;
        }
        if (cc.owner.method_6059(CCStatusEffects.ARROW_DODGE_COOLDOWN)) {
            return false;
        }
        if (!(source instanceof class_1284)) {
            return false;
        }
        if (!OrganUtil.teleportRandomly(cc.owner, (float)ChestCavity.config.ARROW_DODGE_DISTANCE / dodge)) {
            return false;
        }
        cc.owner.method_6092(new class_1293(CCStatusEffects.ARROW_DODGE_COOLDOWN, (int)((float)ChestCavity.config.ARROW_DODGE_COOLDOWN / dodge), 0, false, false, true));
        return true;
    }

    public static void clearForbiddenSlots(ChestCavityInstance cc) {
        try {
            cc.inventory.method_5488(cc);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (int i = 0; i < cc.inventory.method_5439(); ++i) {
            if (!cc.getChestCavityType().isSlotForbidden(i)) continue;
            cc.owner.method_5775(cc.inventory.method_5441(i));
        }
        cc.inventory.method_5489(cc);
    }

    public static void destroyOrgansWithKey(ChestCavityInstance cc, class_2960 organ) {
        for (int i = 0; i < cc.inventory.method_5439(); ++i) {
            OrganData organData;
            class_1799 slot = cc.inventory.method_5438(i);
            if (slot == null || slot == class_1799.field_8037 || (organData = ChestCavityUtil.lookupOrgan(slot, cc.getChestCavityType())) == null || !organData.organScores.containsKey(organ)) continue;
            cc.inventory.method_5441(i);
        }
        cc.inventory.method_5431();
    }

    public static boolean determineDefaultOrganScores(ChestCavityType chestCavityType) {
        Map<class_2960, Float> organScores = chestCavityType.getDefaultOrganScores();
        chestCavityType.loadBaseOrganScores(organScores);
        try {
            for (int i = 0; i < chestCavityType.getDefaultChestCavity().method_5439(); ++i) {
                class_1799 itemStack = chestCavityType.getDefaultChestCavity().method_5438(i);
                if (itemStack == null || itemStack == class_1799.field_8037) continue;
                class_1792 slotitem = itemStack.method_7909();
                OrganData data = ChestCavityUtil.lookupOrgan(itemStack, chestCavityType);
                if (data == null) continue;
                data.organScores.forEach((key, value) -> ChestCavityUtil.addOrganScore(key, value.floatValue() * Math.min((float)itemStack.method_7947() / (float)itemStack.method_7914(), 1.0f), organScores));
            }
        }
        catch (IllegalStateException e) {
            ChestCavity.LOGGER.warn(e.getMessage() + ". Chest Cavity will attempt to calculate this default organ score later.");
            return false;
        }
        return true;
    }

    public static void drawOrgansFromPile(List<class_1799> organPile, int rolls, Random random, List<class_1799> loot) {
        for (int i = 0; i < rolls && !organPile.isEmpty(); ++i) {
            int roll = random.nextInt(organPile.size());
            int count = 1;
            class_1799 rolledItem = organPile.remove(roll).method_7972();
            if (rolledItem.method_7947() > 1) {
                count += random.nextInt(rolledItem.method_7914());
            }
            rolledItem.method_7939(count);
            loot.add(rolledItem);
        }
    }

    public static void dropUnboundOrgans(ChestCavityInstance cc) {
        if (ChestCavity.config.REQUIEM_INTEGRATION && class_2378.field_11145.method_10221((Object)cc.owner.method_5864()).method_12833(CCRequiem.PLAYER_SHELL_ID) == 0) {
            return;
        }
        try {
            cc.inventory.method_5488(cc);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (int i = 0; i < cc.inventory.method_5439(); ++i) {
            int compatibility;
            class_1799 itemStack = cc.inventory.method_5438(i);
            if (itemStack == null || itemStack == class_1799.field_8037 || (compatibility = ChestCavityUtil.getCompatibilityLevel(cc, itemStack)) >= 2) continue;
            cc.owner.method_5775(cc.inventory.method_5441(i));
        }
        cc.inventory.method_5489(cc);
        ChestCavityUtil.evaluateChestCavity(cc);
    }

    public static void evaluateChestCavity(ChestCavityInstance cc) {
        Map<class_2960, Float> organScores = cc.getOrganScores();
        if (!cc.opened) {
            organScores.clear();
            if (cc.getChestCavityType().getDefaultOrganScores() != null) {
                organScores.putAll(cc.getChestCavityType().getDefaultOrganScores());
            }
        } else {
            cc.onHitListeners.clear();
            cc.getChestCavityType().loadBaseOrganScores(organScores);
            for (int i = 0; i < cc.inventory.method_5439(); ++i) {
                int compatibility;
                class_1799 itemStack = cc.inventory.method_5438(i);
                if (itemStack == null || itemStack == class_1799.field_8037) continue;
                class_1792 slotitem = itemStack.method_7909();
                OrganData data = ChestCavityUtil.lookupOrgan(itemStack, cc.getChestCavityType());
                if (data == null) continue;
                data.organScores.forEach((key, value) -> ChestCavityUtil.addOrganScore(key, value.floatValue() * Math.min((float)itemStack.method_7947() / (float)itemStack.method_7914(), 1.0f), organScores));
                if (slotitem instanceof OrganOnHitListener) {
                    cc.onHitListeners.add(new OrganOnHitContext(itemStack, (OrganOnHitListener)slotitem));
                }
                if (data.pseudoOrgan || (compatibility = ChestCavityUtil.getCompatibilityLevel(cc, itemStack)) >= 1) continue;
                ChestCavityUtil.addOrganScore(CCOrganScores.INCOMPATIBILITY, 1.0f, organScores);
            }
        }
        ChestCavityUtil.organUpdate(cc);
    }

    public static void forcefullyAddStack(ChestCavityInstance cc, class_1799 stack, int slot) {
        if (!cc.inventory.method_27070(stack)) {
            if (!cc.inventory.method_27070(stack) && cc.owner.method_5770().method_8450().method_8355(class_1928.field_19389) && cc.owner instanceof class_1657) {
                if (!((class_1657)cc.owner).method_31548().method_7394(stack)) {
                    cc.owner.method_5775(cc.inventory.method_5441(slot));
                }
            } else {
                cc.owner.method_5775(cc.inventory.method_5441(slot));
            }
        }
        cc.inventory.method_5491(stack);
    }

    public static void generateChestCavityIfOpened(ChestCavityInstance cc) {
        if (cc.opened) {
            cc.inventory.readTags(cc.getChestCavityType().getDefaultChestCavity().getTags());
            cc.getChestCavityType().setOrganCompatibility(cc);
        }
    }

    public static int getCompatibilityLevel(ChestCavityInstance cc, class_1799 itemStack) {
        if (itemStack != null && itemStack != class_1799.field_8037) {
            if (class_1890.method_8225((class_1887)CCEnchantments.MALPRACTICE, (class_1799)itemStack) > 0) {
                return 0;
            }
            int oNegative = class_1890.method_8225((class_1887)CCEnchantments.O_NEGATIVE, (class_1799)itemStack);
            int ownership = 0;
            class_2487 tag = itemStack.method_7969();
            if (tag != null && tag.method_10545(ChestCavity.COMPATIBILITY_TAG.toString())) {
                if ((tag = tag.method_10562(ChestCavity.COMPATIBILITY_TAG.toString())).method_25926("owner").equals(cc.compatibility_id)) {
                    ownership = 2;
                }
            } else {
                ownership = 1;
            }
            return Math.max(oNegative, ownership);
        }
        return 1;
    }

    public static void insertWelfareOrgans(ChestCavityInstance cc) {
        if (cc.getOrganScore(CCOrganScores.HEALTH) == 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new class_1799((class_1935)CCItems.ROTTEN_HEART), 4);
        }
        if (cc.getOrganScore(CCOrganScores.BREATH_RECOVERY) == 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new class_1799((class_1935)CCItems.ROTTEN_LUNG), 3);
        }
        if (cc.getOrganScore(CCOrganScores.NERVES) == 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new class_1799((class_1935)CCItems.ROTTEN_SPINE), 13);
        }
        if (cc.getOrganScore(CCOrganScores.STRENGTH) == 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new class_1799((class_1935)class_1802.field_8511, 16), 0);
        }
    }

    public static boolean isHydroPhobicOrAllergic(class_1309 entity) {
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of((class_1297)entity);
        if (optional.isPresent()) {
            ChestCavityInstance cc = optional.get().getChestCavityInstance();
            return cc.getOrganScore(CCOrganScores.HYDROALLERGENIC) > 0.0f || cc.getOrganScore(CCOrganScores.HYDROPHOBIA) > 0.0f;
        }
        return false;
    }

    protected static OrganData lookupOrgan(class_1799 itemStack, ChestCavityType cct) {
        OrganData organData = cct.catchExceptionalOrgan(itemStack);
        if (organData != null) {
            return organData;
        }
        if (OrganManager.hasEntry(itemStack.method_7909())) {
            return OrganManager.getEntry(itemStack.method_7909());
        }
        for (class_3494<class_1792> itemTag : CCTagOrgans.tagMap.keySet()) {
            if (!itemStack.method_31573(itemTag)) continue;
            organData = new OrganData();
            organData.pseudoOrgan = true;
            organData.organScores = CCTagOrgans.tagMap.get(itemTag);
            return organData;
        }
        return null;
    }

    public static class_1293 onAddStatusEffect(ChestCavityInstance cc, class_1293 effect) {
        return ((OrganAddStatusEffectCallback)OrganAddStatusEffectCallback.EVENT.invoker()).onAddStatusEffect(cc.owner, cc, effect);
    }

    public static float onHit(ChestCavityInstance cc, class_1282 source, class_1309 target, float damage) {
        if (cc.opened) {
            for (OrganOnHitContext e : cc.onHitListeners) {
                damage = e.listener.onHit(source, cc.owner, target, cc, e.organ, damage);
            }
            ChestCavityUtil.organUpdate(cc);
        }
        return damage;
    }

    public static void onTick(ChestCavityInstance cc) {
        if (cc.updatePacket != null) {
            NetworkUtil.SendS2CChestCavityUpdatePacket(cc, cc.updatePacket);
        }
        if (cc.opened) {
            ((OrganTickCallback)OrganTickCallback.EVENT.invoker()).onOrganTick(cc.owner, cc);
            ChestCavityUtil.organUpdate(cc);
        }
    }

    public static ChestCavityInventory openChestCavity(ChestCavityInstance cc) {
        if (!cc.opened) {
            try {
                cc.inventory.method_5488(cc);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            cc.opened = true;
            ChestCavityUtil.generateChestCavityIfOpened(cc);
            cc.inventory.method_5489(cc);
        }
        return cc.inventory;
    }

    public static void organUpdate(ChestCavityInstance cc) {
        Map<class_2960, Float> organScores = cc.getOrganScores();
        if (!cc.oldOrganScores.equals(organScores)) {
            ((OrganUpdateCallback)OrganUpdateCallback.EVENT.invoker()).onOrganUpdate(cc.owner, cc);
            cc.oldOrganScores.clear();
            cc.oldOrganScores.putAll(organScores);
            NetworkUtil.SendS2CChestCavityUpdatePacket(cc);
        }
    }

    public static void outputOrganScoresString(Consumer<String> output, ChestCavityInstance cc) {
        try {
            class_2561 name = cc.owner.method_5476();
            output.accept("[Chest Cavity] Displaying " + name.getString() + "'s organ scores:");
        }
        catch (Exception e) {
            output.accept("[Chest Cavity] Displaying organ scores:");
        }
        cc.getOrganScores().forEach((key, value) -> output.accept(key.method_12832() + ": " + value + " "));
    }
}

