/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.util;

import java.util.HashMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganManager;
import net.tigereye.chestcavity.listeners.OrganActivationListeners;
import net.tigereye.chestcavity.registration.CCNetworkingPackets;

public class NetworkUtil {
    public static class_2540 WriteChestCavityUpdatePacket(ChestCavityInstance cc) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(cc.opened);
        buf.writeInt(cc.getOrganScores().size());
        cc.getOrganScores().forEach((id, value) -> {
            buf.method_10814(id.toString());
            buf.writeFloat(value.floatValue());
        });
        return buf;
    }

    public static void ReadChestCavityUpdatePacket(ChestCavityInstance cc, class_2540 buf) {
        HashMap<class_2960, Float> organScores = new HashMap<class_2960, Float>();
        cc.opened = buf.readBoolean();
        int entries = buf.readInt();
        for (int i = 0; i < entries; ++i) {
            organScores.put(new class_2960(buf.method_19772()), Float.valueOf(buf.readFloat()));
        }
        cc.setOrganScores(organScores);
        NetworkUtil.SendC2SChestCavityReceivedUpdatePacket(cc);
    }

    public static boolean SendS2CChestCavityUpdatePacket(ChestCavityInstance cc) {
        cc.updatePacket = NetworkUtil.WriteChestCavityUpdatePacket(cc);
        return NetworkUtil.SendS2CChestCavityUpdatePacket(cc, cc.updatePacket);
    }

    public static boolean SendS2CChestCavityUpdatePacket(ChestCavityInstance cc, class_2540 buf) {
        if (!cc.owner.field_6002.method_8608() && cc.owner instanceof class_3222) {
            class_3222 spe = (class_3222)cc.owner;
            if (spe.field_13987 != null) {
                try {
                    ServerPlayNetworking.send((class_3222)spe, (class_2960)CCNetworkingPackets.UPDATE_PACKET_ID, (class_2540)buf);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public static void ReadChestCavityReceivedUpdatePacket(ChestCavityInstance cc) {
        cc.updatePacket = null;
    }

    public static boolean SendC2SChestCavityReceivedUpdatePacket(ChestCavityInstance cc) {
        ClientPlayNetworking.send((class_2960)CCNetworkingPackets.RECEIVED_UPDATE_PACKET_ID, (class_2540)PacketByteBufs.empty());
        return NetworkUtil.SendS2CChestCavityUpdatePacket(cc, cc.updatePacket);
    }

    public static class_2540 WriteChestCavityHotkeyPacket(class_2960 organScore) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(organScore);
        return buf;
    }

    public static void ReadChestCavityHotkeyPacket(ChestCavityInstance cc, class_2540 buf) {
        class_2960 id = buf.method_10810();
        OrganActivationListeners.activate(id, cc);
    }

    public static void SendC2SChestCavityHotkeyPacket(class_2960 organScore) {
        ClientPlayNetworking.send((class_2960)CCNetworkingPackets.HOTKEY_PACKET_ID, (class_2540)NetworkUtil.WriteChestCavityHotkeyPacket(organScore));
    }

    public static void sendOrganDataPacket(class_3248 serverLoginNetworkHandler, MinecraftServer minecraftServer, PacketSender packetSender, ServerLoginNetworking.LoginSynchronizer loginSynchronizer) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(OrganManager.GeneratedOrganData.size());
        OrganManager.GeneratedOrganData.forEach((id, data) -> {
            buf.method_10812(id);
            buf.writeBoolean(data.pseudoOrgan);
            buf.writeInt(data.organScores.size());
            data.organScores.forEach((ability, score) -> {
                buf.method_10812(ability);
                buf.writeFloat(score.floatValue());
            });
        });
        packetSender.sendPacket(CCNetworkingPackets.ORGAN_DATA_PACKET_ID, buf);
    }

    public static boolean readOrganDataPacket(class_2540 buf) {
        OrganManager.GeneratedOrganData.clear();
        try {
            int organCount = buf.readInt();
            for (int i = 0; i < organCount; ++i) {
                class_2960 organID = buf.method_10810();
                OrganData organData = new OrganData();
                organData.pseudoOrgan = buf.readBoolean();
                int organAbilityCount = buf.readInt();
                for (int j = 0; j < organAbilityCount; ++j) {
                    organData.organScores.put(buf.method_10810(), Float.valueOf(buf.readFloat()));
                }
                OrganManager.GeneratedOrganData.put(organID, organData);
            }
            ChestCavity.LOGGER.info("loaded " + organCount + " organs from server");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

