/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.listeners;

import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_5134;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.listeners.OrganUpdateCallback;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;

public class OrganUpdateListeners {
    private static final UUID APPENDIX_ID = UUID.fromString("ac606ec3-4cc3-42b5-9399-7fa8ceba8722");
    private static final UUID HEART_ID = UUID.fromString("edb1e124-a951-48bd-b711-782ec1364722");
    private static final UUID MUSCLE_STRENGTH_ID = UUID.fromString("bf560396-9855-496e-a942-99824467e1ad");
    private static final UUID MUSCLE_SPEED_ID = UUID.fromString("979aa156-3f01-45d3-8784-56185eeef96d");
    private static final UUID SPINE_ATTACK_SPEED_ID = UUID.fromString("709e3e77-0586-4304-80b5-d28bc477e947");
    private static final UUID SPINE_MOVEMENT_ID = UUID.fromString("8f56feed-589f-416f-86c5-315765d41f57");
    private static final UUID KNOCKBACK_RESISTANCE_ID = UUID.fromString("673566d3-5daa-40d7-955f-cbabc27a84cf");

    public static void register() {
        OrganUpdateCallback.EVENT.register(OrganUpdateListeners::UpdateAppendix);
        OrganUpdateCallback.EVENT.register(OrganUpdateListeners::UpdateHeart);
        OrganUpdateCallback.EVENT.register(OrganUpdateListeners::UpdateStrength);
        OrganUpdateCallback.EVENT.register(OrganUpdateListeners::UpdateSpeed);
        OrganUpdateCallback.EVENT.register(OrganUpdateListeners::UpdateSpine);
        OrganUpdateCallback.EVENT.register(OrganUpdateListeners::UpdateKnockbackResistance);
        OrganUpdateCallback.EVENT.register(OrganUpdateListeners::UpdateIncompatibility);
    }

    public static void UpdateAppendix(class_1309 entity, ChestCavityInstance cc) {
        class_1324 att;
        if (cc.getOldOrganScore(CCOrganScores.LUCK) != cc.getOrganScore(CCOrganScores.LUCK) && (att = entity.method_5996(class_5134.field_23726)) != null) {
            class_1322 mod = new class_1322(APPENDIX_ID, "ChestCavityAppendixLuck", (double)((cc.getOrganScore(CCOrganScores.LUCK) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.LUCK)) * ChestCavity.config.APPENDIX_LUCK), class_1322.class_1323.field_6328);
            OrganUpdateListeners.ReplaceAttributeModifier(att, mod);
        }
    }

    public static void UpdateHeart(class_1309 entity, ChestCavityInstance cc) {
        class_1324 att;
        if (cc.getOldOrganScore(CCOrganScores.HEALTH) != cc.getOrganScore(CCOrganScores.HEALTH) && (att = entity.method_5996(class_5134.field_23716)) != null) {
            class_1322 mod = new class_1322(HEART_ID, "ChestCavityHeartMaxHP", (double)((cc.getOrganScore(CCOrganScores.HEALTH) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.HEALTH)) * ChestCavity.config.HEART_HP), class_1322.class_1323.field_6328);
            OrganUpdateListeners.ReplaceAttributeModifier(att, mod);
        }
    }

    public static void UpdateStrength(class_1309 entity, ChestCavityInstance cc) {
        class_1324 att;
        if (cc.getOldOrganScore(CCOrganScores.STRENGTH) != cc.getOrganScore(CCOrganScores.STRENGTH) && (att = entity.method_5996(class_5134.field_23721)) != null) {
            class_1322 mod = new class_1322(MUSCLE_STRENGTH_ID, "ChestCavityMuscleAttackDamage", (double)((cc.getOrganScore(CCOrganScores.STRENGTH) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.STRENGTH)) * ChestCavity.config.MUSCLE_STRENGTH / 8.0f), class_1322.class_1323.field_6330);
            OrganUpdateListeners.ReplaceAttributeModifier(att, mod);
        }
    }

    public static void UpdateSpeed(class_1309 entity, ChestCavityInstance cc) {
        class_1324 att;
        if (cc.getOldOrganScore(CCOrganScores.SPEED) != cc.getOrganScore(CCOrganScores.SPEED) && (att = entity.method_5996(class_5134.field_23719)) != null) {
            class_1322 mod = new class_1322(MUSCLE_SPEED_ID, "ChestCavityMovementSpeed", (double)((cc.getOrganScore(CCOrganScores.SPEED) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.SPEED)) * ChestCavity.config.MUSCLE_SPEED / 8.0f), class_1322.class_1323.field_6330);
            OrganUpdateListeners.ReplaceAttributeModifier(att, mod);
        }
    }

    public static void UpdateSpine(class_1309 entity, ChestCavityInstance cc) {
        if (cc.getOldOrganScore(CCOrganScores.NERVES) != cc.getOrganScore(CCOrganScores.NERVES) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.NERVES) != 0.0f) {
            class_1322 mod;
            class_1324 att = entity.method_5996(class_5134.field_23719);
            if (att != null) {
                mod = new class_1322(SPINE_MOVEMENT_ID, "ChestCavitySpineMovement", cc.getOrganScore(CCOrganScores.NERVES) > 0.0f ? 0.0 : -1.0, class_1322.class_1323.field_6331);
                OrganUpdateListeners.ReplaceAttributeModifier(att, mod);
            }
            if ((att = entity.method_5996(class_5134.field_23723)) != null) {
                mod = new class_1322(SPINE_ATTACK_SPEED_ID, "ChestCavitySpineAttackSpeed", (double)((cc.getOrganScore(CCOrganScores.NERVES) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.NERVES)) * ChestCavity.config.NERVES_HASTE), class_1322.class_1323.field_6330);
                OrganUpdateListeners.ReplaceAttributeModifier(att, mod);
            }
        }
    }

    public static void UpdateKnockbackResistance(class_1309 entity, ChestCavityInstance cc) {
        class_1324 att;
        if (cc.getOldOrganScore(CCOrganScores.KNOCKBACK_RESISTANT) != cc.getOrganScore(CCOrganScores.KNOCKBACK_RESISTANT) && (att = entity.method_5996(class_5134.field_23718)) != null) {
            class_1322 mod = new class_1322(KNOCKBACK_RESISTANCE_ID, "ChestCavityKnockbackResistance", (double)(cc.getOrganScore(CCOrganScores.KNOCKBACK_RESISTANT) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.KNOCKBACK_RESISTANT)) * 0.1, class_1322.class_1323.field_6328);
            OrganUpdateListeners.ReplaceAttributeModifier(att, mod);
        }
    }

    public static void UpdateIncompatibility(class_1309 entity, ChestCavityInstance cc) {
        if (cc.getOldOrganScore(CCOrganScores.INCOMPATIBILITY) != cc.getOrganScore(CCOrganScores.INCOMPATIBILITY)) {
            try {
                entity.method_6016(CCStatusEffects.ORGAN_REJECTION);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void ReplaceAttributeModifier(class_1324 att, class_1322 mod) {
        att.method_6202(mod);
        att.method_26837(mod);
    }
}

