/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1430;
import net.minecraft.class_1472;
import net.minecraft.class_1528;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstanceFactory;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.items.ChestOpener;
import net.tigereye.chestcavity.listeners.OrganFoodEffectCallback;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import net.tigereye.chestcavity.util.NetworkUtil;
import net.tigereye.chestcavity.util.OrganUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class}, priority=900)
public class MixinLivingEntity
extends class_1297
implements ChestCavityEntity {
    private ChestCavityInstance chestCavityInstance;

    protected MixinLivingEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void chestCavityLivingEntityConstructorMixin(class_1299<? extends class_1309> entityType, class_1937 world, CallbackInfo info) {
        this.chestCavityInstance = ChestCavityInstanceFactory.newChestCavityInstance(entityType, (class_1309)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"baseTick"})
    public void chestCavityLivingEntityBaseTickMixin(CallbackInfo info) {
        ChestCavityUtil.onTick(this.chestCavityInstance);
    }

    @Inject(at={@At(value="TAIL")}, method={"baseTick"})
    protected void chestCavityLivingEntityBaseTickBreathAirMixin(CallbackInfo info) {
        if (!this.method_5777(class_3486.field_15517) || this.field_6002.method_8320(new class_2338(this.method_23317(), this.method_23320(), this.method_23321())).method_27852(class_2246.field_10422)) {
            this.method_5855(ChestCavityUtil.applyBreathOnLand(this.chestCavityInstance, this.method_5669(), this.method_6064(0)));
        }
    }

    @ModifyVariable(at=@At(value="CONSTANT", args={"floatValue=0.0F"}, ordinal=0), ordinal=0, method={"applyDamage"})
    public float chestCavityLivingEntityOnHitMixin(float amount, class_1282 source) {
        Optional<ChestCavityEntity> cce;
        if (source.method_5529() instanceof class_1309 && (cce = ChestCavityEntity.of(source.method_5529())).isPresent()) {
            amount = ChestCavityUtil.onHit(cce.get().getChestCavityInstance(), source, (class_1309)this, amount);
        }
        return amount;
    }

    @Inject(at={@At(value="RETURN")}, method={"getNextAirUnderwater"}, cancellable=true)
    protected void chestCavityLivingEntityGetNextAirUnderwaterMixin(int air, CallbackInfoReturnable<Integer> info) {
        info.setReturnValue((Object)ChestCavityUtil.applyBreathInWater(this.chestCavityInstance, air, info.getReturnValueI()));
    }

    @Inject(at={@At(value="RETURN")}, method={"applyArmorToDamage"}, cancellable=true)
    public void chestCavityLivingEntityDamageMixin(class_1282 source, float amount, CallbackInfoReturnable<Float> info) {
        info.setReturnValue((Object)Float.valueOf(ChestCavityUtil.applyDefenses(this.chestCavityInstance, source, info.getReturnValueF())));
    }

    @Inject(at={@At(value="HEAD")}, method={"dropInventory"})
    public void chestCavityLivingEntityDropInventoryMixin(CallbackInfo info) {
        this.chestCavityInstance.getChestCavityType().onDeath(this.chestCavityInstance);
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addStatusEffect"}, ordinal=0)
    public class_1293 chestCavityLivingEntityAddStatusEffectMixin(class_1293 effect) {
        return ChestCavityUtil.onAddStatusEffect(this.chestCavityInstance, effect);
    }

    @ModifyVariable(at=@At(value="STORE"), method={"applyFoodEffects"}, ordinal=0)
    public List<Pair<class_1293, Float>> chestCavityLivingEntityApplyFoodEffectsMixin(List<Pair<class_1293, Float>> list, class_1799 stack, class_1937 world, class_1309 targetEntity) {
        Optional<ChestCavityEntity> option = ChestCavityEntity.of((class_1297)targetEntity);
        if (option.isPresent()) {
            list = new LinkedList<Pair<class_1293, Float>>(list);
            ((OrganFoodEffectCallback)OrganFoodEffectCallback.EVENT.invoker()).onApplyFoodEffects(list, stack, world, targetEntity, option.get().getChestCavityInstance());
        }
        return list;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;updateVelocity(FLnet/minecraft/util/math/Vec3d;)V"), method={"travel"}, index=0, require=0)
    protected float chestCavityLivingEntityWaterTravelMixin(float g) {
        return g * ChestCavityUtil.applySwimSpeedInWater(this.chestCavityInstance);
    }

    @Inject(at={@At(value="RETURN")}, method={"getJumpVelocity"}, cancellable=true)
    public void chestCavityLivingEntityJumpVelocityMixin(CallbackInfoReturnable<Float> info) {
        info.setReturnValue((Object)ChestCavityUtil.applyLeaping(this.chestCavityInstance, info.getReturnValueF()));
    }

    @Override
    public ChestCavityInstance getChestCavityInstance() {
        return this.chestCavityInstance;
    }

    @Override
    public void setChestCavityInstance(ChestCavityInstance chestCavityInstance) {
        this.chestCavityInstance = chestCavityInstance;
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(class_2487 tag, CallbackInfo callbackInfo) {
        this.chestCavityInstance.fromTag(tag, (class_1309)this);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(class_2487 tag, CallbackInfo callbackInfo) {
        this.chestCavityInstance.toTag(tag);
    }

    @Shadow
    protected void method_5693() {
    }

    @Shadow
    protected void method_5749(class_2487 tag) {
    }

    @Shadow
    protected void method_5652(class_2487 tag) {
    }

    @Shadow
    public class_2596<?> method_18002() {
        return null;
    }

    @Shadow
    protected int method_6064(int air) {
        return 0;
    }

    @Mixin(value={class_1528.class})
    private static abstract class Wither
    extends class_1588 {
        protected Wither(class_1299<? extends class_1588> entityType, class_1937 world) {
            super(entityType, world);
        }

        @Inject(method={"dropEquipment"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/boss/WitherEntity;dropItem(Lnet/minecraft/item/ItemConvertible;)Lnet/minecraft/entity/ItemEntity;")}, cancellable=true)
        protected void chestCavityPreventNetherStarDrop(class_1282 source, int lootingMultiplier, boolean allowDrops, CallbackInfo info) {
            Optional<ChestCavityEntity> chestCavityEntity = ChestCavityEntity.of((class_1297)this);
            if (chestCavityEntity.isPresent()) {
                ChestCavityInstance cc = chestCavityEntity.get().getChestCavityInstance();
                if (cc.opened && cc.inventory.method_18861(class_1802.field_8137) == 0) {
                    info.cancel();
                }
            }
        }
    }

    @Mixin(value={class_1472.class})
    private static abstract class Sheep
    extends class_1429 {
        protected Sheep(class_1299<? extends class_1429> entityType, class_1937 world) {
            super(entityType, world);
        }

        @Inject(method={"sheared"}, at={@At(value="HEAD")})
        protected void chestCavitySheared(class_3419 shearedSoundCategory, CallbackInfo info) {
            OrganUtil.shearSilk((class_1309)this);
        }
    }

    @Mixin(value={class_3222.class})
    private static abstract class Server
    extends class_1657 {
        public Server(class_1937 world, class_2338 pos, float yaw, GameProfile profile) {
            super(world, pos, yaw, profile);
        }

        @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
        public void copyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo callbackInfo) {
            ChestCavityEntity.of((class_1297)this).ifPresent(chestCavityEntity -> ChestCavityEntity.of((class_1297)oldPlayer).ifPresent(oldCCPlayerEntityInterface -> chestCavityEntity.getChestCavityInstance().clone(oldCCPlayerEntityInterface.getChestCavityInstance())));
        }

        @Inject(at={@At(value="RETURN")}, method={"moveToWorld"}, cancellable=true)
        public void chestCavityEntityMoveToWorldMixin(class_3218 destination, CallbackInfoReturnable<class_1297> info) {
            class_1297 entity = (class_1297)info.getReturnValue();
            if (entity instanceof ChestCavityEntity && !entity.field_6002.field_9236) {
                NetworkUtil.SendS2CChestCavityUpdatePacket(((ChestCavityEntity)entity).getChestCavityInstance());
            }
        }
    }

    @Mixin(value={class_1548.class})
    private static abstract class Creeper
    extends class_1588 {
        @Shadow
        private int field_7227;

        protected Creeper(class_1299<? extends class_1588> entityType, class_1937 world) {
            super(entityType, world);
        }

        @Inject(at={@At(value="HEAD")}, method={"tick"})
        protected void chestCavityCreeperTickMixin(CallbackInfo info) {
            if (this.method_5805() && this.field_7227 > 1) {
                ChestCavityEntity.of((class_1297)this).ifPresent(cce -> {
                    if (cce.getChestCavityInstance().opened && cce.getChestCavityInstance().getOrganScore(CCOrganScores.CREEPY) <= 0.0f) {
                        this.field_7227 = 1;
                    }
                });
            }
        }
    }

    @Mixin(value={class_1430.class})
    private static abstract class Cow
    extends class_1429 {
        protected Cow(class_1299<? extends class_1429> entityType, class_1937 world) {
            super(entityType, world);
        }

        @Inject(method={"interactMob"}, at={@At(value="RETURN", ordinal=0)})
        protected void interactMob(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
            OrganUtil.milkSilk((class_1309)this);
        }
    }

    @Mixin(value={class_1657.class})
    public static abstract class Player
    extends class_1309 {
        protected Player(class_1299<? extends class_1309> entityType, class_1937 world) {
            super(entityType, world);
        }

        @ModifyVariable(at=@At(value="CONSTANT", args={"floatValue=0.0F"}, ordinal=0), ordinal=0, method={"applyDamage"})
        public float chestCavitPlayerEntityOnHitMixin(float amount, class_1282 source) {
            Optional<ChestCavityEntity> cce;
            if (source.method_5529() instanceof class_1309 && (cce = ChestCavityEntity.of(source.method_5529())).isPresent()) {
                amount = ChestCavityUtil.onHit(cce.get().getChestCavityInstance(), source, this, amount);
            }
            return amount;
        }

        @Inject(at={@At(value="HEAD")}, method={"interact"}, cancellable=true)
        void chestCavityPlayerEntityInteractPlayerMixin(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
            class_1657 player;
            class_1799 stack;
            if (entity instanceof class_1309 && ChestCavity.config.CAN_OPEN_OTHER_PLAYERS && (stack = (player = (class_1657)this).method_5998(hand)).method_7909() == CCItems.CHEST_OPENER) {
                ((ChestOpener)stack.method_7909()).openChestCavity(player, (class_1309)entity);
                info.setReturnValue((Object)class_1269.field_5812);
                info.cancel();
            }
        }

        @Inject(at={@At(value="RETURN")}, method={"getBlockBreakingSpeed"}, cancellable=true)
        void chestCavityPlayerEntityGetBlockBreakingSpeedMixin(class_2680 block, CallbackInfoReturnable<Float> cir) {
            cir.setReturnValue((Object)Float.valueOf(ChestCavityUtil.applyNervesToMining(((ChestCavityEntity)((Object)this)).getChestCavityInstance(), ((Float)cir.getReturnValue()).floatValue())));
        }
    }

    @Mixin(value={class_1308.class})
    private static abstract class Mob
    extends class_1309 {
        protected Mob(class_1299<? extends class_1309> entityType, class_1937 world) {
            super(entityType, world);
        }

        @Inject(at={@At(value="HEAD")}, method={"interactWithItem"}, cancellable=true)
        protected void chestCavityLivingEntityInteractMobMixin(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
            if (player.method_5998(hand).method_7909() == CCItems.CHEST_OPENER && !((class_1309)this instanceof class_1657)) {
                ((ChestOpener)player.method_5998(hand).method_7909()).openChestCavity(player, this);
                info.setReturnValue((Object)class_1269.field_5812);
            }
        }
    }
}

