/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.types.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.types.GeneratedChestCavityType;
import net.tigereye.chestcavity.chestcavities.types.json.ChestCavityTypeJsonFormat;

public class ChestCavityTypeSerializer {
    public GeneratedChestCavityType read(class_2960 id, ChestCavityTypeJsonFormat cctJson) {
        if (cctJson.defaultChestCavity == null) {
            throw new JsonSyntaxException("Chest Cavity Types must have a default chest cavity!");
        }
        if (cctJson.exceptionalOrgans == null) {
            cctJson.exceptionalOrgans = new JsonArray();
        }
        if (cctJson.baseOrganScores == null) {
            cctJson.baseOrganScores = new JsonArray();
        }
        if (cctJson.forbiddenSlots == null) {
            cctJson.forbiddenSlots = new JsonArray();
        }
        GeneratedChestCavityType cct = new GeneratedChestCavityType();
        cct.setForbiddenSlots(this.readForbiddenSlotsFromJson(id, cctJson));
        cct.setDefaultChestCavity(this.readDefaultChestCavityFromJson(id, cctJson, cct.getForbiddenSlots()));
        cct.setBaseOrganScores(this.readBaseOrganScoresFromJson(id, cctJson));
        cct.setExceptionalOrganList(this.readExceptionalOrgansFromJson(id, cctJson));
        cct.setDropRateMultiplier(cctJson.dropRateMultiplier);
        cct.setPlayerChestCavity(cctJson.playerChestCavity);
        cct.setBossChestCavity(cctJson.bossChestCavity);
        return cct;
    }

    private ChestCavityInventory readDefaultChestCavityFromJson(class_2960 id, ChestCavityTypeJsonFormat cctJson, List<Integer> forbiddenSlots) {
        ChestCavityInventory inv = new ChestCavityInventory();
        int i = 0;
        for (JsonElement entry : cctJson.defaultChestCavity) {
            ++i;
            try {
                JsonObject obj = entry.getAsJsonObject();
                if (!obj.has("item")) {
                    ChestCavity.LOGGER.error("Missing item component in entry no." + i + " in " + id.toString() + "'s default chest cavity");
                    continue;
                }
                if (!obj.has("position")) {
                    ChestCavity.LOGGER.error("Missing position component in entry no. " + i + " in " + id.toString() + "'s default chest cavity");
                    continue;
                }
                class_2960 itemID = new class_2960(obj.get("item").getAsString());
                Optional itemOptional = class_2378.field_11142.method_17966(new class_2960(obj.get("item").getAsString()));
                if (itemOptional.isPresent()) {
                    class_1799 stack;
                    class_1792 item = (class_1792)itemOptional.get();
                    if (obj.has("count")) {
                        int count = obj.get("count").getAsInt();
                        stack = new class_1799((class_1935)item, count);
                    } else {
                        stack = new class_1799((class_1935)item, item.method_7882());
                    }
                    int pos = obj.get("position").getAsInt();
                    if (pos >= inv.method_5439()) {
                        ChestCavity.LOGGER.error("Position component is out of bounds in entry no. " + i + " in " + id.toString() + "'s default chest cavity");
                        continue;
                    }
                    if (forbiddenSlots.contains(pos)) {
                        ChestCavity.LOGGER.error("Position component is forbidden in entry no. " + i + " in " + id.toString() + "'s default chest cavity");
                        continue;
                    }
                    inv.method_5447(pos, stack);
                    continue;
                }
                ChestCavity.LOGGER.error("Unknown " + itemID.toString() + " in entry no. " + i + " in " + id.toString() + "'s default chest cavity");
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error parsing entry no. " + i + " in " + id.toString() + "'s default chest cavity");
            }
        }
        return inv;
    }

    private Map<class_2960, Float> readBaseOrganScoresFromJson(class_2960 id, ChestCavityTypeJsonFormat cctJson) {
        return this.readOrganScoresFromJson(id, cctJson.baseOrganScores);
    }

    private Map<class_1856, Map<class_2960, Float>> readExceptionalOrgansFromJson(class_2960 id, ChestCavityTypeJsonFormat cctJson) {
        HashMap<class_1856, Map<class_2960, Float>> exceptionalOrgans = new HashMap<class_1856, Map<class_2960, Float>>();
        int i = 0;
        for (JsonElement entry : cctJson.exceptionalOrgans) {
            ++i;
            try {
                JsonObject obj = entry.getAsJsonObject();
                if (!obj.has("ingredient")) {
                    ChestCavity.LOGGER.error("Missing ingredient component in entry no." + i + " in " + id.toString() + "'s exceptional organs");
                    continue;
                }
                if (!obj.has("value")) {
                    ChestCavity.LOGGER.error("Missing value component in entry no. " + i + " in " + id.toString() + "'s exceptional organs");
                    continue;
                }
                class_1856 ingredient = class_1856.method_8102((JsonElement)obj.get("ingredient"));
                exceptionalOrgans.put(ingredient, this.readOrganScoresFromJson(id, obj.get("value").getAsJsonArray()));
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error parsing entry no. " + i + " in " + id.toString() + "'s exceptional organs");
            }
        }
        return exceptionalOrgans;
    }

    private Map<class_2960, Float> readOrganScoresFromJson(class_2960 id, JsonArray json) {
        HashMap<class_2960, Float> organScores = new HashMap<class_2960, Float>();
        for (JsonElement entry : json) {
            try {
                JsonObject obj = entry.getAsJsonObject();
                if (!obj.has("id")) {
                    ChestCavity.LOGGER.error("Missing id component in " + id.toString() + "'s organ scores");
                    continue;
                }
                if (!obj.has("value")) {
                    ChestCavity.LOGGER.error("Missing value component in " + id.toString() + "'s organ scores");
                    continue;
                }
                class_2960 ability = new class_2960(obj.get("id").getAsString());
                organScores.put(ability, Float.valueOf(obj.get("value").getAsFloat()));
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error parsing " + id.toString() + "'s organ scores!");
            }
        }
        return organScores;
    }

    private List<Integer> readForbiddenSlotsFromJson(class_2960 id, ChestCavityTypeJsonFormat cctJson) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (JsonElement entry : cctJson.forbiddenSlots) {
            try {
                int slot = entry.getAsInt();
                list.add(slot);
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error parsing " + id.toString() + "'s organ scores!");
            }
        }
        return list;
    }
}

