/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1501;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1670;
import net.minecraft.class_1673;
import net.minecraft.class_1674;
import net.minecraft.class_1677;
import net.minecraft.class_1678;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4051;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.server.MinecraftServer;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.interfaces.CCStatusEffectInstance;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.registration.CCEnchantments;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import net.tigereye.chestcavity.util.MathUtil;

public class OrganUtil {
    public static void displayOrganQuality(Map<class_2960, Float> organQualityMap, List<class_2561> tooltip) {
        organQualityMap.forEach((organ, score) -> {
            String tier = organ.equals((Object)CCOrganScores.HYDROALLERGENIC) ? (score.floatValue() >= 2.0f ? "quality.chestcavity.severely" : "") : (score.floatValue() >= 1.5f ? "quality.chestcavity.supernatural" : ((double)score.floatValue() >= 1.25 ? "quality.chestcavity.exceptional" : (score.floatValue() >= 1.0f ? "quality.chestcavity.good" : (score.floatValue() >= 0.75f ? "quality.chestcavity.average" : (score.floatValue() >= 0.5f ? "quality.chestcavity.poor" : (score.floatValue() >= 0.0f ? "quality.chestcavity.pathetic" : (score.floatValue() >= -0.25f ? "quality.chestcavity.slightly_reduces" : (score.floatValue() >= -0.5f ? "quality.chestcavity.reduces" : (score.floatValue() >= -0.75f ? "quality.chestcavity.greatly_reduces" : "quality.chestcavity.greatly_reduces")))))))));
            class_5250 text = class_2561.method_43469((String)("organscore." + organ.method_12836() + "." + organ.method_12832()), (Object[])new Object[]{class_2561.method_43471((String)tier)});
            tooltip.add((class_2561)text);
        });
    }

    public static void displayCompatibility(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        Object textString;
        class_2487 tag = itemStack.method_7969();
        boolean uuidMatch = false;
        int compatLevel = 0;
        class_3222 serverPlayer = null;
        MinecraftServer server = world.method_8503();
        if (server == null) {
            server = class_310.method_1551().method_1576();
        }
        if (server != null) {
            serverPlayer = server.method_3760().method_14566(class_310.method_1551().field_1724.method_5820());
            if (serverPlayer instanceof ChestCavityEntity) {
                ChestCavityEntity ccPlayer = (ChestCavityEntity)serverPlayer;
                UUID ccID = ccPlayer.getChestCavityInstance().compatibility_id;
                compatLevel = ChestCavityUtil.getCompatibilityLevel(ccPlayer.getChestCavityInstance(), itemStack);
            }
        } else {
            compatLevel = -1;
        }
        if (class_1890.method_8225((class_1887)CCEnchantments.MALPRACTICE, (class_1799)itemStack) > 0) {
            textString = "Unsafe to use";
        } else if (tag != null && tag.method_10545(ChestCavity.COMPATIBILITY_TAG.toString()) && class_1890.method_8225((class_1887)CCEnchantments.O_NEGATIVE, (class_1799)itemStack) <= 0) {
            tag = tag.method_10562(ChestCavity.COMPATIBILITY_TAG.toString());
            String name = tag.method_10558("name");
            textString = "Only Compatible With: " + name;
        } else {
            textString = "Safe to Use";
        }
        class_5250 text = class_5250.method_43477((class_7417)class_7417.field_39004);
        if (compatLevel > 0) {
            text.method_27692(class_124.field_1060);
        } else if (compatLevel == 0) {
            text.method_27692(class_124.field_1061);
        } else {
            text.method_27692(class_124.field_1054);
        }
        text.method_27693((String)textString);
        tooltip.add((class_2561)text);
    }

    public static void explode(class_1309 entity, float explosionYield) {
        if (!entity.field_6002.field_9236) {
            class_1927.class_4179 destructionType = entity.field_6002.method_8450().method_8355(class_1928.field_19388) ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_18685;
            entity.field_6002.method_8437(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), (float)Math.sqrt(explosionYield), destructionType);
            OrganUtil.spawnEffectsCloud(entity);
        }
    }

    public static List<class_1293> getStatusEffects(class_1799 organ) {
        class_2487 tag = organ.method_7948();
        if (!tag.method_10573("CustomPotionEffects", 9)) {
            return new ArrayList<class_1293>();
        }
        class_2499 NbtList = tag.method_10554("CustomPotionEffects", 10);
        ArrayList<class_1293> list = new ArrayList<class_1293>();
        for (int i = 0; i < NbtList.size(); ++i) {
            class_2487 NbtCompound = NbtList.method_10602(i);
            class_1293 statusEffectInstance = class_1293.method_5583((class_2487)NbtCompound);
            if (statusEffectInstance == null) continue;
            list.add(statusEffectInstance);
        }
        return list;
    }

    public static void milkSilk(class_1309 entity) {
        if (!entity.method_6059(CCStatusEffects.SILK_COOLDOWN)) {
            ChestCavityEntity.of((class_1297)entity).ifPresent(cce -> {
                ChestCavityInstance cc;
                float silk;
                if (cce.getChestCavityInstance().opened && (silk = (cc = cce.getChestCavityInstance()).getOrganScore(CCOrganScores.SILK)) > 0.0f && OrganUtil.spinWeb(entity, cc, silk)) {
                    entity.method_6092(new class_1293(CCStatusEffects.SILK_COOLDOWN, ChestCavity.config.SILK_COOLDOWN, 0, false, false, true));
                }
            });
        }
    }

    public static void queueDragonBombs(class_1309 entity, ChestCavityInstance cc, int bombs) {
        if (entity instanceof class_1657) {
            ((class_1657)entity).method_7322((float)bombs * 0.6f);
        }
        for (int i = 0; i < bombs; ++i) {
            cc.projectileQueue.add(OrganUtil::spawnDragonBomb);
        }
        entity.method_6092(new class_1293(CCStatusEffects.DRAGON_BOMB_COOLDOWN, ChestCavity.config.DRAGON_BOMB_COOLDOWN, 0, false, false, true));
    }

    public static void queueForcefulSpit(class_1309 entity, ChestCavityInstance cc, int projectiles) {
        if (entity instanceof class_1657) {
            ((class_1657)entity).method_7322((float)projectiles * 0.1f);
        }
        for (int i = 0; i < projectiles; ++i) {
            cc.projectileQueue.add(OrganUtil::spawnSpit);
        }
        entity.method_6092(new class_1293(CCStatusEffects.FORCEFUL_SPIT_COOLDOWN, ChestCavity.config.FORCEFUL_SPIT_COOLDOWN, 0, false, false, true));
    }

    public static void queueGhastlyFireballs(class_1309 entity, ChestCavityInstance cc, int ghastly) {
        if (entity instanceof class_1657) {
            ((class_1657)entity).method_7322((float)ghastly * 0.3f);
        }
        for (int i = 0; i < ghastly; ++i) {
            cc.projectileQueue.add(OrganUtil::spawnGhastlyFireball);
        }
        entity.method_6092(new class_1293(CCStatusEffects.GHASTLY_COOLDOWN, ChestCavity.config.GHASTLY_COOLDOWN, 0, false, false, true));
    }

    public static void queuePyromancyFireballs(class_1309 entity, ChestCavityInstance cc, int pyromancy) {
        if (entity instanceof class_1657) {
            ((class_1657)entity).method_7322((float)pyromancy * 0.1f);
        }
        for (int i = 0; i < pyromancy; ++i) {
            cc.projectileQueue.add(OrganUtil::spawnPyromancyFireball);
        }
        entity.method_6092(new class_1293(CCStatusEffects.PYROMANCY_COOLDOWN, ChestCavity.config.PYROMANCY_COOLDOWN, 0, false, false, true));
    }

    public static void queueShulkerBullets(class_1309 entity, ChestCavityInstance cc, int shulkerBullets) {
        if (entity instanceof class_1657) {
            ((class_1657)entity).method_7322((float)shulkerBullets * 0.3f);
        }
        for (int i = 0; i < shulkerBullets; ++i) {
            cc.projectileQueue.add(OrganUtil::spawnShulkerBullet);
        }
        entity.method_6092(new class_1293(CCStatusEffects.SHULKER_BULLET_COOLDOWN, ChestCavity.config.SHULKER_BULLET_COOLDOWN, 0, false, false, true));
    }

    public static void setStatusEffects(class_1799 organ, class_1799 potion) {
        List potionList = class_1844.method_8067((class_1799)potion);
        ArrayList<class_1293> list = new ArrayList<class_1293>();
        for (class_1293 effect : potionList) {
            class_1293 effectCopy = new class_1293(effect);
            ((CCStatusEffectInstance)effectCopy).CC_setDuration(Math.max(1, effectCopy.method_5584() / 4));
            list.add(effectCopy);
        }
        OrganUtil.setStatusEffects(organ, list);
    }

    public static void setStatusEffects(class_1799 organ, List<class_1293> list) {
        class_2487 tag = organ.method_7948();
        class_2499 NbtList = new class_2499();
        for (int i = 0; i < list.size(); ++i) {
            class_1293 effect = list.get(i);
            if (effect == null) continue;
            class_2487 NbtCompound = new class_2487();
            NbtList.add((Object)effect.method_5582(NbtCompound));
        }
        tag.method_10566("CustomPotionEffects", (class_2520)NbtList);
    }

    public static void shearSilk(class_1309 entity) {
        ChestCavityEntity.of((class_1297)entity).ifPresent(cce -> {
            float silk;
            if (cce.getChestCavityInstance().opened && (silk = cce.getChestCavityInstance().getOrganScore(CCOrganScores.SILK)) > 0.0f) {
                class_1542 itemEntity;
                class_1799 stack;
                if (silk >= 2.0f) {
                    stack = new class_1799((class_1935)class_1802.field_8786, (int)silk / 2);
                    itemEntity = new class_1542(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321(), stack);
                    entity.field_6002.method_8649((class_1297)itemEntity);
                }
                if (silk % 2.0f >= 1.0f) {
                    stack = new class_1799((class_1935)class_1802.field_8276);
                    itemEntity = new class_1542(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321(), stack);
                    entity.field_6002.method_8649((class_1297)itemEntity);
                }
            }
        });
    }

    public static void spawnEffectsCloud(class_1309 entity) {
        Collection collection = entity.method_6026();
        if (!collection.isEmpty()) {
            class_1295 areaEffectCloudEntity = new class_1295(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321());
            areaEffectCloudEntity.method_5603(2.5f);
            areaEffectCloudEntity.method_5609(-0.5f);
            areaEffectCloudEntity.method_5595(10);
            areaEffectCloudEntity.method_5604(areaEffectCloudEntity.method_5605() / 2);
            areaEffectCloudEntity.method_5596(-areaEffectCloudEntity.method_5599() / (float)areaEffectCloudEntity.method_5605());
            for (class_1293 statusEffectInstance : collection) {
                areaEffectCloudEntity.method_5610(new class_1293(statusEffectInstance));
            }
            entity.field_6002.method_8649((class_1297)areaEffectCloudEntity);
        }
    }

    public static void spawnSilk(class_1309 entity) {
        entity.method_5706((class_1935)class_1802.field_8276);
    }

    public static void spawnSpit(class_1309 entity) {
        class_243 entityFacing = entity.method_5720().method_1029();
        class_1501 fakeLlama = new class_1501(class_1299.field_6074, entity.field_6002);
        fakeLlama.method_23327(entity.method_23317(), entity.method_23318(), entity.method_23321());
        fakeLlama.method_36457(entity.method_36455());
        fakeLlama.method_36456(entity.method_36454());
        fakeLlama.field_6283 = entity.field_6283;
        class_1673 llamaSpitEntity = new class_1673(entity.field_6002, fakeLlama);
        llamaSpitEntity.method_7432((class_1297)entity);
        llamaSpitEntity.method_18800(entityFacing.field_1352 * 2.0, entityFacing.field_1351 * 2.0, entityFacing.field_1350 * 2.0);
        entity.field_6002.method_8649((class_1297)llamaSpitEntity);
        entityFacing = entityFacing.method_1021(-0.1);
        entity.method_5762(entityFacing.field_1352, entityFacing.field_1351, entityFacing.field_1350);
    }

    public static void spawnDragonBomb(class_1309 entity) {
        class_243 entityFacing = entity.method_5720().method_1029();
        class_1670 fireballEntity = new class_1670(entity.field_6002, entity, entityFacing.field_1352, entityFacing.field_1351, entityFacing.field_1350);
        fireballEntity.method_30634(fireballEntity.method_23317(), entity.method_23323(0.5) + 0.3, fireballEntity.method_23321());
        entity.field_6002.method_8649((class_1297)fireballEntity);
        entityFacing = entityFacing.method_1021(-0.2);
        entity.method_5762(entityFacing.field_1352, entityFacing.field_1351, entityFacing.field_1350);
    }

    public static void spawnDragonBreath(class_1309 entity) {
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of((class_1297)entity);
        if (optional.isEmpty()) {
            return;
        }
        ChestCavityEntity cce = optional.get();
        ChestCavityInstance cc = cce.getChestCavityInstance();
        float breath = cc.getOrganScore(CCOrganScores.DRAGON_BREATH);
        double range = Math.sqrt(breath / 2.0f) * 5.0;
        class_239 result = entity.method_5745(range, 0.0f, false);
        class_243 pos = result.method_17784();
        double x = pos.field_1352;
        double y = pos.field_1351;
        double z = pos.field_1350;
        class_2338.class_2339 mutable = new class_2338.class_2339(x, y, z);
        while (entity.field_6002.method_22347((class_2338)mutable)) {
            if ((y -= 1.0) < 0.0) {
                return;
            }
            mutable.method_10102(x, y, z);
        }
        y = class_3532.method_15357((double)y) + 1;
        class_1295 breathEntity = new class_1295(entity.field_6002, x, y, z);
        breathEntity.method_5607(entity);
        breathEntity.method_5603((float)Math.max(range / 2.0, Math.min(range, (double)MathUtil.horizontalDistanceTo((class_1297)breathEntity, (class_1297)entity))));
        breathEntity.method_5604(200);
        breathEntity.method_5608((class_2394)class_2398.field_11216);
        breathEntity.method_5610(new class_1293(class_1294.field_5921));
        entity.field_6002.method_8649((class_1297)breathEntity);
    }

    public static void spawnGhastlyFireball(class_1309 entity) {
        class_243 entityFacing = entity.method_5720().method_1029();
        class_1674 fireballEntity = new class_1674(entity.field_6002, entity, entityFacing.field_1352, entityFacing.field_1351, entityFacing.field_1350, 1);
        fireballEntity.method_30634(fireballEntity.method_23317(), entity.method_23323(0.5) + 0.3, fireballEntity.method_23321());
        entity.field_6002.method_8649((class_1297)fireballEntity);
        entityFacing = entityFacing.method_1021(-0.8);
        entity.method_5762(entityFacing.field_1352, entityFacing.field_1351, entityFacing.field_1350);
    }

    public static void spawnPyromancyFireball(class_1309 entity) {
        class_243 entityFacing = entity.method_5720().method_1029();
        class_1677 smallFireballEntity = new class_1677(entity.field_6002, entity, entityFacing.field_1352 + entity.method_6051().method_43059() * 0.1, entityFacing.field_1351, entityFacing.field_1350 + entity.method_6051().method_43059() * 0.1);
        smallFireballEntity.method_30634(smallFireballEntity.method_23317(), entity.method_23323(0.5) + 0.3, smallFireballEntity.method_23321());
        entity.field_6002.method_8649((class_1297)smallFireballEntity);
        entityFacing = entityFacing.method_1021(-0.2);
        entity.method_5762(entityFacing.field_1352, entityFacing.field_1351, entityFacing.field_1350);
    }

    public static void spawnShulkerBullet(class_1309 entity) {
        class_4051 targetPredicate = class_4051.method_36625();
        targetPredicate.method_18418((double)(ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE * 2));
        class_1309 target = entity.field_6002.method_21726(class_1309.class, targetPredicate, entity, entity.method_23317(), entity.method_23318(), entity.method_23321(), new class_238(entity.method_23317() - (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE, entity.method_23318() - (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE, entity.method_23321() - (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE, entity.method_23317() + (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE, entity.method_23318() + (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE, entity.method_23321() + (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE));
        if (target == null) {
            return;
        }
        class_1678 shulkerBulletEntity = new class_1678(entity.field_6002, entity, (class_1297)target, class_2350.class_2351.field_11052);
        shulkerBulletEntity.method_30634(shulkerBulletEntity.method_23317(), entity.method_23323(0.5) + 0.3, shulkerBulletEntity.method_23321());
        entity.field_6002.method_8649((class_1297)shulkerBulletEntity);
    }

    public static boolean spinWeb(class_1309 entity, ChestCavityInstance cc, float silkScore) {
        int hungerCost = 0;
        class_1657 player = null;
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_7344().method_7586() < 6) {
            return false;
        }
        if (silkScore >= 2.0f) {
            class_2338 pos = entity.method_24515().method_10093(entity.method_5735().method_10153());
            if (entity.method_5770().method_8320(pos).method_26215()) {
                if (silkScore >= 3.0f) {
                    hungerCost = 16;
                    silkScore -= 3.0f;
                    entity.method_5770().method_8652(pos, class_2246.field_10446.method_9564(), 2);
                } else {
                    hungerCost = 8;
                    silkScore -= 2.0f;
                    entity.method_5770().method_8652(pos, class_2246.field_10343.method_9564(), 2);
                }
            }
        }
        while (silkScore >= 1.0f) {
            silkScore -= 1.0f;
            hungerCost += 4;
            cc.projectileQueue.add(OrganUtil::spawnSilk);
        }
        if (player != null) {
            player.method_7344().method_7583((float)hungerCost);
        }
        return hungerCost > 0;
    }

    public static boolean teleportRandomly(class_1309 entity, float range) {
        if (!entity.field_6002.method_8608() && entity.method_5805()) {
            for (int i = 0; i < ChestCavity.config.MAX_TELEPORT_ATTEMPTS; ++i) {
                double f;
                double e;
                double d = entity.method_23317() + (entity.method_6051().method_43058() - 0.5) * (double)range;
                if (!OrganUtil.teleportTo(entity, d, e = Math.max(1.0, entity.method_23318() + (entity.method_6051().method_43058() - 0.5) * (double)range), f = entity.method_23321() + (entity.method_6051().method_43058() - 0.5) * (double)range)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean teleportTo(class_1309 entity, double x, double y, double z) {
        if (entity.method_5765()) {
            entity.method_5848();
        }
        class_2338.class_2339 targetPos = new class_2338.class_2339(x, y, z);
        class_2680 blockState = entity.field_6002.method_8320((class_2338)targetPos);
        while (targetPos.method_10264() > 0 && !blockState.method_26207().method_15801() && !blockState.method_26207().method_15797()) {
            targetPos.method_10098(class_2350.field_11033);
            blockState = entity.field_6002.method_8320((class_2338)targetPos);
        }
        if (targetPos.method_10264() <= 0) {
            return false;
        }
        targetPos.method_10098(class_2350.field_11036);
        blockState = entity.field_6002.method_8320((class_2338)targetPos);
        class_2680 blockState2 = entity.field_6002.method_8320(targetPos.method_10084());
        while (blockState.method_26207().method_15801() || blockState.method_26207().method_15797() || blockState2.method_26207().method_15801() || blockState2.method_26207().method_15797()) {
            targetPos.method_10098(class_2350.field_11036);
            blockState = entity.field_6002.method_8320((class_2338)targetPos);
            blockState2 = entity.field_6002.method_8320(targetPos.method_10084());
        }
        if (entity.field_6002.method_8597().comp_643() && targetPos.method_10264() >= entity.field_6002.method_31605()) {
            return false;
        }
        entity.method_20620(x, (double)targetPos.method_10264() + 0.1, z);
        if (!entity.method_5701()) {
            entity.field_6002.method_43128(null, entity.field_6014, entity.field_6036, entity.field_5969, class_3417.field_14879, entity.method_5634(), 1.0f, 1.0f);
            entity.method_5783(class_3417.field_14879, 1.0f, 1.0f);
        }
        return true;
    }
}

