/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.instance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.ChestCavityType;
import net.tigereye.chestcavity.listeners.OrganOnHitContext;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChestCavityInstance
implements IInventoryChangedListener {
    public static final Logger LOGGER = LogManager.getLogger();
    protected ChestCavityType type;
    public LivingEntity owner;
    public UUID compatibility_id;
    public boolean opened = false;
    public ChestCavityInventory inventory = new ChestCavityInventory();
    public Map<ResourceLocation, Float> oldOrganScores = new HashMap<ResourceLocation, Float>();
    protected Map<ResourceLocation, Float> organScores = new HashMap<ResourceLocation, Float>();
    public List<OrganOnHitContext> onHitListeners = new ArrayList<OrganOnHitContext>();
    public LinkedList<Consumer<LivingEntity>> projectileQueue = new LinkedList();
    public int heartBleedTimer = 0;
    public int bloodPoisonTimer = 0;
    public int liverTimer = 0;
    public float metabolismRemainder = 0.0f;
    public float lungRemainder = 0.0f;
    public int projectileCooldown = 0;
    public int furnaceProgress = 0;
    public int photosynthesisProgress = 0;
    public EnderCrystalEntity connectedCrystal = null;
    public boolean updateInstantiated = false;
    public ChestCavityInstance ccBeingOpened = null;

    public ChestCavityInstance(ChestCavityType type, LivingEntity owner) {
        this.type = type;
        this.owner = owner;
        this.compatibility_id = owner.func_110124_au();
        ChestCavityUtil.evaluateChestCavity(this);
    }

    public ChestCavityType getChestCavityType() {
        return this.type;
    }

    public Map<ResourceLocation, Float> getOrganScores() {
        return this.organScores;
    }

    public void setOrganScores(Map<ResourceLocation, Float> organScores) {
        this.organScores = organScores;
    }

    public float getOrganScore(ResourceLocation id) {
        return this.organScores.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public float getOldOrganScore(ResourceLocation id) {
        return this.oldOrganScores.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public void func_76316_a(IInventory sender) {
        ChestCavityUtil.clearForbiddenSlots(this);
        ChestCavityUtil.evaluateChestCavity(this);
    }

    public void fromTag(CompoundNBT tag, LivingEntity owner) {
        CompoundNBT temp;
        LOGGER.debug("[Chest Cavity] Reading ChestCavityManager fromTag");
        this.owner = owner;
        if (tag.func_74764_b("ChestCavity")) {
            ChestCavity.printOnDebug("Found Save Data");
            CompoundNBT ccTag = tag.func_74775_l("ChestCavity");
            this.opened = ccTag.func_74767_n("opened");
            this.heartBleedTimer = ccTag.func_74762_e("HeartTimer");
            this.bloodPoisonTimer = ccTag.func_74762_e("KidneyTimer");
            this.liverTimer = ccTag.func_74762_e("LiverTimer");
            this.metabolismRemainder = ccTag.func_74760_g("MetabolismRemainder");
            this.lungRemainder = ccTag.func_74760_g("LungRemainder");
            this.furnaceProgress = ccTag.func_74762_e("FurnaceProgress");
            this.photosynthesisProgress = ccTag.func_74762_e("PhotosynthesisProgress");
            this.compatibility_id = ccTag.func_74764_b("compatibility_id") ? ccTag.func_186857_a("compatibility_id") : owner.func_110124_au();
            try {
                this.inventory.func_110132_b(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (ccTag.func_74764_b("Inventory")) {
                ListNBT NbtList = ccTag.func_150295_c("Inventory", 10);
                this.inventory.readTags(NbtList);
            } else if (this.opened) {
                LOGGER.warn("[Chest Cavity] " + owner.func_200200_C_().func_150261_e() + "'s Chest Cavity is mangled. It will be replaced");
                ChestCavityUtil.generateChestCavityIfOpened(this);
            }
            this.inventory.func_110134_a(this);
        } else if (tag.func_74764_b("cardinal_components") && (temp = tag.func_74775_l("cardinal_components")).func_74764_b("chestcavity:inventorycomponent") && (temp = tag.func_74775_l("chestcavity:inventorycomponent")).func_74764_b("chestcavity")) {
            LOGGER.info("[Chest Cavity] Found " + owner.func_200200_C_().func_150261_e() + "'s old [Cardinal Components] Chest Cavity.");
            this.opened = true;
            ListNBT NbtList = temp.func_150295_c("Inventory", 10);
            try {
                this.inventory.func_110132_b(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.inventory.readTags(NbtList);
            this.inventory.func_110134_a(this);
        }
        ChestCavityUtil.evaluateChestCavity(this);
    }

    public void toTag(CompoundNBT tag) {
        ChestCavity.printOnDebug("Writing ChestCavityManager toTag");
        CompoundNBT ccTag = new CompoundNBT();
        ccTag.func_74757_a("opened", this.opened);
        ccTag.func_186854_a("compatibility_id", this.compatibility_id);
        ccTag.func_74768_a("HeartTimer", this.heartBleedTimer);
        ccTag.func_74768_a("KidneyTimer", this.bloodPoisonTimer);
        ccTag.func_74768_a("LiverTimer", this.liverTimer);
        ccTag.func_74776_a("MetabolismRemainder", this.metabolismRemainder);
        ccTag.func_74776_a("LungRemainder", this.lungRemainder);
        ccTag.func_74768_a("FurnaceProgress", this.furnaceProgress);
        ccTag.func_74768_a("PhotosynthesisProgress", this.photosynthesisProgress);
        ccTag.func_218657_a("Inventory", (INBT)this.inventory.getTags());
        tag.func_218657_a("ChestCavity", (INBT)ccTag);
    }

    public void clone(ChestCavityInstance other) {
        this.opened = other.opened;
        this.type = other.type;
        this.compatibility_id = other.compatibility_id;
        try {
            this.inventory.func_110132_b(this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            this.inventory.func_70299_a(i, other.inventory.func_70301_a(i));
        }
        this.inventory.readTags(other.inventory.getTags());
        this.inventory.func_110134_a(this);
        this.heartBleedTimer = other.heartBleedTimer;
        this.liverTimer = other.liverTimer;
        this.bloodPoisonTimer = other.bloodPoisonTimer;
        this.metabolismRemainder = other.metabolismRemainder;
        this.lungRemainder = other.lungRemainder;
        this.furnaceProgress = other.furnaceProgress;
        this.connectedCrystal = other.connectedCrystal;
        ChestCavityUtil.evaluateChestCavity(this);
    }
}

