/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.organs;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganJsonFormat;
import net.tigereye.chestcavity.chestcavities.organs.OrganSerializer;
import net.tigereye.chestcavity.util.Pair;

public class OrganManager
implements IResourceManagerReloadListener {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("chestcavity", "organs");
    private final OrganSerializer SERIALIZER = new OrganSerializer();
    public static Map<ResourceLocation, OrganData> GeneratedOrganData = new HashMap<ResourceLocation, OrganData>();

    public void func_195410_a(IResourceManager manager) {
        GeneratedOrganData.clear();
        ChestCavity.LOGGER.info("Loading organs.");
        for (ResourceLocation id : manager.func_199003_a(RESOURCE_LOCATION.func_110623_a(), path -> path.endsWith(".json"))) {
            try {
                InputStream stream = manager.func_199002_a(id).func_199027_b();
                Throwable throwable = null;
                try {
                    InputStreamReader reader = new InputStreamReader(stream);
                    Pair<ResourceLocation, OrganData> organDataPair = this.SERIALIZER.read(id, (OrganJsonFormat)new Gson().fromJson((Reader)reader, OrganJsonFormat.class));
                    GeneratedOrganData.put(organDataPair.getLeft(), organDataPair.getRight());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error occurred while loading resource json " + id.toString(), (Throwable)e);
            }
        }
        ChestCavity.LOGGER.info("Loaded " + GeneratedOrganData.size() + " organs.");
    }

    public static boolean hasEntry(Item item) {
        return GeneratedOrganData.containsKey(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item));
    }

    public static OrganData getEntry(Item item) {
        return GeneratedOrganData.get(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item));
    }

    public static boolean isTrueOrgan(Item item) {
        if (OrganManager.hasEntry(item)) {
            return !OrganManager.getEntry((Item)item).pseudoOrgan;
        }
        return false;
    }
}

