/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.ChestCavityType;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganManager;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.util.ChestCavityUtil;

public class DefaultChestCavityType
implements ChestCavityType {
    private Map<ResourceLocation, Float> defaultOrganScores = null;
    private ChestCavityInventory defaultChestCavity = new ChestCavityInventory();
    private Map<ResourceLocation, Float> baseOrganScores = new HashMap<ResourceLocation, Float>();
    private Map<Ingredient, Map<ResourceLocation, Float>> exceptionalOrganList = new HashMap<Ingredient, Map<ResourceLocation, Float>>();
    private List<ItemStack> droppableOrgans = new LinkedList<ItemStack>();
    private List<Integer> forbiddenSlots = new ArrayList<Integer>();
    private boolean bossChestCavity = false;
    private boolean playerChestCavity = false;

    public DefaultChestCavityType() {
        this.prepareDefaultChestCavity();
    }

    private void prepareDefaultChestCavity() {
        for (int i = 0; i < this.defaultChestCavity.func_70302_i_(); ++i) {
            this.defaultChestCavity.func_70299_a(i, new ItemStack((IItemProvider)Items.field_221582_j, 64));
        }
    }

    @Override
    public Map<ResourceLocation, Float> getDefaultOrganScores() {
        if (this.defaultOrganScores == null) {
            this.defaultOrganScores = new HashMap<ResourceLocation, Float>();
            if (!ChestCavityUtil.determineDefaultOrganScores(this)) {
                this.defaultOrganScores = null;
            }
        }
        return this.defaultOrganScores;
    }

    @Override
    public float getDefaultOrganScore(ResourceLocation id) {
        return this.getDefaultOrganScores().getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public ChestCavityInventory getDefaultChestCavity() {
        return this.defaultChestCavity;
    }

    public void setDefaultChestCavity(ChestCavityInventory inv) {
        this.defaultChestCavity = inv;
    }

    public Map<ResourceLocation, Float> getBaseOrganScores() {
        return this.baseOrganScores;
    }

    public float getBaseOrganScore(ResourceLocation id) {
        return this.getBaseOrganScores().getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public void setBaseOrganScores(Map<ResourceLocation, Float> organScores) {
        this.baseOrganScores = organScores;
    }

    public void setBaseOrganScore(ResourceLocation id, float score) {
        this.baseOrganScores.put(id, Float.valueOf(score));
    }

    public Map<Ingredient, Map<ResourceLocation, Float>> getExceptionalOrganList() {
        return this.exceptionalOrganList;
    }

    public Map<ResourceLocation, Float> getExceptionalOrganScore(ItemStack itemStack) {
        for (Ingredient ingredient : this.getExceptionalOrganList().keySet()) {
            if (!ingredient.test(itemStack)) continue;
            return this.getExceptionalOrganList().get(ingredient);
        }
        return null;
    }

    public void setExceptionalOrganList(Map<Ingredient, Map<ResourceLocation, Float>> list) {
        this.exceptionalOrganList = list;
    }

    public void setExceptionalOrgan(Ingredient ingredient, Map<ResourceLocation, Float> scores) {
        this.exceptionalOrganList.put(ingredient, scores);
    }

    public List<ItemStack> getDroppableOrgans() {
        if (this.droppableOrgans == null) {
            this.deriveDroppableOrgans();
        }
        return this.droppableOrgans;
    }

    public void setDroppableOrgans(List<ItemStack> list) {
        this.droppableOrgans = list;
    }

    private void deriveDroppableOrgans() {
        this.droppableOrgans = new LinkedList<ItemStack>();
        for (int i = 0; i < this.defaultChestCavity.func_70302_i_(); ++i) {
            ItemStack stack = this.defaultChestCavity.func_70301_a(i);
            if (!OrganManager.isTrueOrgan(stack.func_77973_b())) continue;
            this.droppableOrgans.add(stack);
        }
    }

    public List<Integer> getForbiddenSlots() {
        return this.forbiddenSlots;
    }

    public void setForbiddenSlots(List<Integer> list) {
        this.forbiddenSlots = list;
    }

    public void forbidSlot(int slot) {
        this.forbiddenSlots.add(slot);
    }

    public void allowSlot(int slot) {
        int index = this.forbiddenSlots.indexOf(slot);
        if (index != -1) {
            this.forbiddenSlots.remove(index);
        }
    }

    @Override
    public boolean isSlotForbidden(int index) {
        return this.forbiddenSlots.contains(index);
    }

    public boolean isBossChestCavity() {
        return this.bossChestCavity;
    }

    public void setBossChestCavity(boolean bool) {
        this.bossChestCavity = bool;
    }

    public boolean isPlayerChestCavity() {
        return this.playerChestCavity;
    }

    public void setPlayerChestCavity(boolean bool) {
        this.playerChestCavity = bool;
    }

    @Override
    public void fillChestCavityInventory(ChestCavityInventory chestCavity) {
        chestCavity.func_174888_l();
        for (int i = 0; i < chestCavity.func_70302_i_(); ++i) {
            chestCavity.func_70299_a(i, this.defaultChestCavity.func_70301_a(i));
        }
    }

    @Override
    public void loadBaseOrganScores(Map<ResourceLocation, Float> organScores) {
        organScores.clear();
    }

    @Override
    public OrganData catchExceptionalOrgan(ItemStack slot) {
        Map<ResourceLocation, Float> organMap = this.getExceptionalOrganScore(slot);
        if (organMap != null) {
            OrganData organData = new OrganData();
            organData.organScores = organMap;
            organData.pseudoOrgan = true;
            return organData;
        }
        return null;
    }

    @Override
    public List<ItemStack> generateLootDrops(Random random, int looting) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        if (this.playerChestCavity) {
            return loot;
        }
        if (this.bossChestCavity) {
            this.generateGuaranteedOrganDrops(random, looting, loot);
            return loot;
        }
        if (random.nextFloat() < ChestCavity.config.UNIVERSAL_DONOR_RATE + ChestCavity.config.ORGAN_BUNDLE_LOOTING_BOOST * (float)looting) {
            this.generateRareOrganDrops(random, looting, loot);
        }
        return loot;
    }

    public void generateRareOrganDrops(Random random, int looting, List<ItemStack> loot) {
        LinkedList<ItemStack> organPile = new LinkedList<ItemStack>(this.getDroppableOrgans());
        int rolls = 1 + random.nextInt(3) + random.nextInt(3);
        ChestCavityUtil.drawOrgansFromPile(organPile, rolls, random, loot);
    }

    public void generateGuaranteedOrganDrops(Random random, int looting, List<ItemStack> loot) {
        LinkedList<ItemStack> organPile = new LinkedList<ItemStack>(this.getDroppableOrgans());
        int rolls = 3 + random.nextInt(2 + looting) + random.nextInt(2 + looting);
        ChestCavityUtil.drawOrgansFromPile(organPile, rolls, random, loot);
    }

    @Override
    public void setOrganCompatibility(ChestCavityInstance instance) {
        ChestCavityInventory chestCavity = instance.inventory;
        for (int i = 0; i < chestCavity.func_70302_i_(); ++i) {
            ItemStack itemStack = chestCavity.func_70301_a(i);
            if (itemStack == null) continue;
            if (itemStack == ItemStack.field_190927_a) continue;
            CompoundNBT tag = new CompoundNBT();
            tag.func_186854_a("owner", instance.compatibility_id);
            tag.func_74778_a("name", instance.owner.func_145748_c_().getString());
            itemStack.func_77983_a(ChestCavity.COMPATIBILITY_TAG.toString(), (INBT)tag);
        }
    }

    @Override
    public float getHeartBleedCap() {
        if (this.bossChestCavity) {
            return 5.0f;
        }
        return Float.MAX_VALUE;
    }

    @Override
    public boolean isOpenable(ChestCavityInstance instance) {
        boolean weakEnough = instance.owner.func_110143_aJ() <= (float)ChestCavity.config.CHEST_OPENER_ABSOLUTE_HEALTH_THRESHOLD || instance.owner.func_110143_aJ() <= instance.owner.func_110138_aP() * ChestCavity.config.CHEST_OPENER_FRACTIONAL_HEALTH_THRESHOLD;
        boolean chestVulnerable = instance.owner.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
        boolean easeOfAccess = instance.getOrganScore(CCOrganScores.EASE_OF_ACCESS) > 0.0f;
        return chestVulnerable && (easeOfAccess || weakEnough);
    }

    @Override
    public void onDeath(ChestCavityInstance cc) {
        cc.projectileQueue.clear();
        if (cc.connectedCrystal != null) {
            cc.connectedCrystal.func_184516_a(null);
            cc.connectedCrystal = null;
        }
        if (!(!cc.opened || this.playerChestCavity && ChestCavity.config.KEEP_CHEST_CAVITY)) {
            ChestCavityUtil.dropUnboundOrgans(cc);
        }
        if (this.playerChestCavity) {
            ChestCavityUtil.insertWelfareOrgans(cc);
        }
    }
}

